/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared.services.lookup;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class TestingLookupService
implements ILookupService {
    private LookupRow[] m_rows = new LookupRow[0];

    public void initializeService() {
    }

    public LookupRow[] getRows() {
        return this.m_rows;
    }

    public void setRows(LookupRow[] rows) {
        this.m_rows = rows;
    }

    public LookupRow[] getDataByKey(LookupCall call) throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Object key = call.getKey();
        if (key != null) {
            LookupRow[] lookupRowArray = this.getRows();
            int n = lookupRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                LookupRow row = lookupRowArray[n2];
                if (key.equals(row.getKey())) {
                    list.add(row);
                }
                ++n2;
            }
        }
        return list.toArray(new LookupRow[0]);
    }

    public LookupRow[] getDataByRec(LookupCall call) throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Object parentKey = call.getRec();
        if (parentKey == null) {
            LookupRow[] lookupRowArray = this.getRows();
            int n = lookupRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                LookupRow row = lookupRowArray[n2];
                if (row.getParentKey() == null) {
                    list.add(row);
                }
                ++n2;
            }
        } else {
            LookupRow[] lookupRowArray = this.getRows();
            int n = lookupRowArray.length;
            int n3 = 0;
            while (n3 < n) {
                LookupRow row = lookupRowArray[n3];
                if (row.getParentKey() == parentKey) {
                    list.add(row);
                }
                ++n3;
            }
        }
        return list.toArray(new LookupRow[0]);
    }

    public LookupRow[] getDataByText(LookupCall call) throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Pattern p = TestingLookupService.createLowerCaseSearchPattern(call.getText());
        LookupRow[] lookupRowArray = this.getRows();
        int n = lookupRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            LookupRow row = lookupRowArray[n2];
            if (row.getText() != null && p.matcher(row.getText().toLowerCase()).matches()) {
                list.add(row);
            }
            ++n2;
        }
        return list.toArray(new LookupRow[0]);
    }

    public LookupRow[] getDataByAll(LookupCall call) throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Pattern p = TestingLookupService.createLowerCaseSearchPattern(call.getAll());
        LookupRow[] lookupRowArray = this.getRows();
        int n = lookupRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            LookupRow row = lookupRowArray[n2];
            if (row.getText() != null && p.matcher(row.getText().toLowerCase()).matches()) {
                list.add(row);
            }
            ++n2;
        }
        return list.toArray(new LookupRow[0]);
    }

    public static Pattern createLowerCaseSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        if ((s = s.toLowerCase()).indexOf(42) < 0) {
            s = String.valueOf(s) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern((String)s), 32);
    }
}

