/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.smartfield;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.smartfield.MobileSmartFieldProposalFormProvider;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldProposalFormProvider;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.smartfield.IRwtScoutSmartField;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RwtScoutMobileSmartField
extends RwtScoutValueFieldComposite<ISmartField<?>>
implements IRwtScoutSmartField {
    private Composite m_browseIconContainer;
    private Composite m_smartContainer;

    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_smartContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 2048);
        this.m_smartContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getSmartfieldVariant());
        Text textField = new Text(this.m_smartContainer, 0);
        this.getUiEnvironment().getFormToolkit().adapt((Control)textField, false, false);
        textField.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getSmartfieldVariant());
        this.m_browseIconContainer = this.getUiEnvironment().getFormToolkit().createComposite(this.m_smartContainer);
        this.setUiContainer(container);
        this.setUiLabel((ILabelComposite)label);
        this.setUiField((Control)textField);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_smartContainer.setLayoutData((Object)LogicalGridDataBuilder.createField((org.eclipse.scout.rt.client.ui.form.fields.GridData)((IFormField)this.getScoutObject()).getGridData()));
        GridLayout gridLayout = RwtLayoutUtility.createGridLayoutNoSpacing((int)2, (boolean)false);
        gridLayout.marginLeft = 6;
        gridLayout.marginRight = 6;
        this.m_smartContainer.setLayout((Layout)gridLayout);
        GridData textLayoutData = new GridData(4, 0x1000000, true, true);
        textField.setLayoutData((Object)textLayoutData);
        GridData buttonLayoutData = new GridData(0x1000000, 0x1000000, false, false);
        buttonLayoutData.heightHint = 20;
        buttonLayoutData.widthHint = 20;
        this.m_browseIconContainer.setLayoutData((Object)buttonLayoutData);
        textField.addMouseListener((MouseListener)new P_FieldSelectionListener());
        this.m_browseIconContainer.addMouseListener((MouseListener)new P_FieldSelectionListener());
        this.m_smartContainer.addMouseListener((MouseListener)new P_FieldSelectionListener());
    }

    protected String getSmartfieldVariant() {
        return "smartfield";
    }

    protected String getSmartfieldDisabledVariant() {
        return "smartfield-disabled";
    }

    public Text getUiField() {
        return (Text)super.getUiField();
    }

    protected void attachScout() {
        super.attachScout();
        this.setIconIdFromScout(((ISmartField)this.getScoutObject()).getIconId());
        ((ISmartField)this.getScoutObject()).setProposalFormProvider((ISmartFieldProposalFormProvider)new MobileSmartFieldProposalFormProvider());
    }

    protected void setDisplayTextFromScout(String s) {
        if (!CompareUtility.equals((Object)s, (Object)this.getUiField().getText())) {
            if (s == null) {
                s = "";
            }
            this.getUiField().setText(s);
        }
    }

    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.getUiField().setEnabled(true);
        this.getUiField().setEditable(false);
        if (b) {
            this.m_smartContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getSmartfieldVariant());
        } else {
            this.m_smartContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getSmartfieldDisabledVariant());
        }
        this.updateBrowseIconVariant(b, ((ISmartField)this.getScoutObject()).getIconId());
    }

    protected void setFieldEnabled(Control field, boolean enabled) {
    }

    private void updateBrowseIconVariant(boolean enabled, String iconId) {
        if (StringUtility.isNullOrEmpty((String)iconId)) {
            return;
        }
        String variant = iconId;
        if (!enabled) {
            variant = String.valueOf(iconId) + "-disabled";
        }
        this.m_browseIconContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
    }

    protected void setIconIdFromScout(String s) {
        this.updateBrowseIconVariant(((ISmartField)this.getScoutObject()).isEnabled(), s);
    }

    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, (Control)this.m_smartContainer);
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        }
    }

    protected void requestProposalSupportFromUi(final String text, final boolean selectCurrentValue) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ISmartField)RwtScoutMobileSmartField.this.getScoutObject()).getUIFacade().openProposalFromUI(text, selectCurrentValue);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    private class P_FieldSelectionListener
    extends MouseAdapter {
        private static final long serialVersionUID = 1L;

        private P_FieldSelectionListener() {
        }

        public void mouseUp(MouseEvent e) {
            if (!((ISmartField)RwtScoutMobileSmartField.this.getScoutObject()).isEnabled()) {
                return;
            }
            RwtScoutMobileSmartField.this.requestProposalSupportFromUi("*", true);
        }
    }
}

