/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.RowIndexComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.IRwtScoutList;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.ListEx;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtScoutListModel;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.util.UiRedrawHandler;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class RwtScoutList
extends RwtScoutComposite<ITable>
implements IRwtScoutList {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTable.class);
    private P_ScoutTableListener m_scoutTableListener;
    private UiRedrawHandler m_redrawHandler;
    private ListViewer m_uiViewer;
    private String m_variant = "";
    private Set<ITableRowFilter> m_tableRowSelectionFilters;
    private boolean m_preventSelectionHandling;

    public RwtScoutList() {
        this(null);
    }

    public RwtScoutList(String variant) {
        this.m_variant = variant;
        this.m_tableRowSelectionFilters = new HashSet<ITableRowFilter>();
    }

    protected void initializeUi(Composite parent) {
        this.m_redrawHandler = new UiRedrawHandler((Control)parent);
        int style = this.getScoutObject() != null && ((ITable)this.getScoutObject()).isMultiSelect() ? 2 : 4;
        ListEx list = new ListEx(parent, style |= 0x200);
        if (StringUtility.hasText((String)this.m_variant)) {
            list.setData("org.eclipse.rap.rwt.customVariant", this.m_variant);
        }
        list.setData("org.eclipse.rap.rwt.markupEnabled", Boolean.TRUE);
        list.setData("org.eclipse.rap.rwt.markupValidationDisabled", Boolean.TRUE);
        ListViewer viewer = new ListViewer((List)list);
        viewer.setUseHashlookup(true);
        this.setUiTableViewer(viewer);
        this.setUiField((Control)list);
        RwtScoutListModel listModel = this.createUiListModel();
        listModel.setMultiline(((ITable)this.getScoutObject()).isMultilineText());
        viewer.setContentProvider((IContentProvider)listModel);
        viewer.setLabelProvider((IBaseLabelProvider)listModel);
        viewer.setInput((Object)listModel);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new P_RwtSelectionListener());
        P_RwtTableListener rwtTableListener = new P_RwtTableListener();
        list.addListener(4, rwtTableListener);
        list.addListener(8, rwtTableListener);
        list.addSelectionListener((SelectionListener)new P_RwtHyperlinkSelectionListener());
        this.getUiEnvironment().addKeyStroke((Control)list, (IRwtKeyStroke)new RwtKeyStroke(32){

            public void handleUiAction(Event e) {
                RwtScoutList.this.handleUiToggleAcction(e);
            }
        }, false);
    }

    public boolean isUiDisposed() {
        return this.getUiField() == null || this.getUiField().isDisposed();
    }

    protected RwtScoutListModel createUiListModel() {
        return new RwtScoutListModel((ITable)this.getScoutObject(), this);
    }

    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener == null) {
            this.m_scoutTableListener = new P_ScoutTableListener();
            ((ITable)this.getScoutObject()).addUITableListener((TableListener)this.m_scoutTableListener);
        }
        this.setHeaderVisibleFromScout(((ITable)this.getScoutObject()).isHeaderVisible());
        this.setSelectionFromScout(((ITable)this.getScoutObject()).getSelectedRows());
        this.setRowHeightFromScout();
        final IEventHistory h = ((ITable)this.getScoutObject()).getEventHistory();
        if (h != null) {
            this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (TableEvent e : h.getRecentEvents()) {
                        RwtScoutList.this.handleScoutTableEventInUi(e);
                    }
                }
            });
        }
    }

    protected void detachScout() {
        super.detachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener != null) {
            ((ITable)this.getScoutObject()).removeTableListener((TableListener)this.m_scoutTableListener);
            this.m_scoutTableListener = null;
        }
    }

    public ListEx getUiField() {
        return (ListEx)super.getUiField();
    }

    @Override
    public ListViewer getUiTableViewer() {
        return this.m_uiViewer;
    }

    public void setUiTableViewer(ListViewer uiViewer) {
        this.m_uiViewer = uiViewer;
    }

    public ITableRow getUiSelectedRow() {
        ITableRow[] rows = this.getUiSelectedRows();
        if (rows.length > 0) {
            return rows[0];
        }
        return null;
    }

    public ITableRow[] getUiSelectedRows() {
        StructuredSelection uiSelection = (StructuredSelection)this.getUiTableViewer().getSelection();
        TreeSet<ITableRow> sortedRows = new TreeSet<ITableRow>((Comparator<ITableRow>)new RowIndexComparator());
        if (uiSelection != null && !uiSelection.isEmpty()) {
            Object[] objectArray = uiSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ITableRow row = (ITableRow)o;
                sortedRows.add(row);
                ++n2;
            }
        }
        return sortedRows.toArray(new ITableRow[sortedRows.size()]);
    }

    protected void setRowHeightFromScout() {
        int h = ((ITable)this.getScoutObject()).getRowHeightHint();
        if (h <= 0 && ((ITable)this.getScoutObject()).isMultilineText()) {
            h = 40;
        }
        if (h >= 0) {
            this.getUiField().setData("org.eclipse.rap.rwt.customItemHeight", h);
        }
        if (this.isCreated()) {
            this.getUiTableViewer().refresh();
        }
    }

    protected void handleScoutPropertyChange(String propName, Object newValue) {
        if (propName.equals("headerVisible")) {
            this.setHeaderVisibleFromScout((Boolean)newValue);
        } else if (propName.equals("rowHeightHint")) {
            this.setRowHeightFromScout();
        } else if (propName.equals("scrollToSelection")) {
            this.updateScrollToSelectionFromScout();
        }
    }

    protected boolean isHandleScoutTableEvent(TableEvent[] a) {
        TableEvent[] tableEventArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            TableEvent element = tableEventArray[n2];
            switch (element.getType()) {
                case 1: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 200: 
                case 210: 
                case 770: 
                case 780: 
                case 800: 
                case 805: 
                case 830: {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected void handleScoutTableEventInUi(TableEvent e) {
        if (this.isUiDisposed()) {
            return;
        }
        RwtScoutTableEvent uiTableEvent = null;
        switch (e.getType()) {
            case 800: {
                this.getUiField().setFocus();
                break;
            }
            case 830: {
                this.scrollToSelection();
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 200: 
            case 210: {
                uiTableEvent = new RwtScoutTableEvent();
                break;
            }
            case 103: {
                this.setSelectionFromScout(e.getRows());
            }
        }
        if (uiTableEvent != null) {
            ((RwtScoutListModel)this.getUiTableViewer().getContentProvider()).consumeTableModelEvent(uiTableEvent);
            this.getUiTableViewer().refresh();
        }
        switch (e.getType()) {
            case 210: {
                this.setSelectionFromScout(e.getTable().getSelectedRows());
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 200: {
                this.setSelectionFromScout(e.getTable().getSelectedRows());
            }
        }
    }

    protected void setHeaderVisibleFromScout(boolean headerVisible) {
    }

    public void setEnabledFromScout(boolean enabledFromScout) {
        this.getUiField().setEnabled(enabledFromScout);
    }

    protected void setSelectionFromScout(ITableRow[] selectedRows) {
        this.setSelectionFromScout(selectedRows, true);
    }

    protected void setSelectionFromScout(ITableRow[] selectedRows, boolean considerScrollToSelection) {
        if (this.getUiField().isDisposed()) {
            return;
        }
        ITableRow[] uiSelection = this.getUiSelectedRows();
        if (CompareUtility.equals((Object)uiSelection, (Object)selectedRows)) {
            return;
        }
        if (selectedRows == null) {
            selectedRows = new ITableRow[]{};
        }
        this.getUiTableViewer().setSelection((ISelection)new StructuredSelection((Object[])selectedRows), considerScrollToSelection);
        if (considerScrollToSelection) {
            this.updateScrollToSelectionFromScout();
        }
    }

    private void updateScrollToSelectionFromScout() {
        if (((ITable)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void scrollToSelection() {
        if (this.getUiField() != null && !this.getUiField().isDisposed()) {
            this.getUiField().showSelection();
        }
    }

    protected void setContextColumnFromUi() {
        if (this.getScoutObject() == null) {
            return;
        }
        final IColumn finalCol = ((ITable)this.getScoutObject()).getColumnSet().getVisibleColumn(0);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)RwtScoutList.this.getScoutObject()).getUIFacade().setContextColumnFromUI(finalCol);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    private int getVisualCellIndex(TableItem tableItem, int columnIndex) {
        int[] columnOrder;
        int visualCellIndex = columnIndex;
        int[] nArray = columnOrder = tableItem.getParent().getColumnOrder();
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (element == columnIndex) {
                visualCellIndex = columnIndex;
            }
            ++n2;
        }
        return visualCellIndex;
    }

    public void clearSelection() {
        this.getUiField().deselectAll();
    }

    public void restoreSelection() {
        this.setSelectionFromScout(((ITable)this.getScoutObject()).getSelectedRows(), false);
    }

    public void setPreventSelectionHandling(boolean preventSelectionHandling) {
        this.m_preventSelectionHandling = preventSelectionHandling;
    }

    protected void setSelectionFromUi(StructuredSelection selection) {
        if (this.m_preventSelectionHandling) {
            return;
        }
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        ITableRow[] selectedRows = (ITableRow[])RwtUtility.getItemsOfSelection(ITableRow.class, (StructuredSelection)selection);
        final ITableRow[] selectedRowsFiltered = this.filterTableRows(selectedRows);
        if (selectedRows.length > 0 && selectedRowsFiltered.length == 0) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    RwtScoutList.this.addIgnoredScoutEvent(TableEvent.class, "103");
                    ((ITable)RwtScoutList.this.getScoutObject()).getUIFacade().setSelectedRowsFromUI(selectedRowsFiltered);
                }
                finally {
                    RwtScoutList.this.removeIgnoredScoutEvent(TableEvent.class, "103");
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    public void addTableRowSelectionFilter(ITableRowFilter filter) {
        this.m_tableRowSelectionFilters.add(filter);
    }

    public void removeTableRowSelectionFilter(ITableRowFilter filter) {
        this.m_tableRowSelectionFilters.remove(filter);
    }

    private ITableRow[] filterTableRows(ITableRow ... rows) {
        if (rows == null) {
            return new ITableRow[0];
        }
        if (this.m_tableRowSelectionFilters.size() == 0) {
            return rows;
        }
        LinkedList<ITableRow> filteredRows = new LinkedList<ITableRow>();
        ITableRow[] iTableRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            ITableRow row = iTableRowArray[n2];
            boolean accept = false;
            for (ITableRowFilter filter : this.m_tableRowSelectionFilters) {
                accept = filter.accept(row);
                if (!accept) break;
            }
            if (accept) {
                filteredRows.add(row);
            }
            ++n2;
        }
        return filteredRows.toArray(new ITableRow[filteredRows.size()]);
    }

    protected void handleUiRowClick(final ITableRow row) {
        if (this.getScoutObject() == null || row == null) {
            return;
        }
        ITableRow[] filteredRows = this.filterTableRows(row);
        if (filteredRows.length == 0) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)RwtScoutList.this.getScoutObject()).getUIFacade().fireRowClickFromUI(row);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleUiRowAction(final ITableRow row) {
        if (this.getScoutObject() == null || row == null || ((ITable)this.getScoutObject()).isCheckable()) {
            return;
        }
        ITableRow[] filteredRows = this.filterTableRows(row);
        if (filteredRows.length == 0) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)RwtScoutList.this.getScoutObject()).getUIFacade().fireRowActionFromUI(row);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleUiHyperlinkAction(final ITableRow row, String urlText) {
        URL url;
        if (this.getScoutObject() == null) {
            return;
        }
        try {
            url = new URL(urlText);
        }
        catch (MalformedURLException e) {
            LOG.error("Hyperlink could not be activated", (Throwable)e);
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ITable table = (ITable)RwtScoutList.this.getScoutObject();
                table.getUIFacade().fireHyperlinkActionFromUI(row, table.getContextColumn(), url);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleUiToggleAcction(Event e) {
        if (e.doit && ((ITable)this.getScoutObject()).isCheckable() && e.stateMask == 0) {
            switch (e.keyCode) {
                case 32: {
                    ITableRow[] selectedRows = (ITableRow[])RwtUtility.getItemsOfSelection(ITableRow.class, (StructuredSelection)((StructuredSelection)this.getUiTableViewer().getSelection()));
                    if (selectedRows != null && selectedRows.length > 0) {
                        this.handleUiRowClick(selectedRows[0]);
                    }
                    e.doit = false;
                }
            }
        }
    }

    private class P_RwtHyperlinkSelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtHyperlinkSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 0x4000000) {
                String url = event.text;
                ITableRow row = this.extractTableRow(url);
                if (row == null) {
                    throw new RuntimeException("Hyperlink cannot be activated. Could not extract row index from hyperlink: " + url);
                }
                RwtScoutList.this.handleUiHyperlinkAction(row, url);
            }
        }

        private ITableRow extractTableRow(String url) {
            String[] paramPairs = url.split("[\\?\\&]");
            if (paramPairs.length == 0) {
                return null;
            }
            String[] stringArray = paramPairs;
            int n = paramPairs.length;
            int n2 = 0;
            while (n2 < n) {
                String key;
                String paramPair = stringArray[n2];
                String[] param = paramPair.split("=");
                if (param.length == 2 && "1row1Num1".equals(key = param[0])) {
                    String value = param[1];
                    int rowIndex = Integer.parseInt(value);
                    return ((ITable)RwtScoutList.this.getScoutObject()).getRow(rowIndex);
                }
                ++n2;
            }
            return null;
        }
    }

    public class P_RwtSelectionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            RwtScoutList.this.setSelectionFromUi((StructuredSelection)event.getSelection());
        }
    }

    private class P_RwtTableListener
    implements Listener {
        private static final long serialVersionUID = 1L;
        private Boolean m_doubleClicked = Boolean.FALSE;

        private P_RwtTableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            if (!event.doit) {
                return;
            }
            switch (event.type) {
                case 4: {
                    RwtScoutList.this.setContextColumnFromUi();
                    Boolean bl = this.m_doubleClicked;
                    synchronized (bl) {
                        if (this.m_doubleClicked == Boolean.TRUE) {
                            this.m_doubleClicked = Boolean.FALSE;
                            break;
                        }
                    }
                    Point eventPosition = new Point(event.x, event.y);
                    if (RwtScoutList.this.getUiField().getItem(eventPosition) == null) {
                        RwtScoutList.this.getUiTableViewer().setSelection(null);
                        RwtScoutList.this.setSelectionFromUi(new StructuredSelection());
                        break;
                    }
                    StructuredSelection selection = (StructuredSelection)RwtScoutList.this.getUiTableViewer().getSelection();
                    if (selection == null || selection.size() != 1) break;
                    RwtScoutList.this.handleUiRowClick((ITableRow)selection.getFirstElement());
                    break;
                }
                case 8: {
                    Boolean eventPosition = this.m_doubleClicked;
                    synchronized (eventPosition) {
                        this.m_doubleClicked = Boolean.TRUE;
                    }
                    StructuredSelection selection = (StructuredSelection)RwtScoutList.this.getUiTableViewer().getSelection();
                    if (selection == null || selection.size() != 1) break;
                    RwtScoutList.this.handleUiRowAction((ITableRow)selection.getFirstElement());
                }
            }
        }
    }

    private class P_ScoutTableListener
    implements TableListener {
        private P_ScoutTableListener() {
        }

        public void tableChanged(final TableEvent e) {
            if (RwtScoutList.this.isHandleScoutTableEvent(new TableEvent[]{e})) {
                if (RwtScoutList.this.isIgnoredScoutEvent(TableEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RwtScoutList.this.getUpdateUiFromScoutLock().acquire();
                            RwtScoutList.this.handleScoutTableEventInUi(e);
                        }
                        finally {
                            RwtScoutList.this.getUpdateUiFromScoutLock().release();
                        }
                    }
                };
                RwtScoutList.this.getUiEnvironment().invokeUiLater(t);
            }
        }

        public void tableChangedBatch(TableEvent[] a) {
            if (RwtScoutList.this.isHandleScoutTableEvent(a)) {
                final ArrayList<TableEvent> filteredList = new ArrayList<TableEvent>();
                int i = 0;
                while (i < a.length) {
                    if (!RwtScoutList.this.isIgnoredScoutEvent(TableEvent.class, "" + a[i].getType())) {
                        filteredList.add(a[i]);
                    }
                    ++i;
                }
                if (filteredList.size() == 0) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (RwtScoutList.this.isUiDisposed()) {
                            return;
                        }
                        RwtScoutList.this.m_redrawHandler.pushControlChanging();
                        try {
                            try {
                                RwtScoutList.this.getUpdateUiFromScoutLock().acquire();
                                for (TableEvent element : filteredList) {
                                    RwtScoutList.this.handleScoutTableEventInUi(element);
                                }
                            }
                            finally {
                                RwtScoutList.this.getUpdateUiFromScoutLock().release();
                            }
                        }
                        finally {
                            RwtScoutList.this.m_redrawHandler.popControlChanging();
                        }
                    }
                };
                RwtScoutList.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }
}

