/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.MobileTable;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.table.IMobileTableField;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.rap.basic.table.IRwtScoutTable;
import org.eclipse.scout.rt.ui.rap.form.fields.tablefield.IRwtTableStatus;
import org.eclipse.scout.rt.ui.rap.form.fields.tablefield.RwtScoutTableField;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtMobileTableStatus;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtScoutMobileList;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtScoutTableActionBar;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutActionBar;

public class RwtScoutMobileTableField
extends RwtScoutTableField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutMobileTableField.class);
    private MobileTable m_mobileTable;
    private boolean m_columnTransformationEnabled;

    public RwtScoutMobileTableField() {
        this(true);
    }

    public RwtScoutMobileTableField(boolean columnTransformationEnabled) {
        this.m_columnTransformationEnabled = columnTransformationEnabled;
    }

    protected IRwtScoutTable createRwtScoutTable() {
        return new RwtScoutMobileList();
    }

    protected void setTableFromScout(ITable table) {
        if (!this.m_columnTransformationEnabled) {
            super.setTableFromScout(table);
            return;
        }
        this.disposeMobileTable();
        if (table == null) {
            super.setTableFromScout(table);
            return;
        }
        this.m_mobileTable = this.wrapTable(table);
        super.setTableFromScout((ITable)this.m_mobileTable);
    }

    private MobileTable wrapTable(final ITable table) {
        final Holder holder = new Holder(MobileTable.class);
        ClientSyncJob job = new ClientSyncJob("", this.getUiEnvironment().getClientSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                MobileTable wrapperTable = new MobileTable(table);
                try {
                    wrapperTable.setTableChanging(true);
                    wrapperTable.setTableRowFormDisplayHint(((ITableField)RwtScoutMobileTableField.this.getScoutObject()).getForm().getDisplayHint());
                    wrapperTable.setTableRowFormDisplayViewId(((ITableField)RwtScoutMobileTableField.this.getScoutObject()).getForm().getDisplayViewId());
                    wrapperTable.initTable();
                }
                finally {
                    wrapperTable.setTableChanging(false);
                }
                holder.setValue((Object)wrapperTable);
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            LOG.error("Table wrapping interrupted. ", (Throwable)e);
        }
        return (MobileTable)holder.getValue();
    }

    protected IRwtScoutActionBar<? extends IPropertyObserver> createRwtScoutActionBar() {
        boolean actionBarVisible = true;
        if (this.getScoutObject() instanceof IMobileTableField) {
            actionBarVisible = ((IMobileTableField)this.getScoutObject()).isActionBarVisible();
        }
        if (actionBarVisible) {
            RwtScoutTableActionBar actionBar = new RwtScoutTableActionBar();
            actionBar.createUiField(this.getUiContainer(), (IPropertyObserver)((ITableField)this.getScoutObject()), this.getUiEnvironment());
            return actionBar;
        }
        return null;
    }

    protected void detachScout() {
        this.disposeMobileTable();
        super.detachScout();
    }

    private void disposeMobileTable() {
        if (this.m_mobileTable == null) {
            return;
        }
        Runnable job = new Runnable(){

            @Override
            public void run() {
                if (RwtScoutMobileTableField.this.m_mobileTable == null) {
                    return;
                }
                RwtScoutMobileTableField.this.m_mobileTable.dispose();
                RwtScoutMobileTableField.this.m_mobileTable = null;
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    protected boolean dontCreateTableContainer() {
        if (this.getScoutObject() == null) {
            return false;
        }
        return !this.isAnyBorderVisible(((ITableField)this.getScoutObject()).getParentGroupBox());
    }

    private boolean isAnyBorderVisible(IGroupBox groupBox) {
        while (groupBox != null) {
            if (groupBox.isBorderVisible()) {
                return true;
            }
            groupBox = groupBox.getParentGroupBox();
        }
        return false;
    }

    protected IRwtTableStatus createRwtTableStatus() {
        return new RwtMobileTableStatus(this.getUiContainer(), this.getUiEnvironment(), (ITableField)this.getScoutObject());
    }
}

