/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.treefield;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.client.mobile.ui.action.ActionButtonBarUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.mobile.action.AbstractRwtScoutActionBar;
import org.eclipse.swt.widgets.Composite;

public class RwtScoutTreeActionBar
extends AbstractRwtScoutActionBar<ITreeField> {
    private P_TreeNodeSelectionListener m_nodeSelectionListener;
    private ITree m_tree;

    public RwtScoutTreeActionBar() {
        this.setMenuOpeningDirection(128);
    }

    @Override
    protected void initLayout(Composite container) {
        super.initLayout(container);
        LogicalGridData tableGridData = LogicalGridDataBuilder.createField((GridData)((ITreeField)this.getScoutObject()).getGridData());
        LogicalGridData gd = new LogicalGridData();
        gd.gridx = tableGridData.gridx;
        gd.gridy = tableGridData.gridy + tableGridData.gridh;
        gd.gridw = tableGridData.gridw;
        gd.topInset = 0;
        gd.gridh = 1;
        if (this.getHeightHint() != null) {
            gd.heightHint = this.getHeightHint();
        } else {
            gd.useUiHeight = true;
        }
        gd.weightx = tableGridData.weightx;
        gd.weighty = 0.0;
        gd.fillHorizontal = true;
        container.setLayoutData((Object)gd);
    }

    @Override
    protected void collectMenusForLeftButtonBar(List<IMenu> menuList) {
        IMenu[] rowMenus;
        ITree tree = ((ITreeField)this.getScoutObject()).getTree();
        if (tree == null) {
            return;
        }
        IMenu[] emptySpaceMenus = RwtMenuUtility.collectEmptySpaceMenus((ITree)tree, (IRwtEnvironment)this.getUiEnvironment());
        if (emptySpaceMenus != null) {
            menuList.addAll(Arrays.asList(emptySpaceMenus));
        }
        if ((rowMenus = RwtMenuUtility.collectNodeMenus((ITree)tree, (IRwtEnvironment)this.getUiEnvironment())) != null) {
            LinkedList<IMenu> rowMenuList = new LinkedList<IMenu>(Arrays.asList(rowMenus));
            ActionButtonBarUtility.distributeRowActions(menuList, (IMenu[])emptySpaceMenus, rowMenuList);
            menuList.addAll(rowMenuList);
        }
    }

    @Override
    protected void collectMenusForRightButtonBar(List<IMenu> menuList) {
    }

    protected void attachScout() {
        super.attachScout();
        this.m_tree = ((ITreeField)this.getScoutObject()).getTree();
        this.addRowSelectionListener(this.m_tree);
    }

    protected void detachScout() {
        super.detachScout();
        this.removeRowSelectionListener(this.m_tree);
        this.m_tree = null;
    }

    private void addRowSelectionListener(ITree tree) {
        if (this.m_nodeSelectionListener != null || tree == null) {
            return;
        }
        this.m_nodeSelectionListener = new P_TreeNodeSelectionListener();
        tree.addTreeListener((TreeListener)this.m_nodeSelectionListener);
    }

    private void removeRowSelectionListener(ITree tree) {
        if (this.m_nodeSelectionListener == null || tree == null) {
            return;
        }
        tree.removeTreeListener((TreeListener)this.m_nodeSelectionListener);
        this.m_nodeSelectionListener = null;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("tree")) {
            this.removeRowSelectionListener(this.m_tree);
            this.m_tree = (ITree)newValue;
            this.addRowSelectionListener(this.m_tree);
        }
    }

    private class P_TreeNodeSelectionListener
    extends TreeAdapter {
        private P_TreeNodeSelectionListener() {
        }

        public void treeChanged(TreeEvent e) {
            if (e.getType() == 40) {
                this.rowSelected();
            }
        }

        private void rowSelected() {
            RwtScoutTreeActionBar.this.rebuildContentFromScout();
        }
    }
}

