/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.workbench.window.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.util.ScoutFormToolkit;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.workbench.IRwtWorkbenchEnvironment;
import org.eclipse.scout.rt.ui.rap.workbench.util.listener.PartListener;
import org.eclipse.scout.rt.ui.rap.workbench.window.view.ViewStackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractScoutView
extends ViewPart
implements IRwtScoutPart,
ISaveablePart2 {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractScoutView.class);
    private IRwtWorkbenchEnvironment m_uiEnvironment;
    private P_ViewListener m_viewListener;
    private OptimisticLock m_closeLock;
    private OptimisticLock m_closeFromModel = new OptimisticLock();
    private OptimisticLock m_layoutLock = new OptimisticLock();
    private Form m_rootForm;
    private Composite m_rootArea;
    private IForm m_scoutForm;
    private PropertyChangeListener m_formPropertyListener = new P_ScoutPropertyChangeListener();

    public AbstractScoutView() {
        this.m_closeLock = new OptimisticLock();
    }

    public void setBusy(boolean b) {
    }

    protected void attatchListeners() {
        if (this.m_viewListener == null) {
            this.m_viewListener = new P_ViewListener();
        }
        this.getSite().getPage().addPartListener((IPartListener2)this.m_viewListener);
    }

    protected void detachListeners() {
        if (this.m_viewListener != null) {
            this.getSite().getPage().removePartListener((IPartListener2)this.m_viewListener);
        }
    }

    public void dispose() {
        this.detachListeners();
        super.dispose();
    }

    public void showPart() {
    }

    public void showForm(IForm scoutForm) {
        if (this.m_scoutForm != null) {
            LOG.warn("The view 'ID=" + this.getViewSite().getId() + "' is already open. The form '" + scoutForm.getTitle() + " (" + scoutForm.getClass().getName() + ")' can not be opened!");
            this.detachScout(this.m_scoutForm);
            this.m_scoutForm = null;
        }
        this.m_scoutForm = scoutForm;
        try {
            this.m_layoutLock.acquire();
            this.getUiContentPane().setRedraw(false);
            this.getUiEnvironment().createForm(this.getUiContentPane(), scoutForm);
            this.attachScout(this.m_scoutForm);
        }
        finally {
            this.m_layoutLock.release();
            this.getUiContentPane().setRedraw(true);
            this.getUiContentPane().layout(true, true);
        }
    }

    public void closePart() {
        try {
            this.m_closeFromModel.acquire();
            if (this.m_closeLock.acquire()) {
                try {
                    this.getSite().getPage().hideView((IViewPart)this);
                }
                catch (Exception e) {
                    LOG.error("could not close view '" + this.getViewSite().getId() + "'.", (Throwable)e);
                }
            }
            if (this.m_scoutForm != null) {
                this.detachScout(this.m_scoutForm);
                this.m_scoutForm = null;
            }
        }
        finally {
            this.m_closeLock.release();
            this.m_closeFromModel.release();
        }
    }

    public IForm getScoutObject() {
        return this.m_scoutForm;
    }

    protected void attachScout(IForm form) {
        this.setTitleFromScout(form.getTitle());
        this.setImageFromScout(form.getIconId());
        this.setMaximizeEnabledFromScout(form.isMaximizeEnabled());
        this.setMaximizedFromScout(form.isMaximized());
        this.setMinimizeEnabledFromScout(form.isMinimizeEnabled());
        this.setMinimizedFromScout(form.isMinimized());
        boolean closable = false;
        IFormField[] iFormFieldArray = form.getAllFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isEnabled() && f.isVisible() && f instanceof IButton) {
                switch (((IButton)f).getSystemType()) {
                    case 1: 
                    case 2: {
                        closable = true;
                    }
                }
            }
            if (closable) break;
            ++n2;
        }
        this.setCloseEnabledFromScout(closable);
        form.addPropertyChangeListener(this.m_formPropertyListener);
    }

    protected void detachScout(IForm form) {
        form.removePropertyChangeListener(this.m_formPropertyListener);
    }

    protected void setImageFromScout(String iconId) {
        IForm form = this.getScoutObject();
        if (form == null) {
            return;
        }
        Image img = this.getUiEnvironment().getIcon(iconId);
        this.setTitleImage(img);
        String subTitle = form.getSubTitle();
        if (subTitle != null) {
            this.getUiForm().setImage(img);
        } else {
            this.getUiForm().setImage(null);
        }
    }

    protected void setTitleFromScout(String title) {
        IForm form = this.getScoutObject();
        if (form == null) {
            return;
        }
        String basicTitle = form.getBasicTitle();
        this.setPartName(StringUtility.removeNewLines((String)(basicTitle != null ? basicTitle : "")));
        String subTitle = form.getSubTitle();
        if (subTitle != null) {
            this.getUiForm().setText(RwtUtility.escapeMnemonics((String)StringUtility.removeNewLines((String)(subTitle != null ? subTitle : ""))));
        } else {
            this.getUiForm().setText(null);
        }
    }

    protected void setMaximizeEnabledFromScout(boolean maximizable) {
    }

    protected void setMaximizedFromScout(boolean maximized) {
        IWorkbenchPartReference ref = this.getSite().getPage().getReference(this.getSite().getPart());
        try {
            if (maximized) {
                this.getSite().getPage().setPartState(ref, 1);
            } else {
                this.getSite().getPage().setPartState(ref, 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setMinimizeEnabledFromScout(boolean minized) {
    }

    protected void setMinimizedFromScout(boolean minimized) {
    }

    protected void setCloseEnabledFromScout(boolean closebale) {
    }

    public void createPartControl(Composite parent) {
        ScoutFormToolkit toolkit = this.getUiEnvironment().getFormToolkit();
        this.m_rootForm = toolkit.createForm(parent);
        this.m_rootArea = this.m_rootForm.getBody();
        this.m_rootArea.setLayout((Layout)new ViewStackLayout());
        this.attatchListeners();
    }

    public Form getUiForm() {
        return this.getRootForm();
    }

    public Composite getUiContainer() {
        return this.getUiForm();
    }

    protected Form getRootForm() {
        return this.m_rootForm;
    }

    protected Composite getRootArea() {
        return this.m_rootArea;
    }

    public void setFocus() {
        this.m_rootArea.setFocus();
    }

    public Composite getUiContentPane() {
        return this.m_rootArea;
    }

    protected abstract IRwtWorkbenchEnvironment getUiEnvironmentInternal();

    protected IRwtWorkbenchEnvironment getUiEnvironment() {
        if (this.m_uiEnvironment == null) {
            this.m_uiEnvironment = this.getUiEnvironmentInternal();
        }
        return this.m_uiEnvironment;
    }

    public boolean isVisible() {
        return this.getSite().getPage().isPartVisible(this.getSite().getPart());
    }

    public void activate() {
        if (this.getSite().getPage().getViewStack((IViewPart)this) != null) {
            this.getSite().getPage().activate(this.getSite().getPart());
        }
    }

    public boolean isActive() {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return false;
        }
        IWorkbenchPage activePage = w.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage == this.getSite().getPage() && activePage.getActivePart() == this;
    }

    public boolean setStatusLineMessage(Image image, String message) {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(image, message);
        return true;
    }

    protected void firePartActivatedFromUI() {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                if (AbstractScoutView.this.m_scoutForm != null) {
                    AbstractScoutView.this.getUiEnvironment().acquireActivateViewLock();
                    try {
                        AbstractScoutView.this.m_scoutForm.getUIFacade().fireFormActivatedFromUI();
                    }
                    finally {
                        AbstractScoutView.this.getUiEnvironment().releaseActivateViewLock();
                    }
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    public int promptToSaveOnClose() {
        if (this.m_scoutForm == null) {
            return 1;
        }
        if (this.m_closeFromModel.isReleased()) {
            new ClientSyncJob("Prompt to save", this.getUiEnvironment().getClientSession()){

                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    if (AbstractScoutView.this.m_scoutForm != null) {
                        AbstractScoutView.this.m_scoutForm.getUIFacade().fireFormClosingFromUI();
                    }
                }
            }.schedule();
            return 2;
        }
        return 0;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        if (this.m_scoutForm != null && this.m_scoutForm.isAskIfNeedSave()) {
            boolean saveNeeded = this.m_scoutForm.isSaveNeeded();
            return saveNeeded;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("title")) {
            this.setTitleFromScout((String)newValue);
        } else if (name.equals("iconId")) {
            this.setImageFromScout((String)newValue);
        } else if (name.equals("minimizeEnabled")) {
            this.setMinimizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("maximizeEnabled")) {
            this.setMaximizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("minimized")) {
            this.setMinimizedFromScout((Boolean)newValue);
        } else if (name.equals("maximized")) {
            this.setMaximizedFromScout((Boolean)newValue);
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    AbstractScoutView.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                }
            };
            AbstractScoutView.this.getUiEnvironment().invokeUiLater(t);
        }
    }

    private class P_ViewListener
    extends PartListener {
        private P_ViewListener() {
        }

        @Override
        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false).equals(AbstractScoutView.this.getViewSite().getPart()) && AbstractScoutView.this.getUiEnvironment().isInitialized()) {
                AbstractScoutView.this.firePartActivatedFromUI();
            }
        }

        @Override
        public void partClosed(IWorkbenchPartReference partRef) {
            if (AbstractScoutView.this.getViewSite().getPart().equals(partRef.getPart(false))) {
                try {
                    if (AbstractScoutView.this.m_closeLock.acquire()) {
                        Runnable job = new Runnable(){

                            @Override
                            public void run() {
                                if (AbstractScoutView.this.m_scoutForm != null) {
                                    AbstractScoutView.this.m_scoutForm.getUIFacade().fireFormKilledFromUI();
                                }
                            }
                        };
                        if (AbstractScoutView.this.getUiEnvironment().isInitialized()) {
                            AbstractScoutView.this.getUiEnvironment().invokeScoutLater(job, 0L);
                        }
                    }
                }
                finally {
                    AbstractScoutView.this.m_closeLock.release();
                }
            }
        }
    }
}

