/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.comp;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CLabelEx
extends CLabel {
    private static final long serialVersionUID = 1L;
    private static final String ELLIPSIS = "...";
    private String m_originalText = "";
    private String m_originalTooltip;
    private Image m_originalImage;

    public CLabelEx(Composite parent, int style) {
        super(parent, style | 0x80000);
        this.addListener(11, new P_ResizeListener());
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        if (bounds.width > 0) {
            this.updateText(bounds.width);
        }
    }

    public void setText(String text) {
        super.setText(text);
        this.m_originalText = text;
    }

    public void setToolTipText(String tooltip) {
        super.setToolTipText(tooltip);
        this.m_originalTooltip = tooltip;
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.m_originalImage = image;
    }

    private void updateText(int labelWidth) {
        Image image = this.getImage();
        int availableWidth = Math.max(0, labelWidth - (this.getLeftMargin() + this.getRightMargin()));
        Point extent = TextSizeUtil.stringExtent((Font)this.getFont(), (String)this.m_originalText);
        int imageWidth = 0;
        if (image != null) {
            Rectangle r = image.getBounds();
            imageWidth = r.width;
        }
        if (extent.x > availableWidth - imageWidth) {
            super.setImage(null);
            if (extent.x > availableWidth) {
                super.setText(this.shortenText(null, this.m_originalText, availableWidth));
                super.setToolTipText(this.m_originalText);
            } else {
                super.setText(this.m_originalText);
                super.setToolTipText(this.m_originalTooltip);
            }
        } else {
            super.setText(this.m_originalText);
            super.setToolTipText(this.m_originalTooltip);
            super.setImage(this.m_originalImage);
        }
    }

    public String shortenText(Object gc, String text, int width) {
        if (text == null || width <= 0) {
            return null;
        }
        int ecllipsisWidth = TextSizeUtil.stringExtent((Font)this.getFont(), (String)ELLIPSIS).x;
        int charCount = text.length();
        while (charCount >= 0) {
            String shortenedText = text.substring(0, charCount);
            int textWidth = TextSizeUtil.stringExtent((Font)this.getFont(), (String)shortenedText).x;
            if (textWidth + ecllipsisWidth < width) {
                return String.valueOf(shortenedText) + ELLIPSIS;
            }
            if (charCount == 0) {
                return "";
            }
            --charCount;
        }
        return null;
    }

    private class P_ResizeListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_ResizeListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 11) {
                CLabelEx.this.updateText(CLabelEx.this.getBounds().width);
            }
        }
    }
}

