/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.RowIndexComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ICustomColumn;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.table.AbstractTableKeyboardNavigationSupport;
import org.eclipse.scout.rt.ui.rap.basic.table.IRwtScoutTableForPatch;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutColumnModel;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableModel;
import org.eclipse.scout.rt.ui.rap.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutTableCellEditor;
import org.eclipse.scout.rt.ui.rap.ext.MenuAdapterEx;
import org.eclipse.scout.rt.ui.rap.ext.table.TableEx;
import org.eclipse.scout.rt.ui.rap.ext.table.TableViewerEx;
import org.eclipse.scout.rt.ui.rap.ext.table.util.TableRolloverSupport;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.AbstractRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.util.UiRedrawHandler;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RwtScoutTable
extends RwtScoutComposite<ITable>
implements IRwtScoutTableForPatch {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTable.class);
    private P_ScoutTableListener m_scoutTableListener;
    private UiRedrawHandler m_redrawHandler;
    private Listener m_autoResizeColumnListener;
    private Listener m_columnListener = new P_TableColumnListener();
    private SelectionListener m_columnSortListener = new P_ColumnSortListener();
    private TableColumnManager m_uiColumnManager = new TableColumnManager();
    private RwtScoutTableCellEditor m_uiCellEditorComposite;
    private int[] m_uiColumnOrder;
    private TableViewer m_uiViewer;
    private IRwtKeyStroke[] m_uiKeyStrokes;
    private ClientSyncJob m_storeColumnWidthsJob;
    private RwtScoutColumnModel m_columnModel = null;
    private String m_variant = "";
    private AbstractTableKeyboardNavigationSupport m_keyboardNavigationSupport;

    public RwtScoutTable() {
    }

    public RwtScoutTable(String variant) {
        this.m_variant = variant;
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_redrawHandler = new UiRedrawHandler((Control)parent);
        int style = this.getScoutObject() != null && ((ITable)this.getScoutObject()).isMultiSelect() ? 2 : 4;
        TableEx table = this.getUiEnvironment().getFormToolkit().createTable(parent, style |= 0x10300);
        if (StringUtility.hasText((String)this.m_variant)) {
            table.setData("org.eclipse.rap.rwt.customVariant", this.m_variant);
        }
        table.setData("org.eclipse.rap.rwt.markupEnabled", Boolean.TRUE);
        table.setData("org.eclipse.rap.rwt.markupValidationDisabled", Boolean.TRUE);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setTouchEnabled(RwtUtility.getBrowserInfo().isTablet() || RwtUtility.getBrowserInfo().isMobile());
        new TableRolloverSupport(table);
        TableViewerEx viewer = new TableViewerEx(table);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        viewer.setUseHashlookup(true);
        this.setUiTableViewer(viewer);
        this.setUiField((Control)table);
        this.m_uiCellEditorComposite = new RwtScoutTableCellEditor(this);
        this.initializeUiColumns();
        RwtScoutTableModel tableModel = this.createUiTableModel();
        viewer.setContentProvider((IContentProvider)tableModel);
        viewer.setInput(tableModel);
        viewer.addSelectionChangedListener(new P_RwtSelectionChangedListener());
        P_RwtTableListener rwtTableListener = new P_RwtTableListener();
        table.addListener(3, rwtTableListener);
        table.addListener(4, rwtTableListener);
        table.addListener(8, rwtTableListener);
        table.addListener(35, rwtTableListener);
        table.addListener(11, rwtTableListener);
        table.addSelectionListener((SelectionListener)new P_RwtHyperlinkSelectionListener());
        this.getUiEnvironment().addKeyStroke((Control)table, new RwtKeyStroke(32){

            @Override
            public void handleUiAction(Event e) {
                RwtScoutTable.this.handleUiToggleAcction(e);
            }
        }, false);
    }

    @Override
    public boolean isUiDisposed() {
        return this.getUiField() == null || this.getUiField().isDisposed();
    }

    protected RwtScoutTableModel createUiTableModel() {
        return new RwtScoutTableModel((ITable)this.getScoutObject(), this, this.m_uiColumnManager);
    }

    protected RwtScoutColumnModel getUiColumnModel() {
        if (this.m_columnModel == null) {
            this.m_columnModel = new RwtScoutColumnModel((ITable)this.getScoutObject(), this, this.m_uiColumnManager);
        }
        return this.m_columnModel;
    }

    @Override
    public TableColumnManager getUiColumnManager() {
        return this.m_uiColumnManager;
    }

    @Override
    public void initializeUiColumns() {
        this.m_redrawHandler.pushControlChanging();
        try {
            IColumn[] scoutColumnsOrdered;
            TableColumn[] tableColumnArray = this.getUiField().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                col.dispose();
                ++n2;
            }
            TableColumn dummyCol = new TableColumn((Table)this.getUiField(), 16384);
            dummyCol.setWidth(0);
            dummyCol.setResizable(false);
            dummyCol.setMoveable(false);
            boolean sortEnabled = false;
            if (this.getScoutObject() != null) {
                scoutColumnsOrdered = ((ITable)this.getScoutObject()).getColumnSet().getVisibleColumns();
                sortEnabled = ((ITable)this.getScoutObject()).isSortEnabled();
            } else {
                scoutColumnsOrdered = new IColumn[]{};
            }
            if (this.m_uiColumnManager == null) {
                this.m_uiColumnManager = new TableColumnManager();
            }
            this.m_uiColumnManager.initialize(scoutColumnsOrdered);
            boolean multilineHeaders = false;
            IColumn[] iColumnArray = scoutColumnsOrdered;
            int n3 = scoutColumnsOrdered.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean isHtml;
                IColumn scoutColumn = iColumnArray[n4];
                IHeaderCell cell = scoutColumn.getHeaderCell();
                String cellText = cell.getText();
                if (cellText == null) {
                    cellText = "";
                }
                if (!(isHtml = HtmlTextUtility.isTextWithHtmlMarkup(cellText)) && cellText.indexOf("\n") >= 0) {
                    multilineHeaders = true;
                }
                if (isHtml) {
                    multilineHeaders = true;
                    cellText = this.getUiEnvironment().adaptHtmlCell(this, cellText);
                }
                int style = RwtUtility.getHorizontalAlignment(cell.getHorizontalAlignment());
                TableColumn rwtCol = new TableColumn((Table)this.getUiField(), style);
                TableViewerColumn rwtViewerCol = new TableViewerColumn(this.getUiTableViewer(), rwtCol);
                rwtViewerCol.setLabelProvider((CellLabelProvider)this.getUiColumnModel());
                rwtCol.setData("scoutColumn", (Object)scoutColumn);
                rwtCol.setMoveable(true);
                rwtCol.setToolTipText(cell.getTooltipText());
                this.updateHeaderText(rwtCol, scoutColumn);
                rwtCol.setWidth(scoutColumn.getWidth());
                if (scoutColumn.isFixedWidth()) {
                    rwtCol.setResizable(false);
                }
                if (cell.isSortActive()) {
                    this.getUiField().setSortColumn(rwtCol);
                    this.getUiField().setSortDirection(cell.isSortAscending() ? 128 : 1024);
                }
                if (sortEnabled) {
                    rwtCol.addSelectionListener(this.m_columnSortListener);
                }
                rwtCol.addListener(10, this.m_columnListener);
                rwtCol.addListener(11, this.m_columnListener);
                ++n4;
            }
            if (multilineHeaders) {
                this.getUiField().setData("multiLineHeader", Boolean.TRUE);
            }
            this.m_uiColumnOrder = this.getUiField().getColumnOrder();
            this.m_uiCellEditorComposite.initializeUi();
        }
        finally {
            this.m_redrawHandler.popControlChanging();
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener == null) {
            this.m_scoutTableListener = new P_ScoutTableListener();
            ((ITable)this.getScoutObject()).addUITableListener((TableListener)this.m_scoutTableListener);
        }
        this.setHeaderVisibleFromScout(((ITable)this.getScoutObject()).isHeaderVisible());
        this.setSelectionFromScout(((ITable)this.getScoutObject()).getSelectedRows());
        this.setKeyStrokeFormScout();
        this.setRowHeightFromScout();
        this.setKeyboardNavigationFromScout();
        this.updateAutoResizeColumnsFromScout();
        this.attachDndSupport();
        this.handleEventsFromRecentHistory();
    }

    private void handleEventsFromRecentHistory() {
        final IEventHistory h = ((ITable)this.getScoutObject()).getEventHistory();
        if (h == null) {
            return;
        }
        this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (TableEvent e : h.getRecentEvents()) {
                    RwtScoutTable.this.handleScoutTableEventInUi(e);
                }
            }
        });
    }

    protected void attachDndSupport() {
        if (UiDecorationExtensionPoint.getLookAndFeel().isDndSupportEnabled()) {
            new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getUiField());
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        this.removeAutoResizeColumnListener();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener != null) {
            ((ITable)this.getScoutObject()).removeTableListener((TableListener)this.m_scoutTableListener);
            this.m_scoutTableListener = null;
        }
    }

    @Override
    public TableEx getUiField() {
        return (TableEx)super.getUiField();
    }

    @Override
    public TableViewer getUiTableViewer() {
        return this.m_uiViewer;
    }

    @Override
    public void setUiTableViewer(TableViewer uiViewer) {
        this.m_uiViewer = uiViewer;
    }

    @Override
    public ITableRow getUiSelectedRow() {
        ITableRow[] rows = this.getUiSelectedRows();
        if (rows.length > 0) {
            return rows[0];
        }
        return null;
    }

    @Override
    public ITableRow[] getUiSelectedRows() {
        StructuredSelection uiSelection = (StructuredSelection)this.getUiTableViewer().getSelection();
        TreeSet<ITableRow> sortedRows = new TreeSet<ITableRow>((Comparator<ITableRow>)new RowIndexComparator());
        if (uiSelection != null && !uiSelection.isEmpty()) {
            Object[] objectArray = uiSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ITableRow row = (ITableRow)o;
                sortedRows.add(row);
                ++n2;
            }
        }
        return sortedRows.toArray(new ITableRow[sortedRows.size()]);
    }

    protected void setKeyStrokeFormScout() {
        IKeyStroke[] scoutKeyStrokes;
        if (this.m_uiKeyStrokes != null) {
            IRwtKeyStroke[] iRwtKeyStrokeArray = this.m_uiKeyStrokes;
            int n = this.m_uiKeyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IRwtKeyStroke rwtKeyStroke = iRwtKeyStrokeArray[n2];
                this.getUiEnvironment().removeKeyStroke((Control)this.getUiField(), rwtKeyStroke);
                ++n2;
            }
        }
        ArrayList<IRwtKeyStroke> newRwtKeyStrokes = new ArrayList<IRwtKeyStroke>();
        IKeyStroke[] iKeyStrokeArray = scoutKeyStrokes = ((ITable)this.getScoutObject()).getKeyStrokes();
        int n = scoutKeyStrokes.length;
        int n3 = 0;
        while (n3 < n) {
            IKeyStroke scoutKeyStroke = iKeyStrokeArray[n3];
            if (scoutKeyStroke.isEnabled()) {
                IRwtKeyStroke[] rwtStrokes;
                IRwtKeyStroke[] iRwtKeyStrokeArray = rwtStrokes = RwtUtility.getKeyStrokes(scoutKeyStroke, this.getUiEnvironment());
                int n4 = rwtStrokes.length;
                int n5 = 0;
                while (n5 < n4) {
                    IRwtKeyStroke rwtStroke = iRwtKeyStrokeArray[n5];
                    this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), rwtStroke, false);
                    newRwtKeyStrokes.add(rwtStroke);
                    ++n5;
                }
            }
            ++n3;
        }
        this.m_uiKeyStrokes = newRwtKeyStrokes.toArray(new IRwtKeyStroke[newRwtKeyStrokes.size()]);
    }

    protected void setRowHeightFromScout() {
        int h = ((ITable)this.getScoutObject()).getRowHeightHint();
        if (h >= 0) {
            this.getUiField().setData("org.eclipse.rap.rwt.customItemHeight", h);
        } else {
            int defaultTableRowHeight = UiDecorationExtensionPoint.getLookAndFeel().getTableRowHeight();
            if (defaultTableRowHeight >= 0) {
                this.getUiField().setData("org.eclipse.rap.rwt.customItemHeight", defaultTableRowHeight);
            }
        }
        if (this.isCreated()) {
            this.getUiTableViewer().refresh();
        }
    }

    protected void setKeyboardNavigationFromScout() {
        if (((ITable)this.getScoutObject()).hasKeyboardNavigation()) {
            if (this.m_keyboardNavigationSupport == null) {
                this.m_keyboardNavigationSupport = new P_KeyBoardNavigationSupport(this.getUiField());
            }
        } else if (this.m_keyboardNavigationSupport != null) {
            this.m_keyboardNavigationSupport.dispose();
            this.m_keyboardNavigationSupport = null;
        }
    }

    private void updateAutoResizeColumnsFromScout() {
        if (this.getUiField() != null && !this.getUiField().getParent().isDisposed()) {
            Composite parent = this.getUiField().getParent();
            if (((ITable)this.getScoutObject()).isAutoResizeColumns()) {
                if (this.m_autoResizeColumnListener == null) {
                    this.m_autoResizeColumnListener = new P_RwtResizeListener();
                    parent.addListener(11, this.m_autoResizeColumnListener);
                }
                this.scheduleHandleAutoResizeColumn();
            }
        } else {
            this.removeAutoResizeColumnListener();
        }
    }

    private void scheduleHandleAutoResizeColumn() {
        this.getUiField().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RwtScoutTable.this.handleAutoSizeColumns();
            }
        });
    }

    private void removeAutoResizeColumnListener() {
        if (this.m_autoResizeColumnListener == null) {
            return;
        }
        Composite parent = this.getUiField().getParent();
        parent.removeListener(11, this.m_autoResizeColumnListener);
        this.m_autoResizeColumnListener = null;
    }

    @Override
    protected void handleScoutPropertyChange(String propName, Object newValue) {
        if (propName.equals("headerVisible")) {
            this.setHeaderVisibleFromScout((Boolean)newValue);
        } else if (propName.equals("keyStroks")) {
            this.setKeyStrokeFormScout();
        } else if (propName.equals("rowHeightHint")) {
            this.setRowHeightFromScout();
        } else if (propName.equals("keyboardNavigation")) {
            this.setKeyboardNavigationFromScout();
        } else if (propName.equals("autoResizeColumns")) {
            this.updateAutoResizeColumnsFromScout();
        } else if (propName.equals("scrollToSelection")) {
            this.updateScrollToSelectionFromScout();
        }
    }

    protected boolean isHandleScoutTableEvent(TableEvent[] a) {
        TableEvent[] tableEventArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            TableEvent element = tableEventArray[n2];
            switch (element.getType()) {
                case 1: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 200: 
                case 210: 
                case 770: 
                case 780: 
                case 800: 
                case 805: 
                case 830: {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected void handleScoutTableEventInUi(TableEvent e) {
        if (this.isUiDisposed()) {
            return;
        }
        RwtScoutTableEvent uiTableEvent = null;
        switch (e.getType()) {
            case 800: {
                this.getUiField().setFocus();
                break;
            }
            case 805: {
                int swtCol = -1;
                TableColumn[] swtColumns = this.getUiField().getColumns();
                int c = 0;
                while (c < swtColumns.length) {
                    if (swtColumns[c].getData("scoutColumn") == e.getFirstColumn()) {
                        swtCol = c;
                        break;
                    }
                    ++c;
                }
                ITableRow scoutRow = e.getFirstRow();
                if (scoutRow == null || swtCol < 0) break;
                this.getUiTableViewer().editElement((Object)scoutRow, swtCol);
                break;
            }
            case 830: {
                this.scrollToSelection();
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 200: 
            case 210: {
                uiTableEvent = new RwtScoutTableEvent();
                break;
            }
            case 770: {
                break;
            }
            case 780: {
                this.headerUpdateFromScout();
                break;
            }
            case 1: {
                this.initializeUiColumns();
                if (((ITable)this.getScoutObject()).isAutoResizeColumns()) {
                    this.handleAutoSizeColumns();
                }
                uiTableEvent = new RwtScoutTableEvent();
                break;
            }
            case 103: {
                this.setSelectionFromScout(e.getRows());
            }
        }
        if (uiTableEvent != null) {
            this.getUiColumnModel().consumeColumnModelEvent(uiTableEvent);
            ((RwtScoutTableModel)this.getUiTableViewer().getContentProvider()).consumeTableModelEvent(uiTableEvent);
            this.getUiTableViewer().refresh();
        }
        switch (e.getType()) {
            case 210: {
                TableColumn[] tableColumnArray = this.getUiField().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn swtCol = tableColumnArray[n2];
                    this.updateHeaderText(swtCol);
                    ++n2;
                }
                this.setSelectionFromScout(e.getTable().getSelectedRows());
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 200: {
                this.setSelectionFromScout(e.getTable().getSelectedRows());
            }
        }
    }

    private void updateHeaderText(TableColumn swtCol) {
        if (swtCol == null) {
            return;
        }
        Object data = swtCol.getData("scoutColumn");
        if (data instanceof IColumn) {
            this.updateHeaderText(swtCol, (IColumn)data);
        }
    }

    private void updateHeaderText(TableColumn swtCol, IColumn<?> scoutCol) {
        this.updateHeaderText(swtCol, scoutCol, false);
    }

    private void updateHeaderText(TableColumn swtCol, IColumn<?> scoutCol, boolean indicateSortOrder) {
        IHeaderCell cell = scoutCol.getHeaderCell();
        String text = cell.getText();
        if (text == null) {
            text = "";
        }
        if (scoutCol instanceof ICustomColumn) {
            text = "[+] " + text;
        }
        if (scoutCol.isColumnFilterActive()) {
            text = "(*) " + text;
        }
        if (indicateSortOrder) {
            text = scoutCol.isSortAscending() ? "[a-z] " + text : "[z-a] " + text;
        }
        swtCol.setText(text);
    }

    protected void setHeaderVisibleFromScout(boolean headerVisible) {
        this.getUiField().setHeaderVisible(headerVisible);
    }

    @Override
    public void setEnabledFromScout(boolean enabledFromScout) {
        this.getUiField().setEnabled(!enabledFromScout);
        TableColumn[] tableColumnArray = this.getUiField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setData("org.eclipse.rap.rwt.customVariant", (Object)(enabledFromScout ? null : "customDisabled"));
            ++n2;
        }
    }

    protected void setSelectionFromScout(ITableRow[] selectedRows) {
        if (this.getUiField().isDisposed()) {
            return;
        }
        ITableRow[] uiSelection = this.getUiSelectedRows();
        if (CompareUtility.equals((Object)uiSelection, (Object)selectedRows)) {
            return;
        }
        if (selectedRows == null) {
            selectedRows = new ITableRow[]{};
        }
        this.getUiTableViewer().setSelection((ISelection)new StructuredSelection((Object[])selectedRows), true);
        this.updateScrollToSelectionFromScout();
    }

    private void updateScrollToSelectionFromScout() {
        if (((ITable)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void scrollToSelection() {
        if (this.getUiField() != null && !this.getUiField().isDisposed()) {
            this.getUiField().showSelection();
        }
    }

    protected void setContextColumnFromUi(TableColumn uiColumn) {
        if (this.getScoutObject() != null) {
            Point pDisp = this.getUiField().toDisplay(-this.getUiField().getHorizontalBar().getSelection(), 0);
            TableColumn[] tableColumnArray = this.getUiField().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                if (c == uiColumn) break;
                pDisp.x += c.getWidth();
                ++n2;
            }
            this.getUiEnvironment().setPopupOwner((Control)this.getUiField(), new Rectangle(pDisp.x - 2, pDisp.y, 1, this.getUiField().getHeaderHeight()));
            IColumn scoutColumn = null;
            if (uiColumn != null) {
                scoutColumn = (IColumn)uiColumn.getData("scoutColumn");
            }
            final IColumn finalCol = scoutColumn;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().setContextColumnFromUI(finalCol);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private int getVisualCellIndex(TableItem tableItem, int columnIndex) {
        int[] columnOrder;
        int visualCellIndex = columnIndex;
        int[] nArray = columnOrder = tableItem.getParent().getColumnOrder();
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (element == columnIndex) {
                visualCellIndex = columnIndex;
            }
            ++n2;
        }
        return visualCellIndex;
    }

    protected void setSelectionFromUi(final StructuredSelection selection) {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "103");
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().setSelectedRowsFromUI(RwtUtility.getItemsOfSelection(ITableRow.class, selection));
                    }
                    finally {
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "103");
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void headerUpdateFromScout() {
        IColumn cell;
        Object data;
        TableColumn col;
        int minSortIndex = -1;
        TableColumn minUiSortColumn = null;
        IColumn minScoutSortColumn = null;
        TableColumn[] tableColumnArray = this.getUiField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            col = tableColumnArray[n2];
            data = col.getData("scoutColumn");
            if (data instanceof IColumn && (cell = (IColumn)data).isSortExplicit() && (minSortIndex == -1 || cell.getSortIndex() < minSortIndex)) {
                minSortIndex = cell.getSortIndex();
                minUiSortColumn = col;
                minScoutSortColumn = cell;
            }
            ++n2;
        }
        if (minUiSortColumn != null && minScoutSortColumn != null) {
            this.getUiField().setSortColumn(minUiSortColumn);
            this.getUiField().setSortDirection(minScoutSortColumn.isSortAscending() ? 128 : 1024);
        } else {
            this.getUiField().setSortColumn(null);
        }
        tableColumnArray = this.getUiField().getColumns();
        n = tableColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            col = tableColumnArray[n2];
            data = col.getData("scoutColumn");
            if (data instanceof IColumn) {
                cell = (IColumn)data;
                boolean indicateSortOrder = cell.isSortExplicit() && cell != minScoutSortColumn;
                this.updateHeaderText(col, cell, indicateSortOrder);
            }
            ++n2;
        }
    }

    protected void handleUiRowClick(final ITableRow row) {
        if (this.getScoutObject() != null && row != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowClickFromUI(row);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleUiRowAction(final ITableRow row) {
        if (this.getScoutObject() != null && !((ITable)this.getScoutObject()).isCheckable() && row != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowActionFromUI(row);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleUiHyperlinkAction(final ITableRow row, String urlText) {
        if (this.getScoutObject() != null) {
            URL url;
            try {
                url = new URL(urlText);
            }
            catch (MalformedURLException e) {
                LOG.error("Hyperlink could not be activated", (Throwable)e);
                return;
            }
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ITable table = (ITable)RwtScoutTable.this.getScoutObject();
                    table.getUIFacade().fireHyperlinkActionFromUI(row, table.getContextColumn(), url);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleAutoSizeColumns() {
        int width;
        if (this.getUiField() == null || this.getUiField().isDisposed()) {
            return;
        }
        int totalWidth = this.getUiField().getClientArea().width;
        if (totalWidth < 32) {
            return;
        }
        int totalWeight = 0;
        int actualWidth = 0;
        HashMap<TableColumn, Integer> columnWeights = new HashMap<TableColumn, Integer>();
        TableColumn[] tableColumnArray = this.getUiField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            if (col != null && !col.isDisposed()) {
                actualWidth += col.getWidth();
                Object data = col.getData("scoutColumn");
                if (data instanceof IColumn && !((IColumn)data).isFixedWidth()) {
                    width = ((IColumn)data).getInitialWidth();
                    columnWeights.put(col, width);
                    totalWeight += width;
                } else {
                    totalWidth -= col.getWidth();
                }
            }
            ++n2;
        }
        if (actualWidth == totalWidth) {
            return;
        }
        double factor = (double)totalWidth / (double)totalWeight;
        int i = 0;
        for (Map.Entry entry : columnWeights.entrySet()) {
            if (i < columnWeights.size() - 1) {
                width = (int)(factor * (double)((Integer)entry.getValue()).intValue());
                ((TableColumn)entry.getKey()).setWidth(width);
                totalWidth -= width;
                ++i;
                continue;
            }
            ((TableColumn)entry.getKey()).setWidth(totalWidth);
        }
    }

    protected void handleUiColumnResized(TableColumn column) {
        if (column.isDisposed()) {
            return;
        }
        if (!column.getParent().isVisible()) {
            return;
        }
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        final int width = column.getWidth();
        final IColumn scoutColumn = (IColumn)column.getData("scoutColumn");
        if (scoutColumn != null && scoutColumn.getWidth() != width) {
            if (this.m_storeColumnWidthsJob != null) {
                this.m_storeColumnWidthsJob.cancel();
            }
            this.m_storeColumnWidthsJob = new ClientSyncJob("Store column widths", this.getUiEnvironment().getClientSession()){

                protected IStatus runStatus(IProgressMonitor monitor) {
                    try {
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "1");
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().setColumnWidthFromUI(scoutColumn, width);
                    }
                    finally {
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "1");
                    }
                    return Status.OK_STATUS;
                }
            };
            this.m_storeColumnWidthsJob.schedule(400L);
        }
    }

    protected void handleUiColumnMoved() {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        int[] uiColumnOrder = this.getUiField().getColumnOrder();
        if (uiColumnOrder[0] != 0) {
            this.getUiField().setColumnOrder(this.m_uiColumnOrder);
            return;
        }
        if (uiColumnOrder[1] != this.m_uiColumnOrder[1] && ((ITable)this.getScoutObject()).getRowCount() > 0 && StringUtility.hasText((String)((ITable)this.getScoutObject()).getRow(0).getIconId())) {
            this.getUiTableViewer().refresh();
        }
        int[] truncatedColOrder = new int[uiColumnOrder.length - 1];
        int i = 0;
        while (i < truncatedColOrder.length) {
            truncatedColOrder[i] = uiColumnOrder[i + 1] - 1;
            ++i;
        }
        final IColumn<?>[] newOrder = this.m_uiColumnManager.getOrderedColumns(truncatedColOrder);
        if (this.m_uiColumnManager.applyNewOrder(newOrder)) {
            this.m_uiColumnOrder = uiColumnOrder;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "770");
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "1");
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireVisibleColumnsChangedFromUI(newOrder);
                    }
                    finally {
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "770");
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "1");
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleKeyboardNavigationFromUi(TableItem item) {
        this.getUiField().setSelection(item);
        Event selectionEvent = new Event();
        selectionEvent.type = 14;
        selectionEvent.widget = this.getUiField();
        Listener[] listenerArray = this.getUiField().getListeners(14);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener l = listenerArray[n2];
            l.handleEvent(selectionEvent);
            ++n2;
        }
    }

    protected void handleUiToggleAcction(Event e) {
        if (e.doit && ((ITable)this.getScoutObject()).isCheckable() && e.stateMask == 0) {
            switch (e.keyCode) {
                case 32: {
                    ITableRow[] selectedRows = RwtUtility.getItemsOfSelection(ITableRow.class, (StructuredSelection)this.getUiTableViewer().getSelection());
                    if (selectedRows != null && selectedRows.length > 0) {
                        this.handleUiRowClick(selectedRows[0]);
                    }
                    e.doit = false;
                }
            }
        }
    }

    private Menu createMenu(boolean headerMenu) {
        if (this.getUiField().getMenu() != null) {
            this.getUiField().getMenu().dispose();
            this.getUiField().setMenu(null);
        }
        Menu contextMenu = new Menu((Decorations)this.getUiField().getShell(), 8);
        contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener(headerMenu));
        this.getUiField().setMenu(contextMenu);
        return contextMenu;
    }

    private void createAndShowMenu(Point location) {
        Point pt = this.getUiField().getDisplay().map(null, (Control)this.getUiField(), location);
        Rectangle clientArea = this.getUiField().getClientArea();
        boolean header = clientArea.y <= pt.y && pt.y < clientArea.y + this.getUiField().getHeaderHeight();
        Menu menu = this.createMenu(header);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private class P_ColumnSortListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean ctrlKeyPressed;
            TableColumn col = (TableColumn)e.getSource();
            RwtScoutTable.this.setContextColumnFromUi(col);
            final IColumn newColumn = (IColumn)col.getData("scoutColumn");
            boolean bl = ctrlKeyPressed = (e.stateMask & 0x40000) > 0;
            if (RwtScoutTable.this.getScoutObject() != null) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireHeaderSortFromUI(newColumn, ctrlKeyPressed);
                    }
                };
                RwtScoutTable.this.getUiEnvironment().invokeScoutLater(job, 0L);
            }
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapterEx {
        private boolean m_header;
        private static final long serialVersionUID = 1L;

        public P_ContextMenuListener(boolean header) {
            super((Control)RwtScoutTable.this.getUiTableViewer().getTable(), (Control)RwtScoutTable.this.getUiTableViewer().getTable());
            this.m_header = header;
        }

        @Override
        public void menuShown(MenuEvent e) {
            super.menuShown(e);
            IMenu[] menus = null;
            if (this.m_header) {
                menus = this.collectHeaderMenus();
            } else {
                boolean emptySelection = RwtScoutTable.this.getUiTableViewer().getSelection().isEmpty();
                menus = RwtMenuUtility.collectMenus((ITable)RwtScoutTable.this.getScoutObject(), emptySelection, !emptySelection, RwtScoutTable.this.getUiEnvironment());
            }
            if (menus != null) {
                Menu menu = (Menu)e.getSource();
                RwtMenuUtility.fillContextMenu(menus, RwtScoutTable.this.getUiEnvironment(), menu);
            }
        }

        private IMenu[] collectHeaderMenus() {
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireHeaderPopupFromUI();
                    scoutMenusRef.set(scoutMenus);
                }
            };
            JobEx job = RwtScoutTable.this.getUiEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (scoutMenusRef.get() != null) {
                return (IMenu[])scoutMenusRef.get();
            }
            return new IMenu[0];
        }
    }

    private class P_DndSupport
    extends AbstractRwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control) {
            super(scoutObject, scoutDndSupportable, control, RwtScoutTable.this.getUiEnvironment());
        }

        @Override
        protected TransferObject handleUiDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowsDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getUiEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleUiDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Object dropTarget = event.item != null ? event.item.getData() : null;
            final ITableRow row = dropTarget instanceof ITableRow ? (ITableRow)dropTarget : null;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowDropActionFromUI(row, scoutTransferObject);
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_KeyBoardNavigationSupport
    extends AbstractTableKeyboardNavigationSupport {
        public P_KeyBoardNavigationSupport(TableEx table) {
            super(table);
        }

        @Override
        public void handleKeyboardNavigation(TableItem tableItem) {
            RwtScoutTable.this.handleKeyboardNavigationFromUi(tableItem);
        }
    }

    private class P_RwtHyperlinkSelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtHyperlinkSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 0x4000000) {
                TableItem tableItem = (TableItem)event.item;
                ITableRow row = (ITableRow)tableItem.getData();
                RwtScoutTable.this.handleUiHyperlinkAction(row, event.text);
            }
        }
    }

    private class P_RwtResizeListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtResizeListener() {
        }

        public void handleEvent(Event event) {
            if (RwtScoutTable.this.getUiField() != null && !RwtScoutTable.this.getUiField().isDisposed()) {
                if (((ITable)RwtScoutTable.this.getScoutObject()).isAutoResizeColumns()) {
                    RwtScoutTable.this.scheduleHandleAutoResizeColumn();
                }
                RwtScoutTable.this.updateScrollToSelectionFromScout();
            }
        }
    }

    public class P_RwtSelectionChangedListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            RwtScoutTable.this.setSelectionFromUi((StructuredSelection)event.getSelection());
        }
    }

    private class P_RwtTableListener
    implements Listener {
        private static final long serialVersionUID = 1L;
        private Boolean m_doubleClicked = Boolean.FALSE;

        private P_RwtTableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            Point eventPosition = new Point(event.x, event.y);
            TableViewer uiTableViewer = RwtScoutTable.this.getUiTableViewer();
            switch (event.type) {
                case 3: {
                    if (uiTableViewer.getTable().getItem(new Point(event.y, event.y)) == null && uiTableViewer instanceof TableViewerEx) {
                        ((TableViewerEx)uiTableViewer).applyEditorValue();
                    }
                    RwtScoutTable.this.setContextColumnFromUi(RwtUtility.getRwtColumnAt(uiTableViewer.getTable(), eventPosition));
                    if (RwtScoutTable.this.getUiField().getItem(eventPosition) != null) break;
                    uiTableViewer.setSelection(null);
                    RwtScoutTable.this.setSelectionFromUi(new StructuredSelection());
                    break;
                }
                case 4: {
                    Boolean bl = this.m_doubleClicked;
                    synchronized (bl) {
                        if (this.m_doubleClicked == Boolean.TRUE) {
                            this.m_doubleClicked = Boolean.FALSE;
                            break;
                        }
                    }
                    StructuredSelection selection = (StructuredSelection)uiTableViewer.getSelection();
                    if (selection == null || selection.size() != 1) break;
                    RwtScoutTable.this.handleUiRowClick((ITableRow)selection.getFirstElement());
                    break;
                }
                case 8: {
                    Boolean selection = this.m_doubleClicked;
                    synchronized (selection) {
                        this.m_doubleClicked = Boolean.TRUE;
                    }
                    selection = (StructuredSelection)uiTableViewer.getSelection();
                    if (selection == null || selection.size() != 1) break;
                    RwtScoutTable.this.handleUiRowAction((ITableRow)selection.getFirstElement());
                    break;
                }
                case 11: {
                    if (RwtScoutTable.this.getUiField() == null || RwtScoutTable.this.getUiField().isDisposed()) break;
                    if (((ITable)RwtScoutTable.this.getScoutObject()).isAutoResizeColumns()) {
                        RwtScoutTable.this.scheduleHandleAutoResizeColumn();
                    }
                    RwtScoutTable.this.updateScrollToSelectionFromScout();
                    break;
                }
                case 35: {
                    RwtScoutTable.this.createAndShowMenu(eventPosition);
                }
            }
        }
    }

    private class P_ScoutTableListener
    implements TableListener {
        private P_ScoutTableListener() {
        }

        public void tableChanged(final TableEvent e) {
            if (RwtScoutTable.this.isHandleScoutTableEvent(new TableEvent[]{e})) {
                if (RwtScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RwtScoutTable.this.getUpdateUiFromScoutLock().acquire();
                            RwtScoutTable.this.handleScoutTableEventInUi(e);
                        }
                        finally {
                            RwtScoutTable.this.getUpdateUiFromScoutLock().release();
                        }
                    }
                };
                RwtScoutTable.this.getUiEnvironment().invokeUiLater(t);
            }
        }

        public void tableChangedBatch(TableEvent[] a) {
            if (RwtScoutTable.this.isHandleScoutTableEvent(a)) {
                final ArrayList<TableEvent> filteredList = new ArrayList<TableEvent>();
                int i = 0;
                while (i < a.length) {
                    if (!RwtScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + a[i].getType())) {
                        filteredList.add(a[i]);
                    }
                    ++i;
                }
                if (filteredList.size() == 0) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (RwtScoutTable.this.isUiDisposed()) {
                            return;
                        }
                        RwtScoutTable.this.m_redrawHandler.pushControlChanging();
                        try {
                            try {
                                RwtScoutTable.this.getUpdateUiFromScoutLock().acquire();
                                for (TableEvent element : filteredList) {
                                    RwtScoutTable.this.handleScoutTableEventInUi(element);
                                }
                            }
                            finally {
                                RwtScoutTable.this.getUpdateUiFromScoutLock().release();
                            }
                        }
                        finally {
                            RwtScoutTable.this.m_redrawHandler.popControlChanging();
                        }
                    }
                };
                RwtScoutTable.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }

    private class P_TableColumnListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_TableColumnListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 10: {
                    RwtScoutTable.this.handleUiColumnMoved();
                    break;
                }
                case 11: {
                    if (!(event.widget instanceof TableColumn)) break;
                    RwtScoutTable.this.handleUiColumnResized((TableColumn)event.widget);
                }
            }
        }
    }
}

