/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.tablefield;

import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.tablefield.IRwtTableStatus;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RwtTableStatus
implements IRwtTableStatus {
    protected static final String VARIANT_OUTLINE_TABLE_STATUS = "outlineTableStatus";
    protected static final String VARIANT_TABLE_STATUS = "tableStatus";
    static final String VARIANT_POSTFIX_ERROR = "_error";
    static final String VARIANT_POSTFIX_WARNING = "_warning";
    private final Composite m_parent;
    private final IRwtEnvironment m_uiEnvironment;
    private final Composite m_labelContainer;
    private final Label m_populateLabel;
    private final Label m_selectionLabel;
    private boolean m_layoutNeeded;
    private String m_statusVariant = "";

    public RwtTableStatus(Composite parent, IRwtEnvironment uiEnvironment, ITableField<?> model) {
        this.m_parent = parent;
        this.m_uiEnvironment = uiEnvironment;
        this.m_statusVariant = this.getVariant(model);
        this.m_labelContainer = this.getUiEnvironment().getFormToolkit().createComposite(this.m_parent);
        this.m_labelContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_statusVariant);
        this.m_populateLabel = this.getUiEnvironment().getFormToolkit().createLabel(this.m_labelContainer, "", 0);
        this.m_populateLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_statusVariant);
        this.m_populateLabel.setVisible(false);
        this.m_selectionLabel = this.getUiEnvironment().getFormToolkit().createLabel(this.m_labelContainer, "", 0);
        this.m_selectionLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_statusVariant);
        this.m_selectionLabel.setVisible(false);
        LogicalGridData tableGridData = LogicalGridDataBuilder.createField(model.getGridData());
        LogicalGridData gd = new LogicalGridData();
        gd.gridx = tableGridData.gridx;
        gd.gridy = tableGridData.gridy + tableGridData.gridh;
        gd.gridw = tableGridData.gridw;
        gd.topInset = 2;
        gd.gridh = 1;
        gd.weightx = tableGridData.weightx;
        gd.weighty = 0.0;
        gd.fillHorizontal = true;
        this.m_labelContainer.setLayoutData((Object)gd);
        GridLayout groupCompLayout = RwtLayoutUtility.createGridLayoutNoSpacing(1, false);
        this.m_labelContainer.setLayout((Layout)groupCompLayout);
        GridData popLabelLayoutData = new GridData(1792);
        popLabelLayoutData.exclude = true;
        popLabelLayoutData.verticalAlignment = 0x1000000;
        popLabelLayoutData.horizontalAlignment = this.getLabelHorizontalAlignment();
        this.m_populateLabel.setLayoutData((Object)popLabelLayoutData);
        GridData selLabelLayoutData = new GridData(1792);
        selLabelLayoutData.exclude = true;
        selLabelLayoutData.verticalAlignment = 0x1000000;
        selLabelLayoutData.horizontalAlignment = this.getLabelHorizontalAlignment();
        this.m_selectionLabel.setLayoutData((Object)selLabelLayoutData);
    }

    protected String getVariant(ITableField<?> table) {
        IForm form = table.getForm();
        if (form instanceof IOutlineTableForm) {
            return VARIANT_OUTLINE_TABLE_STATUS;
        }
        return VARIANT_TABLE_STATUS;
    }

    protected int getLabelHorizontalAlignment() {
        return 16384;
    }

    @Override
    public void dispose() {
        if (!this.m_populateLabel.isDisposed()) {
            this.m_populateLabel.dispose();
        }
        if (!this.m_selectionLabel.isDisposed()) {
            this.m_selectionLabel.dispose();
        }
        if (!this.m_labelContainer.isDisposed()) {
            this.m_labelContainer.dispose();
        }
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    @Override
    public void setStatus(IProcessingStatus populateStatus, IProcessingStatus selectionStatus) {
        this.setStatusImpl(this.m_populateLabel, populateStatus, true);
        this.setStatusImpl(this.m_selectionLabel, selectionStatus, true);
        if (!this.m_populateLabel.getVisible() && !this.m_selectionLabel.getVisible() && this.m_labelContainer.getVisible()) {
            this.m_layoutNeeded = true;
            this.m_labelContainer.setVisible(false);
        } else if ((this.m_populateLabel.getVisible() || this.m_selectionLabel.getVisible()) && !this.m_labelContainer.getVisible()) {
            this.m_layoutNeeded = true;
            this.m_labelContainer.setVisible(true);
        }
        if (this.m_layoutNeeded) {
            ((LogicalGridData)this.m_labelContainer.getLayoutData()).gridh = this.m_populateLabel.getVisible() && this.m_selectionLabel.getVisible() && this.m_labelContainer.getVisible() ? 2 : ((this.m_populateLabel.getVisible() || this.m_selectionLabel.getVisible()) && this.m_labelContainer.getVisible() ? 1 : 0);
            this.m_layoutNeeded = false;
            this.m_parent.layout(true, true);
        }
    }

    private void setStatusImpl(Label field, IProcessingStatus status, boolean hideWhenNullStatus) {
        String text;
        if (status == null) {
            field.setText("");
            if (hideWhenNullStatus && field.getVisible()) {
                this.m_layoutNeeded = true;
                field.setVisible(false);
                ((GridData)field.getLayoutData()).exclude = true;
            }
            return;
        }
        if (!field.getVisible()) {
            this.m_layoutNeeded = true;
            field.setVisible(true);
            ((GridData)field.getLayoutData()).exclude = false;
        }
        if ((text = status.getMessage()) != null) {
            text = text.replaceAll("[\\s]+", " ");
        }
        field.setText(text != null ? " " + text : "");
        switch (status.getSeverity()) {
            case 4: 
            case 16: {
                field.setData("org.eclipse.rap.rwt.customVariant", (Object)(String.valueOf(this.m_statusVariant) + VARIANT_POSTFIX_ERROR));
                break;
            }
            case 2: 
            case 8: {
                field.setData("org.eclipse.rap.rwt.customVariant", (Object)(String.valueOf(this.m_statusVariant) + VARIANT_POSTFIX_WARNING));
                break;
            }
            default: {
                field.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_statusVariant);
            }
        }
    }
}

