/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.client.service.UrlLauncher;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.AbstractRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.window.filedownloader.RwtScoutDownloadHandler;

public class BrowserWindowHandler {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRwtEnvironment.class);

    public void openLink(String link) {
        if (link == null) {
            return;
        }
        if (this.isEmailLink(link)) {
            this.openLinkInSameBrowserWindow(link);
        } else if (this.isTelLink(link)) {
            this.openLinkInSameBrowserWindow(link);
        } else if (this.isHttpLink(link)) {
            this.openLinkInNewBrowserWindow(link);
        } else {
            this.downloadFile(link);
        }
    }

    public boolean isEmailLink(String link) {
        return link != null && link.startsWith("mailto:");
    }

    public boolean isTelLink(String link) {
        return link != null && link.startsWith("tel:");
    }

    public boolean isHttpLink(String link) {
        return StringUtility.find((String)link, (String)"http://") >= 0 || StringUtility.find((String)link, (String)"https://") >= 0;
    }

    public void openLinkInNewBrowserWindow(String link) {
        if (!this.isHttpLink(link)) {
            return;
        }
        UrlLauncher launcher = (UrlLauncher)RWT.getClient().getService(UrlLauncher.class);
        if (launcher != null) {
            launcher.openURL(link);
        }
    }

    public void openLinkInSameBrowserWindow(String link) {
        if (link == null) {
            return;
        }
        JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
        if (executor != null) {
            executor.execute("window.location='" + link + "'");
        }
    }

    public void downloadFile(String link) {
        try {
            File file = this.validateLink(link);
            String nextId = UUID.randomUUID().toString();
            RwtScoutDownloadHandler handler = new RwtScoutDownloadHandler(nextId, file, "", file.getName());
            handler.startDownload();
        }
        catch (IOException e) {
            LOG.error("Unexpected: " + link, (Throwable)e);
        }
    }

    protected File validateLink(String link) throws IOException {
        String px = link.replace('\\', File.separatorChar);
        File file = new File(px);
        if (file.exists()) {
            px = file.getCanonicalPath();
            String osName = System.getProperty("os.name");
            if (osName != null && osName.startsWith("Mac OS")) {
                String ext = px.substring(px.lastIndexOf(46));
                File f = new File(file.getParentFile(), System.nanoTime() + ext);
                file.renameTo(f);
                f.deleteOnExit();
            }
        }
        return file;
    }
}

