/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar;

import java.util.HashMap;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.services.common.patchedclass.IPatchedClassService;
import org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar.IRwtScoutFormButton;
import org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar.IRwtScoutFormButtonForPatch;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutFormButtonBar
extends RwtScoutComposite<IDesktop> {
    private static final String VARIANT_FORMBAR_CONTAINER = "formbarContainer";
    private static final String VARIANT_FORM_BUTTON_ACTIVE = "formButton-active";
    private static final String VARIANT_FORM_BUTTON = "formButton";
    private HashMap<IForm, IRwtScoutFormButton> m_formTabItems = new HashMap();
    private Composite m_buttonBar;

    public void addFormButton(final IForm form) {
        AbstractAction formButton = new AbstractAction(){

            protected void execInitAction() throws ProcessingException {
                this.setText(form.getTitle());
            }

            protected void execAction() throws ProcessingException {
                form.activate();
                form.toFront();
            }
        };
        form.addFormListener(new FormListener(){

            public void formChanged(final FormEvent e) throws ProcessingException {
                RwtScoutFormButtonBar.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        IRwtScoutFormButton uiButton = (IRwtScoutFormButton)RwtScoutFormButtonBar.this.m_formTabItems.get(e.getForm());
                        if (uiButton != null && !uiButton.isUiDisposed()) {
                            if (e.getType() == 6000) {
                                uiButton.makeButtonActive();
                            } else if (e.getType() == 6010) {
                                uiButton.makeButtonInactive();
                            }
                        }
                    }
                });
            }
        });
        IRwtScoutFormButtonForPatch uiButton = ((IPatchedClassService)SERVICES.getService(IPatchedClassService.class)).createRwtScoutFormButton(true, false, VARIANT_FORM_BUTTON, VARIANT_FORM_BUTTON_ACTIVE);
        uiButton.createUiField(this.m_buttonBar, formButton, this.getUiEnvironment());
        this.m_formTabItems.put(form, uiButton);
    }

    public void removeFormButton(IForm form) {
        IRwtScoutFormButton uiButton = this.m_formTabItems.remove(form);
        if (uiButton != null && uiButton.isCreated() && !uiButton.isUiDisposed()) {
            uiButton.dispose();
            this.m_buttonBar.layout(true, true);
        }
    }

    public int getFormButtonBarCount() {
        return this.m_formTabItems.size();
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_buttonBar = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.m_buttonBar.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_FORMBAR_CONTAINER);
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        this.m_buttonBar.setLayout((Layout)layout);
        this.setUiContainer(this.m_buttonBar);
    }
}

