/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar.comp;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.ui.svg.calendar.builder.AbstractCalendarDocumentBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.comp.AbstractComponentElementFactory;
import org.w3c.dom.Element;

public class TimeLineComponentElementFactory
extends AbstractComponentElementFactory {
    private static int m_startHour = 7;
    private static int m_endHour = 19;
    private static final float PADDING = 1.5f;
    private static final float MIN_ELEMENT_HEIGHT = 10.0f;
    private static final Integer EVENT_START = new Integer(2);
    private static final Integer EVENT_END = new Integer(1);

    public TimeLineComponentElementFactory(int startHour, int endHour) {
        m_startHour = startHour;
        m_endHour = endHour;
    }

    @Override
    public Map<CalendarComponent, Element> create(Element container, Date day, CalendarComponent[] components) {
        TreeMap<CompositeObject, CalendarComponentComposite> events = new TreeMap<CompositeObject, CalendarComponentComposite>();
        HashSet<CalendarComponentComposite> list = new HashSet<CalendarComponentComposite>(components.length);
        int numFullDay = 0;
        int i = 0;
        while (i < components.length) {
            Calendar start = AbstractCalendarDocumentBuilder.createCalendar(TimeLineComponentElementFactory.truncateToSingleDay(components[i].getFromDate(), day));
            Calendar end = AbstractCalendarDocumentBuilder.createCalendar(TimeLineComponentElementFactory.truncateToSingleDay(components[i].getToDate(), day));
            CalendarComponentComposite e = new CalendarComponentComposite(components[i], start, end);
            list.add(e);
            if (components[i].isFullDay()) {
                e.index = numFullDay++;
            } else {
                events.put(new CompositeObject(new Object[]{start.getTime(), EVENT_START, i}), e);
                events.put(new CompositeObject(new Object[]{end.getTime(), EVENT_END, i}), e);
            }
            ++i;
        }
        int maxIndex = TimeLineComponentElementFactory.calculateIndices(events);
        AbstractComponentElementFactory.SvgRect containerDimension = TimeLineComponentElementFactory.getElementDimensions(container);
        HashMap<CalendarComponent, Element> ret = new HashMap<CalendarComponent, Element>(list.size());
        int fullDayIndex = 0;
        for (CalendarComponentComposite c : list) {
            Element e = this.createComponentElement(container, containerDimension, c, maxIndex + 1, numFullDay, list, day);
            if (c.comp.isFullDay()) {
                ++fullDayIndex;
            }
            if (e == null) continue;
            ret.put(c.comp, e);
        }
        return ret;
    }

    private static int calculateIndices(Map<CompositeObject, CalendarComponentComposite> events) {
        int maxIndex = 0;
        HashSet<Integer> usedIndices = new HashSet<Integer>();
        for (Map.Entry<CompositeObject, CalendarComponentComposite> el : events.entrySet()) {
            Integer eventType = (Integer)el.getKey().getComponent(1);
            if (eventType.equals(EVENT_START)) {
                int index = TimeLineComponentElementFactory.getNextFreeIndex(usedIndices);
                el.getValue().index = index;
                if (index <= maxIndex) continue;
                maxIndex = index;
                continue;
            }
            TimeLineComponentElementFactory.releaseIndex(usedIndices, el.getValue().index);
        }
        return maxIndex;
    }

    private static void releaseIndex(HashSet<Integer> collector, Integer i) {
        collector.remove(i);
    }

    private static Integer getNextFreeIndex(HashSet<Integer> collector) {
        int i = 0;
        while (collector.contains(i)) {
            ++i;
        }
        collector.add(i);
        return i;
    }

    private Element createComponentElement(Element container, AbstractComponentElementFactory.SvgRect containerDimension, CalendarComponentComposite c, int numColumns, int numFullDay, HashSet<CalendarComponentComposite> list, Date day) {
        Element newEl = this.createNewComponentElement(container, c.comp, day);
        Element composite = container.getOwnerDocument().createElementNS("http://www.w3.org/2000/svg", "g");
        AbstractComponentElementFactory.SvgRect elementDimension = TimeLineComponentElementFactory.getCopyWithPadding(this.getTimeLineElementDimension(c, list, containerDimension, numColumns, numFullDay), 1.5f);
        TimeLineComponentElementFactory.setElementDimensions(newEl, elementDimension);
        composite.appendChild(newEl);
        Element txt = this.createTextElement(c.comp, newEl, elementDimension, day);
        if (txt != null) {
            composite.appendChild(txt);
        }
        return composite;
    }

    private AbstractComponentElementFactory.SvgRect getTimeLineElementDimension(CalendarComponentComposite c, HashSet<CalendarComponentComposite> list, AbstractComponentElementFactory.SvgRect containerDimension, int numColumns, int numFullDay) {
        float elementWidth;
        float columnWidth;
        if (c.comp.isFullDay()) {
            elementWidth = columnWidth = containerDimension.width / (float)numFullDay;
        } else {
            columnWidth = containerDimension.width / (float)numColumns;
            int extend = this.getNextBlockIndex(list, c.comp, c.index + 1);
            extend = extend < 0 ? numColumns - c.index : (extend -= c.index.intValue());
            elementWidth = columnWidth * (float)extend;
        }
        float xOffset = (float)c.index.intValue() * columnWidth;
        float yOffsetStart = TimeLineComponentElementFactory.getYOffset(c, containerDimension, false);
        float yOffsetEnd = TimeLineComponentElementFactory.getYOffset(c, containerDimension, true);
        if (yOffsetEnd - 10.0f <= yOffsetStart) {
            yOffsetEnd = yOffsetStart + 10.0f;
        }
        AbstractComponentElementFactory.SvgRect elDimension = new AbstractComponentElementFactory.SvgRect();
        elDimension.x = containerDimension.x + xOffset;
        elDimension.y = containerDimension.y + yOffsetStart;
        elDimension.width = elementWidth;
        elDimension.height = yOffsetEnd - yOffsetStart;
        return elDimension;
    }

    protected Element createTextElement(CalendarComponent c, Element parent, AbstractComponentElementFactory.SvgRect parentDimension, Date day) {
        return null;
    }

    private int getNextBlockIndex(HashSet<CalendarComponentComposite> list, CalendarComponent c, int startIndex) {
        int nextBlockIndex = -1;
        for (CalendarComponentComposite ccc : list) {
            if (ccc.comp.isFullDay() || ccc.index < startIndex || !DateUtility.intersects((Date)ccc.comp.getFromDate(), (Date)ccc.comp.getToDate(), (Date)c.getFromDate(), (Date)c.getToDate()) || nextBlockIndex >= 0 && nextBlockIndex <= ccc.index) continue;
            nextBlockIndex = ccc.index;
        }
        return nextBlockIndex;
    }

    private static float getYOffset(CalendarComponentComposite d, AbstractComponentElementFactory.SvgRect container, boolean isEnd) {
        int minute;
        int hour;
        int NUM_ELEMENTS = m_endHour - m_startHour + 2;
        float ELEMENT_HEIGHT = container.height / (float)NUM_ELEMENTS;
        if (isEnd) {
            hour = d.end.get(11);
            minute = d.end.get(12);
        } else {
            hour = d.start.get(11);
            minute = d.start.get(12);
        }
        if (d.comp.isFullDay()) {
            if (isEnd) {
                return ELEMENT_HEIGHT;
            }
            return 0.0f;
        }
        if (hour < m_startHour) {
            if (isEnd) {
                return ELEMENT_HEIGHT * 2.0f;
            }
            return ELEMENT_HEIGHT;
        }
        if (hour >= m_endHour) {
            if (isEnd) {
                return container.height;
            }
            return container.height - ELEMENT_HEIGHT;
        }
        int minutes = (hour - m_startHour) * 60 + minute;
        int totalMinutes = (m_endHour - m_startHour) * 60;
        float timeHeight = container.height - 2.0f * ELEMENT_HEIGHT;
        return ELEMENT_HEIGHT + (float)minutes * timeHeight / (float)totalMinutes;
    }

    private static Date truncateToSingleDay(Date d, Date day) {
        if (DateUtility.isSameDay((Date)d, (Date)(day = DateUtility.truncDate((Date)day)))) {
            return d;
        }
        if (d.compareTo(day) < 0) {
            return day;
        }
        return new Date(day.getTime() + 86400000L - 1L);
    }

    private static class CalendarComponentComposite {
        private Integer index;
        private CalendarComponent comp;
        private Calendar start;
        private Calendar end;

        private CalendarComponentComposite(CalendarComponent c, Calendar s, Calendar e) {
            this.comp = c;
            this.start = s;
            this.end = e;
        }
    }
}

