/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import javax.swing.SwingUtilities;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.ui.swing.BaseSwingApplication;
import org.eclipse.scout.rt.ui.swing.DefaultSwingEnvironment;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;

public abstract class AbstractSwingApplication
extends BaseSwingApplication {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSwingApplication.class);
    private ISwingEnvironment m_env;

    protected abstract IClientSession getClientSession();

    public AbstractSwingApplication() {
        this.initialize();
    }

    @Override
    protected Object startInSubject(IApplicationContext context) throws Exception {
        final IClientSession clientSession = this.getClientSession();
        if (!this.isClientSessionValid(clientSession)) {
            return EXIT_OK;
        }
        context.applicationRunning();
        this.stopSplashScreen();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractSwingApplication.this.m_env.showGUI(clientSession);
                    AbstractSwingApplication.this.execSwingStarted(clientSession);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Error Starting GUI", (Throwable)e);
            System.exit(0);
        }
        return this.runWhileActive(clientSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runWhileActive(IClientSession clientSession) throws InterruptedException {
        Object stateLock = clientSession.getStateLock();
        while (true) {
            Object object = stateLock;
            synchronized (object) {
                if (!clientSession.isActive()) {
                    return clientSession.getExitCode();
                }
                stateLock.wait();
            }
        }
    }

    protected void execSwingStarted(IClientSession clientSession) {
    }

    @Override
    public ISwingEnvironment getSwingEnvironment() {
        return this.m_env;
    }

    @Override
    void initializeSwing() {
        this.m_env = this.createSwingEnvironment();
    }

    protected ISwingEnvironment createSwingEnvironment() {
        return new DefaultSwingEnvironment();
    }

    public void stop() {
        this.getClientSession().stopSession();
    }
}

