/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public final class UndoableEditObserver
implements FocusListener,
UndoableEditListener,
KeyListener {
    private UndoManager m_undoManager;

    private UndoableEditObserver() {
    }

    public static void attach(JTextComponent c) {
        new UndoableEditObserver(c);
    }

    private UndoableEditObserver(JTextComponent c) {
        if (c.getDocument() != null) {
            c.getDocument().addUndoableEditListener(this);
        }
        c.addKeyListener(this);
        c.addFocusListener(this);
        c.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Document old = (Document)e.getOldValue();
                Document doc = (Document)e.getNewValue();
                if (old != null) {
                    old.removeUndoableEditListener(UndoableEditObserver.this);
                }
                if (doc != null) {
                    doc.addUndoableEditListener(UndoableEditObserver.this);
                }
            }
        });
    }

    @Override
    public void focusGained(FocusEvent f) {
        if (!f.isTemporary()) {
            this.createUndoMananger();
        }
    }

    @Override
    public void focusLost(FocusEvent f) {
        if (!f.isTemporary()) {
            this.removeUndoMananger();
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.m_undoManager != null) {
            this.m_undoManager.addEdit(e.getEdit());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed() || !e.isControlDown() || e.isAltDown()) {
            return;
        }
        if (e.getKeyCode() == 90) {
            this.undoAction();
        } else if (e.getKeyCode() == 89) {
            this.redoAction();
        }
    }

    private void createUndoMananger() {
        if (this.m_undoManager == null) {
            this.m_undoManager = new UndoManager();
            this.m_undoManager.setLimit(200);
        }
    }

    private void removeUndoMananger() {
        if (this.m_undoManager != null) {
            this.m_undoManager.end();
            this.m_undoManager = null;
        }
    }

    private void undoAction() {
        if (this.m_undoManager != null) {
            try {
                this.m_undoManager.undo();
            }
            catch (CannotUndoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void redoAction() {
        if (this.m_undoManager != null) {
            try {
                this.m_undoManager.redo();
            }
            catch (CannotRedoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

