/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic;

import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IconUtility {
    private IconUtility() {
    }

    public static ImageIcon blendIcon(Icon icon, float iconWeight, int rgb, float rgbWeight) {
        if (icon == null || !(icon instanceof ImageIcon)) {
            return null;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        g.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
        g.dispose();
        float wsum = iconWeight + rgbWeight;
        if (wsum > 0.0f) {
            iconWeight /= wsum;
            rgbWeight /= wsum;
        }
        int rmask = rgb >> 16 & 0xFF;
        int gmask = rgb >> 8 & 0xFF;
        int bmask = rgb & 0xFF;
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        int i = 0;
        while (i < pixels.length) {
            int c = pixels[i];
            pixels[i] = c & 0xFF000000 | IconUtility.mergeComponent(c >> 16 & 0xFF, iconWeight, rmask, rgbWeight) << 16 | IconUtility.mergeComponent(c >> 8 & 0xFF, iconWeight, gmask, rgbWeight) << 8 | IconUtility.mergeComponent(c & 0xFF, iconWeight, bmask, rgbWeight);
            ++i;
        }
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        return new ImageIcon(image);
    }

    private static int mergeComponent(int a, float wa, int b, float wb) {
        int c = (int)(wa * (float)a + wb * (float)b);
        if (c >= 0 && c <= 255) {
            return c;
        }
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    public static ImageIcon grayIcon(Icon icon) {
        if (icon == null || !(icon instanceof ImageIcon)) {
            return null;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        g.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
        g.dispose();
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return new ImageIcon(op.filter(image, image));
    }
}

