/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ISwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;

public abstract class SwingScoutComposite<T extends IPropertyObserver>
implements ISwingScoutComposite<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutComposite.class);
    public static final String CLIENT_PROP_INITIAL_OPAQUE = "scoutInitialOpaque";
    public static final String CLIENT_PROP_INITIAL_FONT = "scoutInitialFont";
    public static final String CLIENT_PROP_INITIAL_BACKGROUND = "scoutInitialBackground";
    public static final String CLIENT_PROP_INITIAL_FOREGROUND = "scoutInitialForeground";
    private static final Object NULL_VALUE = new Object();
    private static final ThreadLocal<OptimisticLock> CONNECT_TO_SCOUT_THREAD_OPTIMISTIC_LOCK = new ThreadLocal<OptimisticLock>(){

        @Override
        protected OptimisticLock initialValue() {
            return new OptimisticLock();
        }
    };
    private static final ThreadLocal<OptimisticLock> DISCONNECT_FROM_SCOUT_THREAD_OPTIMISTIC_LOCK = new ThreadLocal<OptimisticLock>(){

        @Override
        protected OptimisticLock initialValue() {
            return new OptimisticLock();
        }
    };
    private ISwingEnvironment m_env;
    private JComponent m_swingField;
    private final OptimisticLock m_updateSwingFromScoutLock;
    private final Set<String> m_ignoredScoutEvents;
    private boolean m_inputDirty;
    private T m_scoutObject;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;
    private P_SwingDefaultFocusListener m_swingDefaultFocusListener;
    private P_SwingInputVerifier m_swingInputVerifier;
    private P_SwingShowingListener m_swingShowingListener;
    private boolean m_initialized;
    private boolean m_connectedToScout;

    public SwingScoutComposite() {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerObject((Object)this);
        }
        this.m_updateSwingFromScoutLock = new OptimisticLock();
        this.m_ignoredScoutEvents = new HashSet<String>();
    }

    public OptimisticLock getUpdateSwingFromScoutLock() {
        return this.m_updateSwingFromScoutLock;
    }

    public void addIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.add(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    public void removeIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.remove(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    public boolean isIgnoredScoutEvent(Class eventType, String name) {
        if (this.m_ignoredScoutEvents.isEmpty()) {
            return false;
        }
        boolean b = this.m_ignoredScoutEvents.contains(String.valueOf(eventType.getSimpleName()) + ":" + name);
        return b;
    }

    @Override
    public void createField(T scoutObject, ISwingEnvironment environment) {
        this.m_scoutObject = scoutObject;
        this.m_env = environment;
        this.callInitializers();
    }

    protected final void callInitializers() {
        P_SwingAddRemoveListener listener;
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        this.initializeSwing();
        if (this.getSwingContainer() != null) {
            if (SwingScoutComposite.getCompositeOnWidget(this.getSwingContainer()) == null) {
                SwingScoutComposite.registerCompositeOnWidget(this.getSwingContainer(), this);
            }
            listener = new P_SwingAddRemoveListener();
            this.getSwingContainer().addHierarchyListener(listener);
        }
        if (this.getSwingField() != null) {
            if (SwingScoutComposite.getCompositeOnWidget(this.getSwingField()) == null) {
                SwingScoutComposite.registerCompositeOnWidget(this.getSwingField(), this);
            }
            listener = new P_SwingAddRemoveListener();
            this.getSwingField().addHierarchyListener(listener);
        }
        this.cacheSwingClientProperties();
        this.connectToScout();
    }

    @Override
    public ISwingEnvironment getSwingEnvironment() {
        return this.m_env;
    }

    protected void initializeSwing() {
    }

    protected void cacheSwingClientProperties() {
        JComponent fld = this.getSwingField();
        if (fld != null) {
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_OPAQUE)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_OPAQUE, new Boolean(fld.isOpaque()));
            }
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_BACKGROUND)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_BACKGROUND, fld.getBackground());
            }
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_FOREGROUND)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_FOREGROUND, fld.getForeground());
            }
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_FONT)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_FONT, fld.getFont());
            }
        }
    }

    @Override
    public JComponent getSwingField() {
        return this.m_swingField;
    }

    @Override
    public JComponent getSwingContainer() {
        return this.m_swingField;
    }

    protected void setSwingField(JComponent swingField) {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerObject((Object)swingField);
        }
        if (this.m_swingField == swingField) {
            return;
        }
        if (this.m_swingField != null) {
            if (this.m_swingDefaultFocusListener != null) {
                this.m_swingField.removeFocusListener(this.m_swingDefaultFocusListener);
                this.m_swingDefaultFocusListener = null;
            }
            if (this.m_swingInputVerifier != null) {
                this.m_swingField.setInputVerifier(null);
                this.m_swingInputVerifier = null;
            }
            if (this.m_swingShowingListener != null) {
                this.m_swingField.removeHierarchyListener(this.m_swingShowingListener);
                this.m_swingShowingListener = null;
            }
        }
        this.m_swingField = swingField;
        if (this.m_swingField != null) {
            if (this.getScoutObject() instanceof IFormField) {
                this.m_swingField.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((IFormField)this.getScoutObject()).getGridData()));
            }
            this.m_swingDefaultFocusListener = new P_SwingDefaultFocusListener();
            this.m_swingField.addFocusListener(this.m_swingDefaultFocusListener);
            this.m_swingInputVerifier = new P_SwingInputVerifier();
            this.m_swingField.setInputVerifier(this.m_swingInputVerifier);
            this.m_swingShowingListener = new P_SwingShowingListener();
            this.m_swingField.addHierarchyListener(this.m_swingShowingListener);
        }
    }

    @Override
    public T getScoutObject() {
        return this.m_scoutObject;
    }

    @Override
    public final void connectToScout() {
        if (!this.m_connectedToScout) {
            this.m_connectedToScout = true;
            OptimisticLock lock = CONNECT_TO_SCOUT_THREAD_OPTIMISTIC_LOCK.get();
            try {
                if (lock.acquire()) {
                    JComponent container = this.getSwingContainer();
                    if (container == null) {
                        container = this.getSwingField();
                    }
                    if (container != null) {
                        for (Component c : SwingUtility.findChildComponents(container, Component.class)) {
                            ISwingScoutComposite ui = SwingScoutComposite.getCompositeOnWidget(c);
                            if (ui == null) continue;
                            try {
                                ui.connectToScout();
                            }
                            catch (Throwable t) {
                                LOG.error("connectToScout: model=" + this.m_scoutObject + ", widget=" + c, t);
                            }
                        }
                    }
                }
            }
            finally {
                lock.release();
            }
            try {
                this.m_updateSwingFromScoutLock.acquire();
                this.attachScout();
            }
            finally {
                this.m_updateSwingFromScoutLock.release();
            }
        }
    }

    @Override
    public final void disconnectFromScout() {
        if (this.m_connectedToScout) {
            this.m_connectedToScout = false;
            OptimisticLock lock = DISCONNECT_FROM_SCOUT_THREAD_OPTIMISTIC_LOCK.get();
            try {
                if (lock.acquire()) {
                    JComponent container = this.getSwingContainer();
                    if (container == null) {
                        container = this.getSwingField();
                    }
                    if (container != null) {
                        for (Component c : SwingUtility.findChildComponents(container, Component.class)) {
                            ISwingScoutComposite ui = SwingScoutComposite.getCompositeOnWidget(c);
                            if (ui == null) continue;
                            try {
                                ui.disconnectFromScout();
                            }
                            catch (Throwable t) {
                                LOG.error("disconnectFromScout: model=" + this.m_scoutObject + ", widget=" + c, t);
                            }
                        }
                    }
                }
            }
            finally {
                lock.release();
            }
            try {
                this.m_updateSwingFromScoutLock.acquire();
                this.detachScout();
            }
            finally {
                this.m_updateSwingFromScoutLock.release();
            }
        }
    }

    public static void registerCompositeOnWidget(JComponent comp, ISwingScoutComposite ui) {
        if (comp != null) {
            comp.putClientProperty("ISwingScoutComposite", new WeakReference<ISwingScoutComposite>(ui));
        }
    }

    public static ISwingScoutComposite getCompositeOnWidget(Component comp) {
        if (comp instanceof JComponent) {
            WeakReference ref = (WeakReference)((JComponent)comp).getClientProperty("ISwingScoutComposite");
            return ref != null ? (ISwingScoutComposite)ref.get() : null;
        }
        return null;
    }

    public static IPropertyObserver getScoutModelOnWidget(Component comp) {
        ISwingScoutComposite ui = SwingScoutComposite.getCompositeOnWidget(comp);
        if (ui != null) {
            return ui.getScoutObject();
        }
        return null;
    }

    protected void attachScout() {
        if (this.m_scoutObject != null && this.m_scoutPropertyListener == null) {
            this.m_scoutPropertyListener = new P_ScoutPropertyChangeListener();
            this.m_scoutObject.addPropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
        }
    }

    protected void detachScout() {
        if (this.m_scoutObject != null && this.m_scoutPropertyListener != null) {
            this.m_scoutObject.removePropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            this.m_scoutPropertyListener = null;
        }
    }

    protected boolean existsClientProperty(JComponent comp, String key) {
        Object value = comp.getClientProperty(key);
        return value != null;
    }

    protected Object getClientProperty(JComponent comp, String key) {
        Object value = comp.getClientProperty(key);
        if (value == NULL_VALUE) {
            value = null;
        }
        return value;
    }

    protected void putClientProperty(JComponent comp, String key, Object value) {
        if (value == null) {
            value = NULL_VALUE;
        }
        comp.putClientProperty(key, value);
    }

    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
    }

    protected void handleSwingFocusGained() {
    }

    protected void handleSwingFocusLost() {
    }

    protected boolean handleSwingInputVerifier() {
        return true;
    }

    protected void handleSwingAddNotify() {
        this.connectToScout();
    }

    protected void handleSwingRemoveNotify() {
        this.disconnectFromScout();
    }

    protected void handleSwingShowing() {
    }

    protected void setInputDirty(boolean inputDirty) {
        this.m_inputDirty = inputDirty;
    }

    protected boolean isInputDirty() {
        return this.m_inputDirty;
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener,
    WeakEventListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if (SwingScoutComposite.this.isIgnoredScoutEvent(PropertyChangeEvent.class, e.getPropertyName())) {
                return;
            }
            if (SwingScoutComposite.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue())) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingScoutComposite.this.m_updateSwingFromScoutLock.acquire();
                            SwingScoutComposite.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                        }
                        finally {
                            SwingScoutComposite.this.m_updateSwingFromScoutLock.release();
                        }
                    }
                };
                SwingScoutComposite.this.getSwingEnvironment().invokeSwingLater(t);
            }
        }
    }

    private class P_SwingAddRemoveListener
    implements HierarchyListener {
        private P_SwingAddRemoveListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getID() == 1400 && (e.getChangeFlags() & 2L) != 0L) {
                if (e.getComponent().isDisplayable()) {
                    SwingScoutComposite.this.handleSwingAddNotify();
                } else {
                    SwingScoutComposite.this.handleSwingRemoveNotify();
                }
            }
        }
    }

    private class P_SwingDefaultFocusListener
    extends FocusAdapter {
        private P_SwingDefaultFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent f) {
            if (f.isTemporary()) {
                return;
            }
            SwingScoutComposite.this.setInputDirty(true);
            SwingScoutComposite.this.handleSwingFocusGained();
        }

        @Override
        public void focusLost(FocusEvent f) {
            SwingScoutComposite.this.handleSwingFocusLost();
        }
    }

    private class P_SwingInputVerifier
    extends InputVerifier {
        private boolean m_lastResult = true;

        private P_SwingInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            if (SwingScoutComposite.this.isInputDirty() && SwingScoutComposite.this.getUpdateSwingFromScoutLock().isReleased()) {
                this.m_lastResult = SwingScoutComposite.this.handleSwingInputVerifier();
            }
            if (this.m_lastResult) {
                SwingScoutComposite.this.setInputDirty(false);
            }
            return this.m_lastResult;
        }
    }

    private class P_SwingShowingListener
    implements HierarchyListener {
        private P_SwingShowingListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getID() == 1400 && (e.getChangeFlags() & 4L) != 0L) {
                Component c = (Component)e.getSource();
                boolean b = false;
                try {
                    b = c.isShowing();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (b) {
                    SwingScoutComposite.this.handleSwingShowing();
                }
            }
        }
    }
}

