/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.activitymap;

import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JTable;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.ui.swing.basic.activitymap.SwingActivityComponent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityComponent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapModel;

public class SwingActivityMapModel
implements ActivityMapModel {
    private final IActivityMap m_map;
    private final JTable m_metricsTable;
    private final SwingActivityComponent[] m_components;

    public SwingActivityMapModel(IActivityMap map, JTable metricsTable) {
        this.m_map = map;
        this.m_metricsTable = metricsTable;
        Object[] resourceIds = map.getResourceIds();
        ArrayList<SwingActivityComponent> list = new ArrayList<SwingActivityComponent>();
        int i = 0;
        while (i < resourceIds.length) {
            ActivityCell[] activityCellArray = map.getActivityCells(resourceIds[i]);
            int n = activityCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityCell cell = activityCellArray[n2];
                list.add(new SwingActivityComponent(cell, i));
                ++n2;
            }
            ++i;
        }
        this.m_components = list.toArray(new SwingActivityComponent[list.size()]);
    }

    @Override
    public int getRowCount() {
        return this.m_metricsTable.getRowCount();
    }

    @Override
    public int getRowHeight(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.m_metricsTable.getRowCount()) {
            return this.m_metricsTable.getRowHeight(rowIndex);
        }
        return this.m_metricsTable.getRowHeight();
    }

    @Override
    public int getRowLocation(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.m_metricsTable.getRowCount()) {
            return this.m_metricsTable.getCellRect((int)rowIndex, (int)0, (boolean)true).y;
        }
        return 0;
    }

    @Override
    public int getRowAtLocation(int y) {
        int i = this.m_metricsTable.rowAtPoint(new Point(1, y));
        if (i < 0 && y > 0) {
            i = this.getRowCount();
        }
        return i;
    }

    @Override
    public int getHeaderHeight() {
        if (this.m_metricsTable.getTableHeader() != null) {
            return this.m_metricsTable.getTableHeader().getHeight();
        }
        return 0;
    }

    @Override
    public ActivityComponent[] getActivities() {
        return this.m_components;
    }

    @Override
    public double[] getActivityRange(ActivityComponent a) {
        SwingActivityComponent sa = (SwingActivityComponent)a;
        ActivityCell cell = sa.getScoutActivityCell();
        return this.m_map.getTimeScale().getRangeOf(cell.getBeginTime(), cell.getEndTime());
    }
}

