/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.activitymap;

import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityMapEvent;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityMapListener;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScale;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.activitymap.SwingActivityComponent;
import org.eclipse.scout.rt.ui.swing.basic.activitymap.SwingActivityMapColumnModel;
import org.eclipse.scout.rt.ui.swing.basic.activitymap.SwingActivityMapModel;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapSelectionEvent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapSelectionListener;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.JActivityMap;

public class SwingScoutActivityMap
extends SwingScoutComposite<IActivityMap<?, ?>> {
    private JScrollPane m_swingScrollPane;
    private JTable m_metricsTable;
    private ActivityMapListener m_scoutListener;

    public SwingScoutActivityMap(JTable metricsTable) {
        this.m_metricsTable = metricsTable;
    }

    @Override
    protected void initializeSwing() {
        final JActivityMap activityMap = new JActivityMap();
        this.m_swingScrollPane = new JScrollPaneEx(activityMap, 22, 31);
        this.m_swingScrollPane.setOpaque(false);
        activityMap.addActivityMapSelectionListener(new ActivityMapSelectionListener(){

            @Override
            public void selectionChanged(ActivityMapSelectionEvent e) {
                SwingScoutActivityMap.this.setSelectionFromSwing(e.getRows(), e.getRange());
            }
        });
        activityMap.addActivityProxyMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
                if (e.isPopupTrigger() && !activityMap.isInsideSelection(e)) {
                    SwingScoutActivityMap.this.handleSwingEditActivityPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && !activityMap.isInsideSelection(e)) {
                    SwingScoutActivityMap.this.handleSwingEditActivityPopup(e);
                }
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix.mouseClicked()) {
                    return;
                }
                if (e.getClickCount() == 2 && !e.isMetaDown()) {
                    SwingScoutActivityMap.this.handleCellActionFromSwing(e);
                }
            }
        });
        activityMap.addActivityProxyFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                SwingScoutActivityMap.this.setSelectedActivityCellFromSwing((SwingActivityComponent)e.getComponent());
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                SwingScoutActivityMap.this.setSelectedActivityCellFromSwing(null);
            }
        });
        activityMap.getSelector().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && activityMap.isInsideSelection(e)) {
                    SwingScoutActivityMap.this.handleSwingNewActivityPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && activityMap.isInsideSelection(e)) {
                    SwingScoutActivityMap.this.handleSwingNewActivityPopup(e);
                }
            }
        });
        activityMap.addMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix.mouseClicked()) {
                    return;
                }
                if (e.getClickCount() == 2 && !e.isMetaDown()) {
                    SwingScoutActivityMap.this.handleCellActionFromSwing(e);
                }
            }
        });
        this.setSwingField(activityMap);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutListener == null) {
            this.m_scoutListener = new ActivityMapListener(){

                public void activityMapChanged(final ActivityMapEvent e) {
                    if (SwingScoutActivityMap.this.isIgnoredScoutEvent(ActivityMapEvent.class, "" + e.getType())) {
                        return;
                    }
                    switch (e.getType()) {
                        case 100: 
                        case 101: 
                        case 102: 
                        case 105: {
                            Runnable t = new Runnable(){

                                @Override
                                public void run() {
                                    switch (e.getType()) {
                                        case 100: 
                                        case 101: 
                                        case 102: 
                                        case 105: {
                                            try {
                                                SwingScoutActivityMap.this.getUpdateSwingFromScoutLock().acquire();
                                                SwingScoutActivityMap.this.handleActivitiesChangedFromScout();
                                            }
                                            finally {
                                                SwingScoutActivityMap.this.getUpdateSwingFromScoutLock().release();
                                            }
                                        }
                                    }
                                }
                            };
                            SwingScoutActivityMap.this.getSwingEnvironment().invokeSwingLater(t);
                        }
                    }
                }
            };
            this.getScoutActivityMap().addActivityMapListener(this.m_scoutListener);
        }
        this.getSwingActivityMap().setModel(new SwingActivityMapModel(this.getScoutActivityMap(), this.m_metricsTable));
        this.getSwingActivityMap().setColumnModel(new SwingActivityMapColumnModel(this.getScoutActivityMap().getTimeScale()));
        this.getSwingActivityMap().getSelector().setDrawSections(this.getScoutActivityMap().isDrawSections());
        this.setSelectionFromScout();
    }

    public IActivityMap<?, ?> getScoutActivityMap() {
        return (IActivityMap)this.getScoutObject();
    }

    public JActivityMap getSwingActivityMap() {
        return (JActivityMap)this.getSwingField();
    }

    public JScrollPane getSwingScrollPane() {
        return this.m_swingScrollPane;
    }

    private void setTimeScaleFromScout(TimeScale scale) {
        this.getSwingActivityMap().setColumnModel(new SwingActivityMapColumnModel(scale));
        this.setSelectionFromScout();
    }

    private void setResourceIdsFromScout(Object[] resourceIds) {
        this.getSwingActivityMap().setModel(new SwingActivityMapModel(this.getScoutActivityMap(), this.m_metricsTable));
    }

    private void setSelectedActivityCellFromScout(ActivityCell cell) {
    }

    private void setSelectedActivityCellFromSwing(SwingActivityComponent comp) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        final ActivityCell cell = comp != null ? comp.getScoutActivityCell() : null;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                SwingScoutActivityMap.this.getScoutActivityMap().getUIFacade().setSelectedActivityCellFromUI(cell);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    private void handleCellActionFromSwing(MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        final ActivityCell cell = e.getComponent() instanceof SwingActivityComponent ? ((SwingActivityComponent)e.getComponent()).getScoutActivityCell() : null;
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.getSwingActivityMap());
        final double[] range = this.getSwingActivityMap().pixToRange(p.x);
        final int row = this.getSwingActivityMap().pixToRow(p.y);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                Object resourceId = SwingScoutActivityMap.this.getScoutActivityMap().getResourceIds()[row];
                SwingScoutActivityMap.this.getScoutActivityMap().getUIFacade().fireCellActionFromUI(resourceId, range, cell);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 2345L);
    }

    private void setSelectionFromScout() {
        HashSet<Object> selectedIds = new HashSet<Object>(Arrays.asList(this.getScoutActivityMap().getSelectedResourceIds()));
        Object[] ids = this.getScoutActivityMap().getResourceIds();
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        int i = 0;
        while (i < ids.length) {
            if (selectedIds.contains(ids[i])) {
                indexes.add(i);
            }
            ++i;
        }
        int[] rowIndexes = new int[indexes.size()];
        int i2 = 0;
        for (Integer n : indexes) {
            rowIndexes[i2++] = n;
        }
        double[] range = this.getScoutActivityMap().getTimeScale().getRangeOf(this.getScoutActivityMap().getSelectedBeginTime(), this.getScoutActivityMap().getSelectedEndTime());
        this.getSwingActivityMap().setSelection(rowIndexes, range);
    }

    private void setSelectionFromSwing(int[] rows, double[] range) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        final double[] normalizedRange = range;
        Object[] ids = this.getScoutActivityMap().getResourceIds();
        final HashSet<Object> selectedIds = new HashSet<Object>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            selectedIds.add(ids[i]);
            ++n2;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                SwingScoutActivityMap.this.getScoutActivityMap().getUIFacade().setSelectionFromUI(selectedIds.toArray(new Object[selectedIds.size()]), normalizedRange);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutListener != null) {
            this.getScoutActivityMap().removeActivityMapListener(this.m_scoutListener);
            this.m_scoutListener = null;
        }
    }

    @Override
    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("timeScale")) {
            return true;
        }
        if (name.equals("selectedActivityCell")) {
            return true;
        }
        if (name.equals("selectedResourceIds")) {
            return true;
        }
        if (name.equals("selectedBeginTime")) {
            return true;
        }
        if (name.equals("selectedEndTime")) {
            return true;
        }
        if (name.equals("drawSections")) {
            return true;
        }
        return super.isHandleScoutPropertyChange(name, newValue);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("timeScale")) {
            this.setTimeScaleFromScout((TimeScale)newValue);
        } else if (name.equals("selectedActivityCell")) {
            this.setSelectedActivityCellFromScout((ActivityCell)newValue);
        } else if (name.equals("selectedResourceIds") || name.equals("selectedBeginTime") || name.equals("selectedEndTime")) {
            this.setSelectionFromScout();
        } else if (name.equals("resourceIds")) {
            this.setResourceIdsFromScout((Object[])newValue);
        } else if (name.equals("drawSections")) {
            this.getSwingActivityMap().getSelector().setDrawSections((Boolean)newValue);
        }
    }

    private void handleActivitiesChangedFromScout() {
        this.getSwingActivityMap().setModel(new SwingActivityMapModel(this.getScoutActivityMap(), this.m_metricsTable));
    }

    private void handleSwingNewActivityPopup(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                IMenu[] scoutMenus = SwingScoutActivityMap.this.getScoutActivityMap().getUIFacade().fireNewActivityPopupFromUI();
                new SwingPopupWorker(SwingScoutActivityMap.this.getSwingEnvironment(), e.getComponent(), e.getPoint(), scoutMenus, false).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }

    private void handleSwingEditActivityPopup(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                IMenu[] scoutMenus = SwingScoutActivityMap.this.getScoutActivityMap().getUIFacade().fireEditActivityPopupFromUI();
                new SwingPopupWorker(SwingScoutActivityMap.this.getSwingEnvironment(), e.getComponent(), e.getPoint(), scoutMenus, false).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }
}

