/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table.celleditor;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ISwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.table.ISwingScoutTable;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableColumn;
import org.eclipse.scout.rt.ui.swing.basic.table.celleditor.FormFieldPopupEvent;
import org.eclipse.scout.rt.ui.swing.basic.table.celleditor.IFormFieldPopupEventListener;
import org.eclipse.scout.rt.ui.swing.basic.table.celleditor.SwingScoutFormFieldPopup;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;

public class SwingScoutTableCellEditor {
    public static final String TABLE_CELL_INSETS = String.valueOf(SwingScoutTableCellEditor.class.getName()) + "#insets";
    private ISwingScoutTable m_tableComposite;
    private FocusTraversalPolicy m_focusTraversalPolicy;
    private TableCellEditor m_cellEditor;
    private boolean m_tableIsEditingAndContainsFocus;
    private JComponent m_cachedSwingEditorComponent;
    private CellEditorListener m_cellEditorListener;

    public SwingScoutTableCellEditor(ISwingScoutTable tableComposite) {
        this.m_tableComposite = tableComposite;
        this.m_focusTraversalPolicy = new SwingScoutFocusTraversalPolicy();
        this.m_cellEditor = new P_SwingCellEditor();
        this.m_cellEditorListener = new P_CellEditorListener();
        this.m_cellEditor.addCellEditorListener(this.m_cellEditorListener);
    }

    public void initialize() {
        this.m_tableComposite.getSwingTable().setDefaultEditor(Object.class, this.m_cellEditor);
    }

    protected JComponent getCachedEditorComposite(int row, int col) {
        if (this.m_cachedSwingEditorComponent == null) {
            ISwingScoutComposite<? extends IFormField> editorComposite = this.createEditorComposite(row, col);
            if (editorComposite != null) {
                this.decorateEditorComposite(editorComposite, row, col);
                this.m_cachedSwingEditorComponent = editorComposite.getSwingContainer();
            } else {
                this.m_cachedSwingEditorComponent = null;
            }
        }
        return this.m_cachedSwingEditorComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISwingScoutComposite<? extends IFormField> createEditorComposite(int row, int col) {
        IFormField formField;
        final ITableRow scoutRow = ((ITable)this.m_tableComposite.getScoutObject()).getFilteredRow(row);
        final IColumn scoutColumn = ((ITable)this.m_tableComposite.getScoutObject()).getColumnSet().getVisibleColumn(col);
        final AtomicReference fieldRef = new AtomicReference();
        if (scoutRow != null && scoutColumn != null) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    fieldRef.set(((ITable)SwingScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().prepareCellEditFromUI(scoutRow, scoutColumn));
                    AtomicReference atomicReference = fieldRef;
                    synchronized (atomicReference) {
                        fieldRef.notifyAll();
                    }
                }
            };
            AtomicReference atomicReference = fieldRef;
            synchronized (atomicReference) {
                this.m_tableComposite.getSwingEnvironment().invokeScoutLater(t, 2345L);
                try {
                    fieldRef.wait(2345L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if ((formField = (IFormField)fieldRef.get()) == null) {
            return null;
        }
        Insets cellInsets = new Insets(0, 0, 0, 0);
        TableCellRenderer cellRenderer = this.m_tableComposite.getSwingTable().getCellRenderer(row, col);
        cellRenderer = (TableCellRenderer)((Object)this.m_tableComposite.getSwingTable().prepareRenderer(cellRenderer, row, col));
        if (cellRenderer instanceof DefaultTableCellRenderer) {
            cellInsets = ((DefaultTableCellRenderer)cellRenderer).getInsets();
        }
        this.m_tableComposite.getSwingTable().putClientProperty(TABLE_CELL_INSETS, cellInsets);
        try {
            if (scoutColumn instanceof IBooleanColumn) {
                GridData gd = formField.getGridDataHints();
                gd.verticalAlignment = ((IBooleanColumn)scoutColumn).getVerticalAlignment();
                gd.horizontalAlignment = scoutColumn.getHorizontalAlignment();
                formField.setGridDataHints(gd);
            }
            if (formField instanceof IStringField && ((IStringField)formField).isMultilineText()) {
                ISwingScoutComposite<? extends IFormField> iSwingScoutComposite = this.createEditorCompositesPopup(formField, row, col);
                return iSwingScoutComposite;
            }
            ISwingScoutFormField iSwingScoutFormField = this.m_tableComposite.getSwingEnvironment().createFormField(this.m_tableComposite.getSwingTable(), formField);
            return iSwingScoutFormField;
        }
        finally {
            this.m_tableComposite.getSwingTable().putClientProperty(TABLE_CELL_INSETS, null);
        }
    }

    protected ISwingScoutComposite<? extends IFormField> createEditorCompositesPopup(IFormField formField, final int row, final int col) {
        GridData gd = formField.getGridData();
        gd.h = 1;
        gd.w = 0;
        gd.weightY = 1.0;
        gd.weightX = 1.0;
        formField.setGridDataInternal(gd);
        int prefWidth = gd.widthInPixel;
        int minWidth = this.m_tableComposite.getSwingTable().getColumnModel().getColumn(col).getWidth();
        int prefHeight = gd.heightInPixel;
        int minHeight = Math.max(95, this.m_tableComposite.getSwingTable().getRowHeight(row));
        prefHeight = Math.max(prefHeight, minHeight);
        prefWidth = Math.max(prefWidth, minWidth);
        final IFormFieldPopupEventListener popupListener = new IFormFieldPopupEventListener(){

            @Override
            public void handleEvent(FormFieldPopupEvent event) {
                if ((event.getType() & 1) > 0) {
                    SwingScoutTableCellEditor.this.m_cellEditor.stopCellEditing();
                } else if ((event.getType() & 2) > 0) {
                    SwingScoutTableCellEditor.this.m_cellEditor.cancelCellEditing();
                }
                if ((event.getType() & 8) > 0) {
                    SwingScoutTableCellEditor.this.enqueueEditNextTableCell(row, col, false);
                } else if ((event.getType() & 4) > 0) {
                    SwingScoutTableCellEditor.this.enqueueEditNextTableCell(row, col, true);
                }
            }
        };
        JPanel cellEditorPanel = new JPanel();
        cellEditorPanel.setOpaque(false);
        final SwingScoutFormFieldPopup formFieldDialog = new SwingScoutFormFieldPopup(cellEditorPanel);
        formFieldDialog.setMinHeight(minHeight);
        formFieldDialog.setMinWidth(minWidth);
        formFieldDialog.setPrefHeight(prefHeight);
        formFieldDialog.setPrefWidth(prefWidth);
        formFieldDialog.createField(formField, this.m_tableComposite.getSwingEnvironment());
        formFieldDialog.addEventListener(popupListener);
        this.m_cellEditor.removeCellEditorListener(this.m_cellEditorListener);
        this.m_cellEditor.addCellEditorListener(new P_CellEditorListener(this){

            @Override
            public void editingStopped(ChangeEvent e) {
                this.closePopup(1);
                this.restoreCellEditorListener();
                super.editingStopped(e);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                this.closePopup(2);
                this.restoreCellEditorListener();
                super.editingCanceled(e);
            }

            private void closePopup(int popupEvent) {
                if (formFieldDialog.isClosed()) {
                    return;
                }
                formFieldDialog.removeEventListener(popupListener);
                formFieldDialog.closePopup(popupEvent);
            }

            private void restoreCellEditorListener() {
                m_cellEditor.removeCellEditorListener(this);
                m_cellEditor.addCellEditorListener(m_cellEditorListener);
            }
        });
        return formFieldDialog;
    }

    protected void decorateEditorComposite(ISwingScoutComposite<? extends IFormField> editorComposite, final int row, final int col) {
        JComponent jc;
        JComponent editorField = editorComposite.getSwingContainer();
        Component firstField = this.m_focusTraversalPolicy.getFirstComponent(editorField);
        Component lastField = this.m_focusTraversalPolicy.getLastComponent(editorField);
        if (firstField != null) {
            firstField.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(final HierarchyEvent e) {
                    if (e.getID() == 1400 && (e.getChangeFlags() & 4L) != 0L && e.getComponent().isShowing()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                e.getComponent().requestFocus();
                            }
                        });
                    }
                }
            });
        }
        if (firstField instanceof JComponent) {
            jc = (JComponent)firstField;
            jc.setFocusTraversalKeys(1, new HashSet());
            jc.getInputMap(0).put(SwingUtility.createKeystroke("shift TAB"), "reverse-tab");
            jc.getActionMap().put("reverse-tab", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.stopCellEditing();
                    SwingScoutTableCellEditor.this.enqueueEditNextTableCell(row, col, false);
                }
            });
        }
        if (lastField instanceof JComponent) {
            jc = (JComponent)lastField;
            jc.setFocusTraversalKeys(0, new HashSet());
            jc.getInputMap(0).put(SwingUtility.createKeystroke("TAB"), "tab");
            jc.getActionMap().put("tab", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.stopCellEditing();
                    SwingScoutTableCellEditor.this.enqueueEditNextTableCell(row, col, true);
                }
            });
        }
    }

    protected void saveEditorFromSwing() {
        this.m_tableIsEditingAndContainsFocus = false;
        if (this.m_cachedSwingEditorComponent != null) {
            this.m_cachedSwingEditorComponent = null;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwingScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().completeCellEditFromUI();
                }
            };
            this.m_tableComposite.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected boolean isBooleanColumnAt(Point p) {
        TableColumn tc;
        JTableEx table = this.m_tableComposite.getSwingTable();
        int col = table.columnAtPoint(p);
        if (col >= 0 && (tc = table.getColumnModel().getColumn(col)) instanceof SwingTableColumn) {
            IColumn scoutCol = ((SwingTableColumn)tc).getScoutColumn();
            return scoutCol instanceof IBooleanColumn;
        }
        return false;
    }

    protected void cancelEditorFromSwing() {
        this.m_tableIsEditingAndContainsFocus = false;
        if (this.m_cachedSwingEditorComponent != null) {
            this.m_cachedSwingEditorComponent = null;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwingScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().cancelCellEditFromUI();
                }
            };
            this.m_tableComposite.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void enqueueEditNextTableCell(int uiRow, int uiCol, final boolean forward) {
        if (uiRow < 0 || uiCol < 0) {
            return;
        }
        final ITableRow row = ((ITable)this.m_tableComposite.getScoutObject()).getFilteredRow(uiRow);
        final IColumn col = ((ITable)this.m_tableComposite.getScoutObject()).getColumnSet().getVisibleColumn(uiCol);
        if (row == null || col == null) {
            return;
        }
        this.m_tableComposite.getSwingEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                if (SwingScoutTableCellEditor.this.m_tableComposite.getSwingEnvironment() == null) {
                    return;
                }
                ITable table = (ITable)SwingScoutTableCellEditor.this.m_tableComposite.getScoutObject();
                TableUtility.editNextTableCell((ITable)table, (ITableRow)row, (IColumn)col, (boolean)forward, null);
            }
        }, 0L);
    }

    protected void permanentFocusOwnerChanged(PropertyChangeEvent e) {
        boolean newValue;
        Component c = (Component)e.getNewValue();
        if (c == null) {
            return;
        }
        Window w1 = SwingUtilities.getWindowAncestor(c);
        Window w2 = SwingUtilities.getWindowAncestor(this.m_tableComposite.getSwingContainer());
        if (w1 == null || w2 == null || w1 != w2 && SwingUtilities.isDescendingFrom(w1, w2)) {
            return;
        }
        boolean oldValue = this.m_tableIsEditingAndContainsFocus;
        this.m_tableIsEditingAndContainsFocus = newValue = SwingUtilities.isDescendingFrom(c, this.m_tableComposite.getSwingTable()) && c != this.m_tableComposite.getSwingTable();
        if (oldValue && !newValue && this.m_cellEditor != null) {
            this.m_cellEditor.stopCellEditing();
        }
    }

    private static class GlobalFocusListener
    implements PropertyChangeListener {
        private WeakReference<SwingScoutTableCellEditor> m_editorRef;

        public GlobalFocusListener(SwingScoutTableCellEditor editor) {
            this.m_editorRef = new WeakReference<SwingScoutTableCellEditor>(editor);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SwingScoutTableCellEditor editor = (SwingScoutTableCellEditor)this.m_editorRef.get();
            if (editor == null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this);
                return;
            }
            editor.permanentFocusOwnerChanged(e);
        }
    }

    private class P_CellEditorListener
    implements CellEditorListener {
        private P_CellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            SwingScoutTableCellEditor.this.saveEditorFromSwing();
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            SwingScoutTableCellEditor.this.cancelEditorFromSwing();
        }

        /* synthetic */ P_CellEditorListener(P_CellEditorListener p_CellEditorListener, P_CellEditorListener p_CellEditorListener2) {
            this();
        }
    }

    private class P_SwingCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private int m_clickCountToStart = 1;
        private JPanelEx m_container = new JPanelEx(new SingleLayout());

        public P_SwingCellEditor() {
            this.m_container.setOpaque(false);
            this.m_container.getInputMap(1).put(SwingUtility.createKeystroke("ESCAPE"), "cancel");
            this.m_container.getInputMap(1).put(SwingUtility.createKeystroke("ENTER"), "enter");
            this.m_container.getActionMap().put("cancel", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.cancelCellEditing();
                }
            });
            this.m_container.getActionMap().put("enter", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.stopCellEditing();
                }
            });
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", new GlobalFocusListener(SwingScoutTableCellEditor.this));
        }

        public void setClickCountToStart(int count) {
            this.m_clickCountToStart = count;
        }

        public int getClickCountToStart() {
            return this.m_clickCountToStart;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                if (SwingScoutTableCellEditor.this.isBooleanColumnAt(((MouseEvent)e).getPoint())) {
                    return false;
                }
                return ((MouseEvent)e).getClickCount() >= this.getClickCountToStart();
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_container.removeAll();
            JComponent c = SwingScoutTableCellEditor.this.getCachedEditorComposite(row, column);
            if (c != null) {
                this.m_container.add(c);
            }
            return this.m_container;
        }
    }
}

