/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JRootPaneEx;

public class JFrameEx
extends JFrame {
    private static final long serialVersionUID = 1L;
    private boolean m_autoCorrectSize;
    private Rectangle m_nonMaximizedBounds;
    private P_ComponentListener m_componentListener;

    public JFrameEx() {
        this.setDefaultCloseOperation(2);
        this.enableEvents(1L);
        this.initComponentListener();
        this.m_autoCorrectSize = true;
    }

    private void initComponentListener() {
        if (!SwingUtility.hasScoutLookAndFeelFrameAndDialog()) {
            this.m_componentListener = new P_ComponentListener();
            this.addComponentListener(this.m_componentListener);
        }
    }

    public boolean isAutoCorrectSize() {
        return this.m_autoCorrectSize;
    }

    public void setAutoCorrectSize(boolean b) {
        this.m_autoCorrectSize = b;
    }

    public Rectangle getNonMaximizedBounds() {
        return this.m_nonMaximizedBounds;
    }

    @Override
    public synchronized void setExtendedState(int state) {
        if ((state & 6) != 0) {
            this.m_nonMaximizedBounds = this.getBounds();
        }
        int oldState = this.getExtendedState();
        if (SwingUtility.hasScoutLookAndFeelFrameAndDialog()) {
            this.setExtendedStateForLookAndFeel(state);
        } else {
            super.setExtendedState(state);
        }
        int newState = this.getExtendedState();
        this.firePropertyChange("state", oldState, newState);
    }

    @Override
    public void toFront() {
        this.setState(1);
        this.setState(0);
        super.toFront();
    }

    @Override
    protected JRootPane createRootPane() {
        return new JRootPaneEx(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void reflow() {
                if (JFrameEx.this.m_autoCorrectSize) {
                    JFrameEx.this.pack();
                }
            }
        };
    }

    @Override
    public void dispose() {
        if (this.m_componentListener != null) {
            this.removeComponentListener(this.m_componentListener);
        }
        super.dispose();
    }

    private void setExtendedStateForLookAndFeel(int state) {
        if (!SwingUtility.hasScoutLookAndFeelFrameAndDialog()) {
            return;
        }
        Rectangle r = this.getBounds();
        Rectangle screen = SwingUtility.getFullScreenBoundsFor(r, false);
        GraphicsDevice screenDevice = SwingUtility.getCurrentScreen(r);
        Insets screenInsets = SwingUtility.getScreenInsets(screenDevice);
        screen.x = screenInsets.left;
        screen.y = screenInsets.top;
        this.setMaximizedBounds(screen);
        int oldState = this.getExtendedState();
        super.setExtendedState(state);
        if ((state & 6) != 0) {
            Rectangle fullscreen = SwingUtility.getFullScreenBoundsFor(this.getBounds(), true);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge.getScreenDevices().length >= 2 && fullscreen.x != 0 && this.getBounds() != null && (this.getBounds().width != screen.width || this.getBounds().height != screen.height)) {
                Rectangle screen0 = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
                screen.width = screen0.width;
                screen.height = screen0.height;
                this.setMaximizedBounds(screen);
                super.setExtendedState(oldState);
                super.setExtendedState(state);
            }
        }
    }

    private class P_ComponentListener
    extends ComponentAdapter {
        private P_ComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (JFrameEx.this.getExtendedState() == 0) {
                JFrameEx.this.m_nonMaximizedBounds = JFrameEx.this.getBounds();
            }
        }
    }
}

