/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import org.eclipse.scout.rt.ui.swing.ext.calendar.AbstractCalendarCell;

public class LargeCalendarCellBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private Border m_defaultBorder = new LineBorder(Color.lightGray, 1);
    private Border m_selectBorder;
    private Border m_focusBorder;
    private Border m_selectAndFocusBorder;

    public LargeCalendarCellBorder(Color foreground) {
        this.m_selectBorder = new LineBorder(foreground, 1);
        this.m_focusBorder = new CompoundBorder(new LineBorder(Color.lightGray, 1), new LineBorder(Color.lightGray, 1));
        this.m_selectAndFocusBorder = new CompoundBorder(new LineBorder(foreground, 1), new LineBorder(Color.lightGray, 1));
    }

    private Border getInternalBorder(Component c) {
        AbstractCalendarCell cell = (AbstractCalendarCell)c;
        if (cell.isSelected() && cell.isFocusOwner()) {
            return this.m_selectAndFocusBorder;
        }
        if (cell.isSelected()) {
            return this.m_selectBorder;
        }
        if (cell.isFocusOwner()) {
            return this.m_focusBorder;
        }
        return this.m_defaultBorder;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets in = new Insets(0, 0, 0, 0);
        return this.getBorderInsets(c, in);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets in) {
        Border border = this.getInternalBorder(c);
        if (border instanceof AbstractBorder) {
            return ((AbstractBorder)border).getBorderInsets(c, in);
        }
        Insets t = border.getBorderInsets(c);
        in.top = t.top;
        in.left = t.left;
        in.bottom = t.bottom;
        in.right = t.right;
        return in;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getInternalBorder(c);
        border.paintBorder(c, g, x, y, width, height);
    }
}

