/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.job;

import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;

public class SwingProgressMonitor
extends AbstractPropertyObserver
implements IProgressMonitorWithBlocking {
    public static final String PROP_TASK_NAME = "taskName";
    public static final String PROP_SUB_TASK_NAME = "subTaskName";
    public static final String PROP_WORKED = "worked";
    public static final String PROP_CANCELLED = "cancelled";
    private double m_internalTotalWork;
    private double m_internalWorked;

    public void beginTask(String name, int totalWork) {
        this.propertySupport.setPropertyString(PROP_SUB_TASK_NAME, null);
        this.propertySupport.setPropertyString(PROP_TASK_NAME, name);
        this.m_internalTotalWork = totalWork;
        this.m_internalWorked = 0.0;
        this.setWorked(0.0);
    }

    public void done() {
        this.m_internalWorked = this.m_internalTotalWork;
        this.setWorked(1.0);
    }

    public void setWorked(double worked) {
        this.propertySupport.setPropertyDouble(PROP_WORKED, worked);
    }

    public double getWorked() {
        return this.propertySupport.getPropertyDouble(PROP_WORKED);
    }

    public void internalWorked(double work) {
        this.m_internalWorked += work;
        if (this.m_internalTotalWork > 0.0) {
            this.setWorked(this.m_internalWorked / this.m_internalTotalWork);
        } else {
            this.setWorked(0.0);
        }
    }

    public boolean isCanceled() {
        return this.propertySupport.getPropertyBool(PROP_CANCELLED);
    }

    public void setCanceled(boolean cancelled) {
        this.propertySupport.setPropertyBool(PROP_CANCELLED, cancelled);
    }

    public void setTaskName(String name) {
        this.propertySupport.setPropertyString(PROP_TASK_NAME, name);
    }

    public String getTaskName() {
        return this.propertySupport.getPropertyString(PROP_TASK_NAME);
    }

    public void subTask(String name) {
        this.propertySupport.setPropertyString(PROP_SUB_TASK_NAME, name);
    }

    public String getSubTaskName() {
        return this.propertySupport.getPropertyString(PROP_SUB_TASK_NAME);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public void clearBlocked() {
    }

    public void setBlocked(IStatus reason) {
    }
}

