/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.labelfield;

import javax.swing.JLabel;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.labelfield.ISwingScoutLabelField;

public class SwingScoutLabelField
extends SwingScoutValueFieldComposite<ILabelField>
implements ISwingScoutLabelField {
    private static final long serialVersionUID = 1L;
    private JPanelEx m_fieldPanel;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        this.m_fieldPanel = new JPanelEx(new SingleLayout());
        LogicalGridData fieldData = LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((ILabelField)this.getScoutObject()).getGridData());
        fieldData.topInset = SwingLayoutUtility.getTextFieldTopInset();
        this.m_fieldPanel.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, fieldData);
        JLabelEx labelField = new JLabelEx();
        this.m_fieldPanel.add(labelField);
        container.add(this.m_fieldPanel);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(labelField);
        LogicalGridLayout layout = new LogicalGridLayout(this.getSwingEnvironment(), 1, 0);
        this.getSwingContainer().setLayout(layout);
    }

    @Override
    public JLabelEx getSwingLabelField() {
        return (JLabelEx)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        ILabelField f = (ILabelField)this.getScoutObject();
        this.setTextWrapFromScout(f.isWrapText());
    }

    protected void setTextWrapFromScout(boolean b) {
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        JLabelEx swingField = this.getSwingLabelField();
        String oldText = swingField.getText();
        if (s == null) {
            s = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        if (oldText.equals(s)) {
            return;
        }
        ((JLabel)swingField).setText(s);
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        this.getSwingLabelField().setHorizontalAlignment(SwingUtility.createHorizontalAlignment(scoutAlign));
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("wrapText")) {
            this.setTextWrapFromScout((Boolean)newValue);
        }
    }
}

