/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.mailfield;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class SwingMailAttachment {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingMailAttachment.class);
    private Part m_part;
    private File m_file;

    public SwingMailAttachment(Part part, File tempFolder) {
        this.m_part = part;
        try {
            String filename = this.m_part.getFileName();
            if (filename != null) {
                filename = filename.replaceAll("[/\\\\]", "_");
            } else {
                String extension = ".txt";
                if (this.m_part.getContentType().equals("message/rfc822")) {
                    extension = ".eml";
                }
                filename = IOUtility.getTempFileName((String)extension);
                filename = filename.substring(filename.lastIndexOf("\\") + 1, filename.length());
            }
            this.m_file = new File(tempFolder, filename);
            IOUtility.writeContent((OutputStream)new FileOutputStream(this.m_file), (byte[])IOUtility.getContent((InputStream)this.m_part.getInputStream()));
            this.m_file.deleteOnExit();
        }
        catch (Exception e) {
            LOG.error("could not create temp file of attachement.", (Throwable)e);
        }
    }

    public String getContentId() {
        try {
            String[] ids = this.m_part.getHeader("Content-ID");
            if (ids != null && ids.length > 0) {
                String cid = ids[0];
                if (cid.matches("<.*>")) {
                    cid = cid.substring(1, cid.length() - 1);
                }
                return cid;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    public String getContentType() {
        try {
            return this.m_part.getContentType();
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public Part getPart() {
        return this.m_part;
    }

    public File getFile() {
        return this.m_file;
    }
}

