/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.radiobuttongroup.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;

public class RadioButtonGroupLayout
extends AbstractLayoutManager2 {
    private IRadioButtonGroup<?> m_scoutField;
    private int m_hgap;
    private int m_vgap;
    private Component[][] m_buttons;
    private Dimension[][] m_sizes;

    public RadioButtonGroupLayout(IRadioButtonGroup<?> scoutField, int hgap, int vgap) {
        this.m_scoutField = scoutField;
        this.m_hgap = hgap;
        this.m_vgap = vgap;
    }

    @Override
    protected Dimension getLayoutSize(Container parent, int sizeflag) {
        Dimension result = new Dimension();
        int r = 0;
        while (r < this.m_buttons.length) {
            int w = 0;
            int h = 0;
            int colCount = this.m_buttons[r].length;
            if (colCount > 0) {
                int c = 0;
                while (c < colCount) {
                    if (this.m_buttons[r][c] != null) {
                        Dimension d = this.m_sizes[r][c];
                        w += d.width;
                        h = Math.max(h, d.height);
                    }
                    ++c;
                }
            }
            result.width = Math.max(result.width, w);
            result.height += h;
            ++r;
        }
        if (this.m_buttons.length > 0) {
            result.width += Math.max(0, this.m_buttons[0].length - 1) * this.m_hgap;
            result.height += Math.max(0, this.m_buttons.length - 1) * this.m_vgap;
        }
        return result;
    }

    @Override
    protected void validateLayout(Container parent) {
        int rowCount = Math.max(1, this.m_scoutField.getGridRowCount());
        int colCount = Math.max(1, this.m_scoutField.getGridColumnCount());
        this.m_buttons = new Component[rowCount][colCount];
        this.m_sizes = new Dimension[rowCount][colCount];
        int index = 0;
        int i = 0;
        int ni = parent.getComponentCount();
        while (i < ni) {
            if (parent.getComponent(i).isVisible()) {
                Dimension d;
                this.m_buttons[index / colCount][index % colCount] = parent.getComponent(i);
                this.m_sizes[index / colCount][index % colCount] = d = SwingLayoutUtility.getSize(parent.getComponent(i), 0);
                ++index;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.verifyLayout(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            if (!SwingUtility.IS_JAVA_7_OR_GREATER && SwingUtility.DO_RESET_COMPONENT_BOUNDS) {
                SwingUtility.setZeroBounds(parent.getComponents());
            }
            int w = parent.getWidth();
            int h = parent.getHeight();
            int rowCount = this.m_buttons.length;
            int colCount = rowCount > 0 ? this.m_buttons[0].length : 0;
            int hWithoutGaps = h - Math.max(0, rowCount - 1) * this.m_vgap;
            if (colCount > 0) {
                int c;
                int c2;
                int[] widths = new int[colCount];
                int[] minWidths = new int[colCount];
                int[] y = new int[rowCount + 1];
                y[y.length - 1] = h + this.m_vgap;
                int r = 0;
                while (r < rowCount) {
                    c2 = 0;
                    while (c2 < colCount) {
                        if (this.m_sizes[r][c2] != null) {
                            minWidths[c2] = Math.max(minWidths[c2], this.m_sizes[r][c2].width);
                        }
                        ++c2;
                    }
                    y[r] = r * hWithoutGaps / rowCount + r * this.m_vgap;
                    ++r;
                }
                int excess = 0;
                c2 = 0;
                while (c2 < colCount) {
                    int candidateWidth = (c2 + 1) * w / colCount - c2 * w / colCount;
                    if (minWidths[c2] > candidateWidth) {
                        excess += minWidths[c2] - candidateWidth;
                    }
                    widths[c2] = Math.max(candidateWidth, minWidths[c2]);
                    ++c2;
                }
                while (excess > 0) {
                    int shrinkableCount = 0;
                    int gcd = Integer.MAX_VALUE;
                    c = 0;
                    while (c < colCount) {
                        if (widths[c] > minWidths[c]) {
                            ++shrinkableCount;
                            gcd = Math.min(gcd, widths[c] - minWidths[c]);
                        }
                        ++c;
                    }
                    if (shrinkableCount == 0) break;
                    int delta = (Math.min(excess, gcd) + shrinkableCount - 1) / shrinkableCount;
                    int c3 = 0;
                    while (c3 < colCount && excess > 0) {
                        if (widths[c3] > minWidths[c3]) {
                            int n = c3;
                            widths[n] = widths[n] - delta;
                            excess -= delta;
                        }
                        ++c3;
                    }
                }
                int[] x = new int[colCount + 1];
                int i = 0;
                while (i < widths.length) {
                    x[i + 1] = x[i] + widths[i];
                    ++i;
                }
                int r2 = 0;
                while (r2 < rowCount) {
                    c = 0;
                    while (c < colCount) {
                        Rectangle bounds = new Rectangle(x[c], y[r2], x[c + 1] - x[c], y[r2 + 1] - y[r2] - this.m_vgap);
                        if (this.m_buttons[r2][c] != null) {
                            this.m_buttons[r2][c].setBounds(bounds);
                        }
                        ++c;
                    }
                    ++r2;
                }
            }
        }
    }
}

