/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.inject;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;

public class AppendActionsInjector {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AppendActionsInjector.class);

    /*
     * WARNING - void declaration
     */
    public void inject(ISwingEnvironment env, JComponent parent, List<? extends IAction> actions) {
        boolean lastActionWasSeparator = true;
        for (IAction iAction : actions) {
            if (iAction.isSeparator()) {
                if (lastActionWasSeparator || !iAction.isVisible()) continue;
                if (parent instanceof JPopupMenu) {
                    ((JPopupMenu)parent).addSeparator();
                } else if (parent instanceof JMenu) {
                    ((JMenu)parent).addSeparator();
                } else {
                    LOG.warn("invalid container for separator: " + parent);
                }
                lastActionWasSeparator = true;
                continue;
            }
            if (iAction.isVisible()) {
                lastActionWasSeparator = false;
            }
            ISwingScoutAction menuComposite = env.createAction(parent, iAction);
            JComponent child = menuComposite.getSwingField();
            parent.add(child);
            if (!(iAction instanceof IActionNode) || !((IActionNode)iAction).hasChildActions()) continue;
            this.inject(env, child, ((IActionNode)iAction).getChildActions());
        }
        if (parent instanceof JPopupMenu || parent instanceof JMenu) {
            void var5_11;
            Object var5_8 = null;
            if (parent instanceof JPopupMenu) {
                Component[] componentArray = ((JPopupMenu)parent).getComponents();
            } else if (parent instanceof JMenu) {
                Component[] componentArray = ((JMenu)parent).getMenuComponents();
            }
            if (var5_11 != null) {
                int i = ((void)var5_11).length - 1;
                while (i >= 0) {
                    if (var5_11[i] instanceof JPopupMenu.Separator || var5_11[i] instanceof JToolBar.Separator) {
                        parent.remove((Component)var5_11[i]);
                    } else if (!(var5_11[i] instanceof JMenuItem) || ((JMenuItem)var5_11[i]).isVisible()) break;
                    --i;
                }
            }
        }
    }
}

