/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.frame;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.ComponentSpyAction;
import org.eclipse.scout.rt.ui.swing.ext.JFrameEx;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.window.DependentCloseListener;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutBoundsProvider;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;

public class SwingScoutFrame
implements ISwingScoutView {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutFrame.class);
    private ISwingEnvironment m_env;
    private EventListenerList m_listenerList;
    private JFrameEx m_swingFrame;
    private boolean m_maximized;
    private boolean m_opened;
    private ISwingScoutBoundsProvider m_boundsProvider;

    public SwingScoutFrame(ISwingEnvironment env) {
        this(env, null);
    }

    public SwingScoutFrame(ISwingEnvironment env, ISwingScoutBoundsProvider boundsProvider) {
        this.m_env = env;
        this.m_boundsProvider = boundsProvider;
        this.m_listenerList = new EventListenerList();
        this.m_swingFrame = new JFrameEx();
        this.m_swingFrame.getRootPane().putClientProperty("SwingBusyIndicator.busySupported", true);
        JComponent contentPane = (JComponent)this.m_swingFrame.getContentPane();
        contentPane.setLayout(new BorderLayoutEx());
        contentPane.setCursor(Cursor.getDefaultCursor());
        this.m_swingFrame.setResizable(true);
        this.m_swingFrame.setDefaultCloseOperation(0);
        this.m_swingFrame.addWindowListener(new P_SwingWindowListener());
        SwingUtility.installFocusCycleRoot(this.m_swingFrame, new SwingScoutFocusTraversalPolicy());
        this.m_swingFrame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == null) {
                            SwingScoutFrame.this.m_swingFrame.getContentPane().transferFocus();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        SwingUtility.installDevelopmentShortcuts((JComponent)this.m_swingFrame.getContentPane());
        this.m_swingFrame.pack();
        if (contentPane instanceof JComponent) {
            contentPane.getInputMap(1).put(SwingUtility.createKeystroke("shift alt F1"), "componentSpy");
            contentPane.getActionMap().put("componentSpy", new ComponentSpyAction());
        }
    }

    @Override
    public JComponent getSwingContentPane() {
        return (JComponent)this.m_swingFrame.getContentPane();
    }

    @Override
    public void addSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.add(SwingScoutViewListener.class, (EventListener)listener);
    }

    @Override
    public void removeSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.remove(SwingScoutViewListener.class, (EventListener)listener);
    }

    private void fireSwingScoutViewEvent(SwingScoutViewEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(SwingScoutViewListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((SwingScoutViewListener)listeners[i]).viewChanged(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_swingFrame != null && this.m_swingFrame.isVisible();
    }

    @Override
    public boolean isActive() {
        return this.m_swingFrame != null && this.m_swingFrame.isActive();
    }

    public void setBoundsProvider(ISwingScoutBoundsProvider boundsProvider) {
        this.m_boundsProvider = boundsProvider;
    }

    @Override
    public void openView() {
        Rectangle a;
        Rectangle b;
        Rectangle c;
        this.m_opened = true;
        this.m_swingFrame.pack();
        this.m_swingFrame.pack();
        this.m_swingFrame.setLocationRelativeTo(this.m_env.getRootFrame());
        if (this.m_boundsProvider != null && (c = this.m_boundsProvider.getBounds()) != null) {
            if (c.width == 0 || c.height == 0) {
                c.width = this.m_swingFrame.getWidth();
                c.height = this.m_swingFrame.getHeight();
            }
            this.m_swingFrame.setBounds(c);
        }
        if (!(b = SwingUtility.validateRectangleOnScreen(a = this.m_swingFrame.getBounds(), false, true)).equals(a)) {
            this.m_swingFrame.setLocation(b.getLocation());
            this.m_swingFrame.setSize(b.getSize());
        }
        if (this.m_maximized) {
            this.setMaximized(this.m_maximized);
        }
        if (this.m_opened) {
            this.m_swingFrame.setVisible(true);
        }
    }

    @Override
    public void closeView() {
        this.m_opened = false;
        if (this.m_boundsProvider != null) {
            this.m_boundsProvider.storeBounds(this.m_swingFrame.getBounds());
        }
        new DependentCloseListener(this.m_swingFrame).close();
    }

    @Override
    public void setTitle(String s) {
        if (s == null) {
            s = "";
        }
        this.m_swingFrame.setTitle(s);
    }

    @Override
    public void setCloseEnabled(boolean b) {
    }

    @Override
    public void setMaximizeEnabled(boolean b) {
    }

    @Override
    public void setMinimizeEnabled(boolean b) {
    }

    @Override
    public void setMinimized(boolean on) {
        if (on) {
            int state = this.m_swingFrame.getExtendedState() & 0xFFFFFFF9 | 1;
            this.m_swingFrame.setExtendedState(state);
        } else {
            this.m_swingFrame.setExtendedState(this.m_swingFrame.getExtendedState() & 0xFFFFFFFE);
        }
    }

    @Override
    public void setMaximized(boolean on) {
        this.m_maximized = on;
        if (on) {
            int state = this.m_swingFrame.getExtendedState() & 0xFFFFFFFE | 6;
            this.m_swingFrame.setExtendedState(state);
        } else {
            this.m_swingFrame.setExtendedState(this.m_swingFrame.getExtendedState() & 0xFFFFFFF9);
        }
    }

    @Override
    public void setName(String name) {
        this.m_swingFrame.getRootPane().setName(name);
    }

    private class P_SwingWindowListener
    extends WindowAdapter {
        private P_SwingWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            SwingScoutFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutFrame.this, 10));
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SwingScoutFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutFrame.this, 20));
        }

        @Override
        public void windowClosing(WindowEvent e) {
            boolean ok;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null && !(ok = ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner))) {
                return;
            }
            SwingScoutFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutFrame.this, 30));
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (SwingUtility.VERIFY_INPUT_ON_WINDOW_CLOSED && focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null) {
                ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner);
            }
            SwingScoutFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutFrame.this, 40));
        }
    }
}

