/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.table.SwtScoutTable;
import org.eclipse.scout.rt.ui.swt.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class SwtScoutTableModel
implements IStructuredContentProvider,
ITableColorProvider,
ITableLabelProvider,
ITableFontProvider {
    private transient ListenerList listenerList = null;
    private final ITable m_table;
    private final ISwtEnvironment m_environment;
    private final SwtScoutTable m_swtTable;
    private final TableColumnManager m_columnManager;
    private final Color m_disabledForegroundColor;

    public SwtScoutTableModel(ITable table, SwtScoutTable swtTable, ISwtEnvironment environment, TableColumnManager columnManager) {
        this.m_table = table;
        this.m_swtTable = swtTable;
        this.m_environment = environment;
        this.m_columnManager = columnManager;
        this.m_disabledForegroundColor = this.m_environment.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
    }

    public boolean isMultiline() {
        if (this.m_table != null) {
            return this.m_table.isMultilineText();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_table != null) {
            return this.m_table.getFilteredRows();
        }
        return new Object[0];
    }

    public Color getBackground(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_environment.getColor(cell.getBackgroundColor());
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex > 0) {
            ITableRow scoutRow = (ITableRow)element;
            ICell scoutCell = this.getCell(element, columnIndex);
            if (scoutCell == null) {
                return null;
            }
            Color col = this.m_environment.getColor(scoutCell.getForegroundColor());
            if (!(col != null || scoutRow.isEnabled() && scoutCell.isEnabled())) {
                col = this.m_disabledForegroundColor;
            }
            return col;
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        int[] columnOrder = this.m_swtTable.getSwtField().getColumnOrder();
        if (columnOrder.length > 1) {
            String iconId = null;
            ICell cell = this.getCell(element, columnIndex);
            IColumn<?> col = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
            if (columnOrder[1] == columnIndex && this.m_swtTable.getScoutObject() != null && ((ITable)this.m_swtTable.getScoutObject()).isCheckable()) {
                iconId = ((ITableRow)element).isChecked() ? "checkbox_yes" : "checkbox_no";
            } else if (!(col == null || cell == null || col.getDataType() != Boolean.class || col instanceof ISmartColumn && ((ISmartColumn)col).getLookupCall() != null)) {
                Boolean b = (Boolean)cell.getValue();
                iconId = b != null && b.booleanValue() ? "checkbox_yes" : "checkbox_no";
            } else if (cell != null && cell.getErrorStatus() != null && cell.getErrorStatus().getSeverity() == 4) {
                iconId = "status_error";
            } else if (cell != null && cell.getIconId() != null) {
                iconId = cell.getIconId();
            } else if (columnOrder[1] == columnIndex) {
                ITableRow row = (ITableRow)element;
                iconId = row.getIconId();
            }
            return this.m_environment.getIcon(iconId);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex > 0) {
            ICell cell = this.getCell(element, columnIndex);
            if (cell == null) {
                return "";
            }
            String text = cell.getText();
            if (!this.isMultiline()) {
                text = StringUtility.removeNewLines((String)text);
            }
            return text;
        }
        return "";
    }

    public Font getFont(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_environment.getFont(cell.getFont(), this.m_swtTable.getSwtField().getFont());
        }
        return null;
    }

    protected ICell getCell(Object row, int colIndex) {
        IColumn<?> column = this.m_columnManager.getColumnByModelIndex(colIndex - 1);
        if (column != null) {
            return this.m_table.getCell((ITableRow)row, column);
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    private Object[] getListeners() {
        ListenerList list = this.listenerList;
        if (list == null) {
            return new Object[0];
        }
        return list.getListeners();
    }

    public void dispose() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public SwtScoutTable getSwtScoutTable() {
        return this.m_swtTable;
    }
}

