/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields;

import java.util.ArrayList;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.OnFieldLabelDecorator;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtLayoutUtility;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class SwtScoutFieldComposite<T extends IFormField>
extends SwtScoutComposite<T>
implements ISwtScoutFormField<T> {
    protected static final String CLIENT_PROP_INITIAL_LABEL_FONT = "scoutInitialLabelFont";
    protected static final String CLIENT_PROP_INITIAL_LABEL_BACKGROUND = "scoutInitialLabelBackground";
    protected static final String CLIENT_PROP_INITIAL_LABEL_FOREGROUND = "scoutInitialLabelForeground";
    private ILabelComposite m_swtLabel;
    private ISwtKeyStroke[] m_keyStrokes;
    private Color m_mandatoryFieldBackgroundColor;
    private OnFieldLabelDecorator m_onFieldLabelDecorator;

    @Override
    public ILabelComposite getSwtLabel() {
        return this.m_swtLabel;
    }

    protected void setSwtLabel(ILabelComposite label) {
        this.m_swtLabel = label;
        if (this.m_swtLabel != null && label.getLayoutData() == null) {
            LogicalGridData statusLabelGridData = null;
            statusLabelGridData = ((IFormField)this.getScoutObject()).getLabelPosition() == 4 ? LogicalGridDataBuilder.createLabelOnTop(((IFormField)this.getScoutObject()).getGridData()) : LogicalGridDataBuilder.createLabel(((IFormField)this.getScoutObject()).getGridData());
            this.m_swtLabel.setLayoutData(statusLabelGridData);
        }
    }

    public Color getMandatoryFieldBackgroundColor() {
        return this.m_mandatoryFieldBackgroundColor;
    }

    protected void setErrorStatusFromScout(IProcessingStatus s) {
        if (this.getSwtLabel() != null) {
            this.getSwtLabel().setStatus(s);
            this.getSwtContainer().layout(true, true);
        }
    }

    public void setMandatoryFieldBackgroundColor(Color mandatoryFieldBackgroundColor) {
        this.m_mandatoryFieldBackgroundColor = mandatoryFieldBackgroundColor;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() != null) {
            this.setBackgroundFromScout(((IFormField)this.getScoutObject()).getBackgroundColor());
            this.setForegroundFromScout(((IFormField)this.getScoutObject()).getForegroundColor());
            this.setLabelBackgroundFromScout(((IFormField)this.getScoutObject()).getLabelBackgroundColor());
            this.setLabelForegroundFromScout(((IFormField)this.getScoutObject()).getLabelForegroundColor());
            this.setVisibleFromScout(((IFormField)this.getScoutObject()).isVisible());
            this.setEnabledFromScout(((IFormField)this.getScoutObject()).isEnabled());
            this.setMandatoryFromScout(((IFormField)this.getScoutObject()).isMandatory());
            this.setErrorStatusFromScout(((IFormField)this.getScoutObject()).getErrorStatus());
            this.setLabelFromScout(((IFormField)this.getScoutObject()).getLabel());
            this.setLabelVisibleFromScout();
            this.setLabelPositionFromScout();
            this.setLabelWidthInPixelFromScout();
            this.setLabelHorizontalAlignmentFromScout();
            this.setTooltipTextFromScout(((IFormField)this.getScoutObject()).getTooltipText());
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2 && ((IFormField)this.getScoutObject()).getLabel() != null && ((IFormField)this.getScoutObject()).getTooltipText() == null) {
                this.setTooltipTextFromScout(((IFormField)this.getScoutObject()).getLabel());
            }
            this.setFontFromScout(((IFormField)this.getScoutObject()).getFont());
            this.setLabelFontFromScout(((IFormField)this.getScoutObject()).getLabelFont());
            this.setSaveNeededFromScout(((IFormField)this.getScoutObject()).isSaveNeeded());
            this.setFocusableFromScout(((IFormField)this.getScoutObject()).isFocusable());
            this.updateKeyStrokesFromScout();
        }
    }

    protected void setVisibleFromScout(boolean b) {
        boolean updateLayout = false;
        if (this.getSwtContainer() != null && this.getSwtContainer().getVisible() != b) {
            updateLayout = true;
            this.getSwtContainer().setVisible(b);
        } else if (this.getSwtField() != null && this.getSwtField().getVisible() != b) {
            updateLayout = true;
            this.getSwtField().setVisible(b);
        }
        if (updateLayout && this.isConnectedToScout()) {
            if (b) {
                Point size = this.getSwtContainer().getSize();
                if (size.x == 0 && size.y == 0) {
                    this.getSwtContainer().setSize(100, 100);
                }
            }
            SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
        }
    }

    protected void setEnabledFromScout(boolean b) {
        boolean updateLayout = false;
        Control swtField = this.getSwtField();
        if (swtField != null) {
            updateLayout = true;
            this.setFieldEnabled(swtField, b);
            if (b) {
                this.setForegroundFromScout(((IFormField)this.getScoutObject()).getForegroundColor());
            } else {
                this.setForegroundFromScout(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
            }
        }
        if (this.getSwtLabel() != null && this.getSwtLabel().getEnabled() != b) {
            updateLayout = true;
            this.getSwtLabel().setEnabled(b);
        }
        if (updateLayout && this.isConnectedToScout()) {
            SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
        }
    }

    protected void setFieldEnabled(Control swtField, boolean enabled) {
        swtField.setEnabled(enabled);
    }

    protected void setMandatoryFromScout(boolean b) {
        String fieldBackgroundColorString = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryFieldBackgroundColor();
        if (fieldBackgroundColorString != null) {
            Color color = null;
            color = b ? this.getEnvironment().getColor(fieldBackgroundColorString) : null;
            if (this.getMandatoryFieldBackgroundColor() != color) {
                this.setMandatoryFieldBackgroundColor(color);
                this.setBackgroundFromScout(((IFormField)this.getScoutObject()).getBackgroundColor());
            }
        }
        if (this.getSwtLabel() != null && this.getSwtLabel().setMandadatory(b) && this.isConnectedToScout()) {
            SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
        }
    }

    protected void setLabelPositionFromScout() {
        if (this.getSwtField() != null) {
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
                if (this.m_onFieldLabelDecorator == null) {
                    this.m_onFieldLabelDecorator = new OnFieldLabelDecorator(this.getEnvironment(), ((IFormField)this.getScoutObject()).isMandatory());
                    this.m_onFieldLabelDecorator.setText(((IFormField)this.getScoutObject()).getLabel());
                }
                this.m_onFieldLabelDecorator.attach(this.getSwtField());
            } else if (this.m_onFieldLabelDecorator != null) {
                this.m_onFieldLabelDecorator.detach(this.getSwtField());
            }
            this.getSwtField().redraw();
        }
        this.setLabelVisibleFromScout();
        this.setLabelFromScout(((IFormField)this.getScoutObject()).getLabel());
    }

    protected void setLabelWidthInPixelFromScout() {
        if (this.getSwtLabel() != null) {
            int w = ((IFormField)this.getScoutObject()).getLabelWidthInPixel();
            if (w > 0) {
                this.getSwtLabel().setLayoutWidthHint(w);
            } else if (w == 0) {
                this.getSwtLabel().setLayoutWidthHint(UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelWidth());
            } else if (w == -1) {
                this.getSwtLabel().setLayoutWidthHint(0);
            }
        }
    }

    protected void setLabelHorizontalAlignmentFromScout() {
    }

    protected void setLabelFromScout(String s) {
        if (this.m_swtLabel != null && s != null) {
            this.m_swtLabel.setText(s);
        }
        if (this.m_onFieldLabelDecorator != null) {
            this.m_onFieldLabelDecorator.setText(s);
        }
    }

    protected void setLabelVisibleFromScout() {
        boolean b;
        boolean bl = b = ((IFormField)this.getScoutObject()).isLabelVisible() && ((IFormField)this.getScoutObject()).getLabelPosition() != 2;
        if (this.m_swtLabel != null && b != this.m_swtLabel.getVisible()) {
            this.m_swtLabel.setVisible(b);
            if (this.getSwtContainer() != null && this.isConnectedToScout()) {
                this.getSwtContainer().layout(true, true);
            }
        }
    }

    protected void setTooltipTextFromScout(String s) {
        if (this.getSwtField() != null) {
            this.getSwtField().setToolTipText(s);
        }
    }

    protected void setBackgroundFromScout(String scoutColor, Control field) {
        if (field == null) {
            return;
        }
        Control fld = field;
        if (fld.getData("scoutInitialBackground") == null) {
            fld.setData("scoutInitialBackground", (Object)fld.getBackground());
        }
        Color initCol = (Color)fld.getData("scoutInitialBackground");
        Color c = this.getEnvironment().getColor(scoutColor);
        if (this.getMandatoryFieldBackgroundColor() != null) {
            c = this.getMandatoryFieldBackgroundColor();
        }
        if (c == null) {
            c = initCol;
        }
        fld.setBackground(c);
    }

    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, this.getSwtField());
    }

    protected void setForegroundFromScout(String scoutColor) {
        if (this.getSwtField() != null) {
            Control fld = this.getSwtField();
            if (fld.getData("scoutInitialForeground") == null) {
                fld.setData("scoutInitialForeground", (Object)fld.getForeground());
            }
            Color initCol = (Color)fld.getData("scoutInitialForeground");
            Color c = this.getEnvironment().getColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            fld.setForeground(c);
        }
    }

    protected void setFontFromScout(FontSpec scoutFont) {
        if (this.getSwtField() != null) {
            Control fld = this.getSwtField();
            Font currentFont = fld.getFont();
            if (fld.getData("scoutInitialFont") == null) {
                fld.setData("scoutInitialFont", (Object)currentFont);
            }
            Font initFont = (Font)fld.getData("scoutInitialFont");
            Font f = this.getEnvironment().getFont(scoutFont, initFont);
            if (f == null) {
                f = initFont;
            }
            if (currentFont == null || !currentFont.equals((Object)f)) {
                fld.setFont(f);
            }
        }
        if (this.isConnectedToScout()) {
            SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
        }
    }

    protected void setLabelBackgroundFromScout(String scoutColor) {
        if (this.getSwtLabel() != null) {
            ILabelComposite fld = this.getSwtLabel();
            if (fld.getData(CLIENT_PROP_INITIAL_LABEL_BACKGROUND) == null) {
                fld.setData(CLIENT_PROP_INITIAL_LABEL_BACKGROUND, fld.getBackground());
            }
            Color initCol = (Color)fld.getData(CLIENT_PROP_INITIAL_LABEL_BACKGROUND);
            Color c = this.getEnvironment().getColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            fld.setBackground(c);
        }
    }

    protected void setLabelForegroundFromScout(String scoutColor) {
        if (this.getSwtLabel() != null) {
            ILabelComposite fld = this.getSwtLabel();
            if (fld.getData(CLIENT_PROP_INITIAL_LABEL_FOREGROUND) == null) {
                fld.setData(CLIENT_PROP_INITIAL_LABEL_FOREGROUND, fld.getForeground());
            }
            Color initCol = (Color)fld.getData(CLIENT_PROP_INITIAL_LABEL_FOREGROUND);
            Color c = this.getEnvironment().getColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            fld.setForeground(c);
        }
    }

    protected void setLabelFontFromScout(FontSpec scoutFont) {
        if (this.getSwtLabel() != null) {
            ILabelComposite fld = this.getSwtLabel();
            Font currentFont = fld.getFont();
            if (fld.getData(CLIENT_PROP_INITIAL_LABEL_FONT) == null) {
                fld.setData(CLIENT_PROP_INITIAL_LABEL_FONT, currentFont);
            }
            Font initFont = (Font)fld.getData(CLIENT_PROP_INITIAL_LABEL_FONT);
            Font f = this.getEnvironment().getFont(scoutFont, initFont);
            if (f == null) {
                f = initFont;
            }
            if (currentFont == null || !currentFont.equals((Object)f)) {
                fld.setFont(f);
            }
        }
        if (this.isConnectedToScout()) {
            SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
        }
    }

    protected void setSaveNeededFromScout(boolean b) {
    }

    protected void setFocusableFromScout(boolean b) {
    }

    protected void updateEmptyFromScout() {
    }

    protected void updateKeyStrokesFromScout() {
        Composite widget = this.getSwtContainer();
        if (widget == null) {
            widget = this.getSwtField();
        }
        if (widget != null) {
            IKeyStroke[] scoutKeyStrokes;
            if (this.m_keyStrokes != null) {
                ISwtKeyStroke[] iSwtKeyStrokeArray = this.m_keyStrokes;
                int n = this.m_keyStrokes.length;
                int n2 = 0;
                while (n2 < n) {
                    ISwtKeyStroke swtKeyStroke = iSwtKeyStrokeArray[n2];
                    this.getEnvironment().removeKeyStroke((Widget)this.getSwtContainer(), swtKeyStroke);
                    ++n2;
                }
            }
            ArrayList<ISwtKeyStroke> newSwtKeyStrokes = new ArrayList<ISwtKeyStroke>();
            IKeyStroke[] iKeyStrokeArray = scoutKeyStrokes = ((IFormField)this.getScoutObject()).getKeyStrokes();
            int n = scoutKeyStrokes.length;
            int n3 = 0;
            while (n3 < n) {
                ISwtKeyStroke[] swtStrokes;
                IKeyStroke scoutKeyStroke = iKeyStrokeArray[n3];
                ISwtKeyStroke[] iSwtKeyStrokeArray = swtStrokes = SwtUtility.getKeyStrokes(scoutKeyStroke, this.getEnvironment());
                int n4 = swtStrokes.length;
                int n5 = 0;
                while (n5 < n4) {
                    ISwtKeyStroke swtStroke = iSwtKeyStrokeArray[n5];
                    this.getEnvironment().addKeyStroke((Widget)this.getSwtContainer(), swtStroke);
                    newSwtKeyStrokes.add(swtStroke);
                    ++n5;
                }
                ++n3;
            }
            this.m_keyStrokes = newSwtKeyStrokes.toArray(new ISwtKeyStroke[newSwtKeyStrokes.size()]);
        }
    }

    @Override
    protected boolean isHandleScoutPropertyChange(final String name, final Object newValue) {
        if (name.equals("enabled") || name.equals("visible")) {
            this.getEnvironment().postImmediateSwtJob(new Runnable(){

                @Override
                public void run() {
                    SwtScoutFieldComposite.this.handleScoutPropertyChange(name, newValue);
                }
            });
        }
        return super.isHandleScoutPropertyChange(name, newValue);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("focusable")) {
            this.setFocusableFromScout((Boolean)newValue);
        } else if (name.equals("label")) {
            this.setLabelFromScout((String)newValue);
        } else if (name.equals("labelVisible")) {
            this.setLabelVisibleFromScout();
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("visible")) {
            this.setVisibleFromScout((Boolean)newValue);
        } else if (name.equals("mandatory")) {
            this.setMandatoryFromScout((Boolean)newValue);
        } else if (name.equals("errorStatus")) {
            this.setErrorStatusFromScout((IProcessingStatus)newValue);
        } else if (name.equals("foregroundColor")) {
            this.setForegroundFromScout((String)newValue);
        } else if (name.equals("backgroundColor")) {
            this.setBackgroundFromScout((String)newValue);
        } else if (name.equals("font")) {
            this.setFontFromScout((FontSpec)newValue);
        } else if (name.equals("saveNeeded")) {
            this.setSaveNeededFromScout((Boolean)newValue);
        } else if (name.equals("empty")) {
            this.updateEmptyFromScout();
        } else if (name.equals("keyStrokes")) {
            this.updateKeyStrokesFromScout();
        }
    }
}

