/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.decimalfield;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalField;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.decimalfield.ISwtScoutDecimalField;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SwtScoutDecimalField
extends SwtScoutValueFieldComposite<IDecimalField<?>>
implements ISwtScoutDecimalField {
    private TextFieldEditableSupport m_editableSupport;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        int style = 2048;
        style |= SwtUtility.getVerticalAlignment(((IDecimalField)this.getScoutObject()).getGridData().verticalAlignment);
        Text text = this.getEnvironment().getFormToolkit().createText(container, style |= SwtUtility.getHorizontalAlignment(((IDecimalField)this.getScoutObject()).getGridData().horizontalAlignment));
        text.setTextLimit(32);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)text);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    @Override
    public Text getSwtField() {
        return (Text)super.getSwtField();
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IDecimalField)this.getScoutObject()).getDisplayText()) && ((IDecimalField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDecimalField)SwtScoutDecimalField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        this.getSwtField().setSelection(0, this.getSwtField().getText().length());
    }

    @Override
    protected void handleSwtFocusLost() {
        this.getSwtField().setSelection(0, 0);
    }
}

