/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.filechooserfield;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.scout.rt.ui.swt.ext.DropDownButton;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.filechooserfield.ISwtScoutFileChooserField;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SwtScoutFileChooserField
extends SwtScoutValueFieldComposite<IFileChooserField>
implements ISwtScoutFileChooserField {
    private DropDownButton m_fileChooserButton;
    private Menu m_contextMenu;
    private TextFieldEditableSupport m_editableSupport;

    @Override
    protected void initializeSwt(Composite parent) {
        super.initializeSwt(parent);
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText(container, 2052);
        this.m_fileChooserButton = new DropDownButton(container, 4);
        this.m_fileChooserButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SwtScoutFileChooserField.this.getSwtField().setFocus();
            }
        });
        container.setTabList(new Control[]{textField});
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)textField);
        this.m_contextMenu = new Menu((Decorations)this.m_fileChooserButton.getShell(), 8);
        this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        this.m_fileChooserButton.setMenu(this.m_contextMenu);
        P_SwtFileChooserButtonListener swtBrowseButtonListener = new P_SwtFileChooserButtonListener();
        this.getSwtFileChooserButton().addSelectionListener((SelectionListener)swtBrowseButtonListener);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_fileChooserButton.setLayoutData(LogicalGridDataBuilder.createSmartButton());
    }

    @Override
    public DropDownButton getSwtFileChooserButton() {
        return this.m_fileChooserButton;
    }

    @Override
    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setFileIconIdFromScout(((IFileChooserField)this.getScoutObject()).getFileIconId());
        this.getSwtFileChooserButton().setDropdownEnabled(((IFileChooserField)this.getScoutObject()).hasMenus());
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
        super.handleSwtFocusGained();
        this.getSwtField().setCaretOffset(0);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_fileChooserButton.setEnabled(b);
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    protected void setFileIconIdFromScout(String s) {
        this.m_fileChooserButton.setImage(this.getEnvironment().getIcon(s));
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IFileChooserField)this.getScoutObject()).getDisplayText()) && ((IFileChooserField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IFileChooserField)SwtScoutFileChooserField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        this.scheduleSelectAll();
    }

    @Override
    protected void handleSwtFocusLost() {
        this.getSwtField().setSelection(0, 0);
    }

    protected void scheduleSelectAll() {
        this.getEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SwtScoutFileChooserField.this.getSwtField().isDisposed()) {
                    return;
                }
                SwtScoutFileChooserField.this.getSwtField().setSelection(0, SwtScoutFileChooserField.this.getSwtField().getText().length());
            }
        });
    }

    protected void handleSwtFileChooserAction() {
        if (((IFileChooserField)this.getScoutObject()).isVisible() && ((IFileChooserField)this.getScoutObject()).isEnabled()) {
            Runnable scoutJob = new Runnable(){

                @Override
                public void run() {
                    IFileChooser fc = ((IFileChooserField)SwtScoutFileChooserField.this.getScoutObject()).getFileChooser();
                    final File[] files = fc.startChooser();
                    Runnable swtJob = new Runnable(){

                        @Override
                        public void run() {
                            if (files != null && files.length > 0) {
                                SwtScoutFileChooserField.this.getSwtField().setText(files[0].getAbsolutePath());
                                SwtScoutFileChooserField.this.handleSwtInputVerifier();
                            }
                        }
                    };
                    if (SwtScoutFileChooserField.this.getEnvironment() != null) {
                        SwtScoutFileChooserField.this.getEnvironment().invokeSwtLater(swtJob);
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(scoutJob, 0L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("fileIconId")) {
            this.setFileIconIdFromScout((String)newValue);
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapter {
        private P_ContextMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            MenuItem[] menuItemArray = SwtScoutFileChooserField.this.m_contextMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                this.disposeMenuItem(item);
                ++n2;
            }
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((IFileChooserField)SwtScoutFileChooserField.this.getScoutObject()).getUIFacade().firePopupFromUI();
                    scoutMenusRef.set(scoutMenus);
                }
            };
            JobEx job = SwtScoutFileChooserField.this.getEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (scoutMenusRef.get() != null) {
                SwtMenuUtility.fillContextMenu((IMenu[])scoutMenusRef.get(), SwtScoutFileChooserField.this.m_contextMenu, SwtScoutFileChooserField.this.getEnvironment());
            }
        }

        private void disposeMenuItem(MenuItem item) {
            Menu menu = item.getMenu();
            if (menu != null) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem childItem = menuItemArray[n2];
                    this.disposeMenuItem(childItem);
                    ++n2;
                }
                menu.dispose();
            }
            item.dispose();
        }
    }

    private class P_SwtFileChooserButtonListener
    extends SelectionAdapter {
        private P_SwtFileChooserButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SwtScoutFileChooserField.this.handleSwtFileChooserAction();
        }
    }
}

