/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.htmlfield;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.htmlfield.ISwtScoutHtmlField;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutHtmlField
extends SwtScoutValueFieldComposite<IHtmlField>
implements ISwtScoutHtmlField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutHtmlField.class);
    private File m_tempDir;
    private String m_anchorName;

    public SwtScoutHtmlField() {
        try {
            File tempFile = File.createTempFile("scoutHtmlField", "");
            tempFile.delete();
            tempFile.mkdir();
            tempFile.deleteOnExit();
            this.m_tempDir = tempFile;
        }
        catch (IOException e) {
            LOG.warn("could not create temp dir");
        }
    }

    private void deleteCache(File file) {
        IOUtility.deleteDirectory((File)file);
    }

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        Browser browser = this.getEnvironment().getFormToolkit().createBrowser(container, 0);
        browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SwtScoutHtmlField.this.m_tempDir != null) {
                    SwtScoutHtmlField.this.deleteCache(SwtScoutHtmlField.this.m_tempDir);
                }
            }
        });
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                URL url = null;
                try {
                    url = new URL(event.location);
                }
                catch (MalformedURLException e) {
                    try {
                        url = new File(event.location).toURI().toURL();
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
                if (url != null) {
                    event.doit = url.getProtocol().equals("file");
                    if (!event.doit) {
                        SwtScoutHtmlField.this.handleSwtLinkAction(url);
                    }
                }
            }
        });
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)browser);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    public Browser getSwtField() {
        return (Browser)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
    }

    protected void handleSwtLinkAction(final URL location) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                ((IHtmlField)SwtScoutHtmlField.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(location);
            }
        };
        this.getEnvironment().invokeScoutLater(job, 0L);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    @Override
    protected void setDisplayTextFromScout(String rawHtml) {
        String styledHtml;
        RemoteFile[] a = ((IHtmlField)this.getScoutObject()).getAttachments();
        if (a != null) {
            RemoteFile[] remoteFileArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteFile f = remoteFileArray[n2];
                if (f != null && f.exists()) {
                    try {
                        this.writeTempFile(f.getPath(), new ByteArrayInputStream(f.extractData()));
                    }
                    catch (IOException e1) {
                        LOG.warn("could not read remote file '" + f.getName() + "'", (Throwable)e1);
                    }
                }
                ++n2;
            }
        }
        if (StringUtility.isNullOrEmpty((String)(styledHtml = this.getEnvironment().styleHtmlText(this, rawHtml)))) {
            this.getSwtField().setText("");
        } else {
            try {
                File indexFile = this.writeTempFile("index.html", new ByteArrayInputStream(styledHtml.getBytes("UTF-8")));
                File html = new File(String.valueOf(this.m_tempDir.getAbsolutePath()) + "/index.html");
                html.createNewFile();
                this.getSwtField().setUrl(indexFile.toURI().toURL().toExternalForm());
            }
            catch (IOException e) {
                LOG.error("could not create index file for html: '" + styledHtml + "'", (Throwable)e);
            }
        }
    }

    private File writeTempFile(String relFullName, InputStream content) {
        if ((relFullName = relFullName.replaceAll("\\\\", "/")) == null || relFullName.length() == 0) {
            return null;
        }
        if (!relFullName.startsWith("/")) {
            relFullName = "/" + relFullName;
        }
        File ioF = new File(this.m_tempDir.getAbsolutePath(), relFullName);
        ioF.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int bytesRead;
            out = new FileOutputStream(ioF);
            byte[] buffer = new byte[1026];
            while ((bytesRead = content.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            ioF.deleteOnExit();
            File file = ioF;
            return file;
        }
        catch (IOException e) {
            LOG.error("could not create file in temp dir: '" + relFullName + "'", (Throwable)e);
            return null;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void setScrollToAnchorFromScout(String anchorName) {
        if (!StringUtility.isNullOrEmpty((String)anchorName)) {
            String url = this.getSwtField().getUrl();
            if (!StringUtility.isNullOrEmpty((String)url)) {
                String baseUrl = url.replace("#" + this.m_anchorName, "");
                this.getSwtField().setUrl(String.valueOf(baseUrl) + "#" + anchorName);
                this.getSwtField().refresh();
            }
            this.m_anchorName = anchorName;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("scrollToEnd")) {
            this.getSwtField().execute("window.scrollTo(0, document.body.scrollHeight)");
        } else if (name.equals("scrollToPosition")) {
            this.setScrollToAnchorFromScout((String)TypeCastUtility.castValue((Object)newValue, String.class));
        }
    }
}

