/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.keystroke;

import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.swt.widgets.Event;

public class SwtScoutKeyStroke
extends SwtKeyStroke {
    private final ISwtEnvironment m_environment;
    private final IKeyStroke m_scoutKeyStroke;
    private boolean m_handleActionPending;

    public SwtScoutKeyStroke(IKeyStroke scoutKeyStroke, int keyCode, int stateMask, ISwtEnvironment environment) {
        super(keyCode, stateMask);
        this.m_scoutKeyStroke = scoutKeyStroke;
        this.m_environment = environment;
    }

    @Override
    public void handleSwtAction(Event e) {
        if (this.getScoutKeyStroke().isEnabled() && this.getScoutKeyStroke().isVisible()) {
            if (!this.m_handleActionPending) {
                this.m_handleActionPending = true;
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwtScoutKeyStroke.this.getScoutKeyStroke().getUIFacade().fireActionFromUI();
                        }
                        finally {
                            SwtScoutKeyStroke.this.m_handleActionPending = false;
                        }
                    }
                };
                this.getEnvironment().invokeScoutLater(job, 0L);
            }
            e.doit = false;
        }
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public IKeyStroke getScoutKeyStroke() {
        return this.m_scoutKeyStroke;
    }
}

