/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.dnd.FileListTransferObject;
import org.eclipse.scout.commons.dnd.ImageTransferObject;
import org.eclipse.scout.commons.dnd.JavaTransferObject;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtScoutKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.JVMLocalObjectTransfer;
import org.eclipse.scout.rt.ui.swt.util.SwtTransferObject;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class SwtUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtUtility.class);
    private static final HashMap<String, Integer> SCOUT_SWT_KEY_MAP = new HashMap();
    private static final Pattern MNEMONIC_PATTERN;

    static {
        SCOUT_SWT_KEY_MAP.put("0", 0x1000030);
        SCOUT_SWT_KEY_MAP.put("1", 0x1000031);
        SCOUT_SWT_KEY_MAP.put("2", 16777266);
        SCOUT_SWT_KEY_MAP.put("3", 0x1000033);
        SCOUT_SWT_KEY_MAP.put("4", 16777268);
        SCOUT_SWT_KEY_MAP.put("5", 16777269);
        SCOUT_SWT_KEY_MAP.put("6", 16777270);
        SCOUT_SWT_KEY_MAP.put("7", 16777271);
        SCOUT_SWT_KEY_MAP.put("8", 16777272);
        SCOUT_SWT_KEY_MAP.put("9", 16777273);
        SCOUT_SWT_KEY_MAP.put("enter", 13);
        SCOUT_SWT_KEY_MAP.put("back_space", 8);
        SCOUT_SWT_KEY_MAP.put("tab", 9);
        SCOUT_SWT_KEY_MAP.put("shift", 131072);
        SCOUT_SWT_KEY_MAP.put("ctrl", 262144);
        SCOUT_SWT_KEY_MAP.put("control", 262144);
        SCOUT_SWT_KEY_MAP.put("alt", 65536);
        SCOUT_SWT_KEY_MAP.put("alternate", 65536);
        SCOUT_SWT_KEY_MAP.put("pause", 0x1000055);
        SCOUT_SWT_KEY_MAP.put("caps_lock", 16777298);
        SCOUT_SWT_KEY_MAP.put("escape", 27);
        SCOUT_SWT_KEY_MAP.put("space", 32);
        SCOUT_SWT_KEY_MAP.put("page_up", 0x1000005);
        SCOUT_SWT_KEY_MAP.put("page_down", 0x1000006);
        SCOUT_SWT_KEY_MAP.put("end", 0x1000008);
        SCOUT_SWT_KEY_MAP.put("home", 0x1000007);
        SCOUT_SWT_KEY_MAP.put("left", 0x1000003);
        SCOUT_SWT_KEY_MAP.put("up", 0x1000001);
        SCOUT_SWT_KEY_MAP.put("right", 0x1000004);
        SCOUT_SWT_KEY_MAP.put("down", 0x1000002);
        SCOUT_SWT_KEY_MAP.put("multiply", 16777258);
        SCOUT_SWT_KEY_MAP.put("add", 16777259);
        SCOUT_SWT_KEY_MAP.put("separater", 0x1000050);
        SCOUT_SWT_KEY_MAP.put("subtract", 16777261);
        SCOUT_SWT_KEY_MAP.put("decimal", 16777262);
        SCOUT_SWT_KEY_MAP.put("divide", 16777263);
        SCOUT_SWT_KEY_MAP.put("delete", 127);
        SCOUT_SWT_KEY_MAP.put("num_lock", 16777299);
        SCOUT_SWT_KEY_MAP.put("scroll_lock", 16777300);
        SCOUT_SWT_KEY_MAP.put("f1", 0x100000A);
        SCOUT_SWT_KEY_MAP.put("f2", 0x100000B);
        SCOUT_SWT_KEY_MAP.put("f3", 0x100000C);
        SCOUT_SWT_KEY_MAP.put("f4", 0x100000D);
        SCOUT_SWT_KEY_MAP.put("f5", 0x100000E);
        SCOUT_SWT_KEY_MAP.put("f6", 0x100000F);
        SCOUT_SWT_KEY_MAP.put("f7", 0x1000010);
        SCOUT_SWT_KEY_MAP.put("f8", 0x1000011);
        SCOUT_SWT_KEY_MAP.put("f9", 0x1000012);
        SCOUT_SWT_KEY_MAP.put("f10", 0x1000013);
        SCOUT_SWT_KEY_MAP.put("f11", 0x1000014);
        SCOUT_SWT_KEY_MAP.put("f12", 0x1000015);
        SCOUT_SWT_KEY_MAP.put("f13", 0x1000016);
        SCOUT_SWT_KEY_MAP.put("f14", 0x1000017);
        SCOUT_SWT_KEY_MAP.put("f15", 0x1000018);
        SCOUT_SWT_KEY_MAP.put("printscreen", 16777303);
        SCOUT_SWT_KEY_MAP.put("insert", 0x1000009);
        SCOUT_SWT_KEY_MAP.put("help", 0x1000051);
        SCOUT_SWT_KEY_MAP.put("ampersand", 38);
        SCOUT_SWT_KEY_MAP.put("less", 60);
        SCOUT_SWT_KEY_MAP.put("greater", 62);
        SCOUT_SWT_KEY_MAP.put("at", 64);
        SCOUT_SWT_KEY_MAP.put("colon", 513);
        SCOUT_SWT_KEY_MAP.put("circumflex", 94);
        SCOUT_SWT_KEY_MAP.put("dollar", 36);
        SCOUT_SWT_KEY_MAP.put("euro_sign", 128);
        SCOUT_SWT_KEY_MAP.put("exclamation_mark", 33);
        SCOUT_SWT_KEY_MAP.put("inverted_exclamation_mark", 161);
        SCOUT_SWT_KEY_MAP.put("left_parenthesis", 40);
        SCOUT_SWT_KEY_MAP.put("number_sign", 35);
        SCOUT_SWT_KEY_MAP.put("minus", 45);
        SCOUT_SWT_KEY_MAP.put("plus", 43);
        SCOUT_SWT_KEY_MAP.put("right_parenthesis", 41);
        SCOUT_SWT_KEY_MAP.put("underscore", 95);
        SCOUT_SWT_KEY_MAP.put("undo", 65483);
        MNEMONIC_PATTERN = Pattern.compile("(\\&)", 32);
    }

    private SwtUtility() {
    }

    public static SwtTransferObject[] createSwtTransferables(TransferObject transferObject) {
        ArrayList<SwtTransferObject> swtTranferObjects = new ArrayList<SwtTransferObject>();
        if (transferObject instanceof FileListTransferObject) {
            FileListTransferObject scoutTransferObject = (FileListTransferObject)transferObject;
            swtTranferObjects.add(new SwtTransferObject((Transfer)FileTransfer.getInstance(), scoutTransferObject.getFilenames()));
        } else if (transferObject instanceof TextTransferObject) {
            TextTransferObject scoutTransferObject = (TextTransferObject)transferObject;
            swtTranferObjects.add(new SwtTransferObject((Transfer)TextTransfer.getInstance(), scoutTransferObject.getPlainText()));
            if (StringUtility.hasText((String)scoutTransferObject.getHtmlText())) {
                swtTranferObjects.add(new SwtTransferObject((Transfer)HTMLTransfer.getInstance(), scoutTransferObject.getHtmlText()));
            }
        } else if (transferObject instanceof JavaTransferObject) {
            JavaTransferObject scoutTransferObject = (JavaTransferObject)transferObject;
            swtTranferObjects.add(new SwtTransferObject((Transfer)JVMLocalObjectTransfer.getInstance(), scoutTransferObject.getLocalObject()));
        } else if (transferObject instanceof ImageTransferObject) {
            ImageTransferObject scoutTransferObject = (ImageTransferObject)transferObject;
            Object image = scoutTransferObject.getImage();
            if (image instanceof ImageData) {
                swtTranferObjects.add(new SwtTransferObject((Transfer)ImageTransfer.getInstance(), (ImageData)image));
            } else if (image instanceof byte[]) {
                ByteArrayInputStream imageInput = new ByteArrayInputStream((byte[])image);
                ImageData imageData = new Image(null, (InputStream)imageInput).getImageData();
                swtTranferObjects.add(new SwtTransferObject((Transfer)ImageTransfer.getInstance(), imageData));
            }
        } else {
            LOG.error("unsupported transfer object type: " + transferObject);
        }
        return swtTranferObjects.toArray(new SwtTransferObject[swtTranferObjects.size()]);
    }

    public static TransferObject createScoutTransferable(DropTargetEvent swtT) {
        block15: {
            String transferData;
            if (swtT == null || swtT.currentDataType == null) {
                return null;
            }
            Exception ex = null;
            if (FileTransfer.getInstance().isSupportedType(swtT.currentDataType)) {
                String[] fileNames = (String[])swtT.data;
                ArrayList<File> files = new ArrayList<File>();
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        String fileName = stringArray[n2];
                        try {
                            files.add(new File(fileName));
                        }
                        catch (Exception e) {
                            if (ex != null) break block14;
                            ex = e;
                        }
                    }
                    ++n2;
                }
                return new FileListTransferObject(files);
            }
            if (JVMLocalObjectTransfer.getInstance().isSupportedType(swtT.currentDataType) && !(swtT.data instanceof String)) {
                Object transferData2 = swtT.data;
                if (transferData2 != null) {
                    try {
                        return new JavaTransferObject(transferData2);
                    }
                    catch (Exception e) {
                        if (ex == null) {
                            ex = e;
                        }
                    }
                }
            } else if (TextTransfer.getInstance().isSupportedType(swtT.currentDataType) && (transferData = (String)swtT.data) != null) {
                try {
                    return new TextTransferObject(transferData);
                }
                catch (Exception e) {
                    if (ex != null) break block15;
                    ex = e;
                }
            }
        }
        return null;
    }

    public static Transfer[] convertScoutTransferTypes(int scoutTransferTypes) {
        ArrayList<Object> swtTransferList = new ArrayList<Object>();
        if ((1 & scoutTransferTypes) != 0) {
            swtTransferList.add(FileTransfer.getInstance());
        }
        if ((8 & scoutTransferTypes) != 0) {
            swtTransferList.add(ImageTransfer.getInstance());
        }
        if ((2 & scoutTransferTypes) != 0) {
            swtTransferList.add((Object)JVMLocalObjectTransfer.getInstance());
        }
        if ((4 & scoutTransferTypes) != 0) {
            swtTransferList.add(TextTransfer.getInstance());
        }
        return swtTransferList.toArray(new Transfer[swtTransferList.size()]);
    }

    public static int getHorizontalAlignment(int scoutAlignment) {
        if (scoutAlignment < 0) {
            return 16384;
        }
        if (scoutAlignment == 0) {
            return 0x1000000;
        }
        return 131072;
    }

    public static int getVerticalAlignment(int scoutAlignment) {
        if (scoutAlignment < 0) {
            return 128;
        }
        if (scoutAlignment == 0) {
            return 0;
        }
        return 1024;
    }

    public static Point getLocationOnScreen(Control c) {
        Point p = c.toDisplay(0, 0);
        return p;
    }

    public static boolean isAncestorOf(Control ancestor, Control child) {
        if (ancestor == null || child == null) {
            return false;
        }
        if (ancestor == child) {
            return true;
        }
        return SwtUtility.isAncestorOf(ancestor, (Control)child.getParent());
    }

    public static Rectangle getFullScreenBoundsFor(Display d, Rectangle r, boolean includeReservedInsets) {
        TreeMap<Integer, Rectangle> prioMap = new TreeMap<Integer, Rectangle>();
        Monitor[] monitorArray = d.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor dev = monitorArray[n2];
            Rectangle bounds = !includeReservedInsets ? dev.getClientArea() : dev.getBounds();
            Rectangle intersection = bounds.intersection(r);
            prioMap.put(intersection.width * intersection.height, bounds);
            if (dev == d.getPrimaryMonitor()) {
                prioMap.put(-1, bounds);
            }
            ++n2;
        }
        return (Rectangle)prioMap.get(prioMap.lastKey());
    }

    public static Rectangle validateRectangleOnScreen(Display d, Rectangle r, boolean includeReservedInsets, boolean singleMonitor) {
        Rectangle t = SwtUtility.intersectRectangleWithScreen(d, r, includeReservedInsets, singleMonitor);
        if (!t.equals((Object)r)) {
            Rectangle a = r;
            Rectangle screen = SwtUtility.intersectRectangleWithScreen(d, new Rectangle(-100000, -100000, 200000, 200000), includeReservedInsets, singleMonitor);
            if (screen.width < a.width) {
                a.width = screen.width;
            }
            if (screen.height < a.height) {
                a.height = screen.height;
            }
            if (a.x < screen.x) {
                a.x = screen.x;
            }
            if (a.y < screen.y) {
                a.y = screen.y;
            }
            if (a.x + a.width > screen.x + screen.width) {
                a.x = screen.x + screen.width - a.width;
            }
            if (a.y + a.height > screen.y + screen.height) {
                a.y = screen.y + screen.height - a.height;
            }
            return a;
        }
        return r;
    }

    public static Rectangle intersectRectangleWithScreen(Display d, Rectangle r, boolean includeReservedInsets, boolean singleMonitor) {
        if (singleMonitor) {
            return r.intersection(SwtUtility.getFullScreenBoundsFor(d, r, includeReservedInsets));
        }
        ArrayList<Rectangle> intersections = new ArrayList<Rectangle>();
        Monitor[] monitorArray = d.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor dev = monitorArray[n2];
            Rectangle bounds = !includeReservedInsets ? dev.getClientArea() : dev.getBounds();
            Rectangle intersection = bounds.intersection(r);
            if (!intersection.isEmpty()) {
                intersections.add(intersection);
            }
            ++n2;
        }
        if (intersections.size() > 0) {
            Rectangle unionAll = null;
            for (Rectangle i : intersections) {
                unionAll = unionAll == null ? i : unionAll.union(i);
            }
            return unionAll;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static <T extends Widget> T findChildComponent(Widget parent, Class<T> type) {
        ArrayList list = new ArrayList(1);
        SwtUtility.findChildComponentsRec(parent, type, list, 1);
        if (list.size() > 0) {
            return (T)((Widget)list.get(0));
        }
        return null;
    }

    public static <T extends Widget> List<T> findChildComponents(Widget parent, Class<T> type) {
        ArrayList list = new ArrayList();
        SwtUtility.findChildComponentsRec(parent, type, list, Integer.MAX_VALUE);
        return list;
    }

    private static <T extends Widget> void findChildComponentsRec(Widget parent, Class<T> type, List<T> list, int maxCount) {
        if (type.isAssignableFrom(parent.getClass())) {
            list.add(parent);
            if (list.size() >= maxCount) {
                return;
            }
        }
        if (parent instanceof Composite) {
            Control[] controlArray = ((Composite)parent).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                SwtUtility.findChildComponentsRec((Widget)c, type, list, maxCount);
                if (list.size() >= maxCount) {
                    return;
                }
                ++n2;
            }
        }
    }

    public static boolean isPopupShell(Shell shell) {
        int style = shell.getStyle();
        Integer extendedStyle = (Integer)shell.getData("extendedStyle");
        if (extendedStyle != null) {
            style |= extendedStyle.intValue();
        }
        return (style & 8) != 0;
    }

    public static ISwtKeyStroke[] getKeyStrokes(IKeyStroke stroke, ISwtEnvironment environment) {
        ArrayList<SwtScoutKeyStroke> swtKeyStrokes = new ArrayList<SwtScoutKeyStroke>();
        List<Integer> keyCodes = SwtUtility.getSwtKeyCodes(stroke);
        int stateMask = SwtUtility.getSwtStateMask(stroke);
        for (Integer keyCode : keyCodes) {
            swtKeyStrokes.add(new SwtScoutKeyStroke(stroke, keyCode, stateMask, environment));
        }
        return swtKeyStrokes.toArray(new ISwtKeyStroke[swtKeyStrokes.size()]);
    }

    public static int getSwtStateMask(IKeyStroke stoke) {
        String[] a = stoke.getKeyStroke().split("-");
        int stateMask = 0;
        if (a.length > 1) {
            int i = 0;
            while (i < a.length - 1) {
                stateMask |= SwtUtility.scoutToSwtKey(a[i]);
                ++i;
            }
        }
        return stateMask;
    }

    public static int getSwtKeyCode(IKeyStroke keyStroke) {
        List<Integer> swtKeyCodes = SwtUtility.getSwtKeyCodes(keyStroke);
        if (swtKeyCodes.isEmpty()) {
            return 0;
        }
        return swtKeyCodes.get(0);
    }

    public static List<Integer> getSwtKeyCodes(IKeyStroke keyStroke) {
        String[] keys = keyStroke.getKeyStroke().split("-");
        List<Integer> swtKeyCodes = new LinkedList<Integer>();
        if (keys.length > 0) {
            swtKeyCodes = SwtUtility.scoutToSwtKeys(keys[keys.length - 1]);
        }
        return swtKeyCodes;
    }

    public static int scoutToSwtKey(String scoutKey) {
        List<Integer> swtKeyCodes = SwtUtility.scoutToSwtKeys(scoutKey);
        if (swtKeyCodes.isEmpty()) {
            return 0;
        }
        return swtKeyCodes.get(0);
    }

    public static List<Integer> scoutToSwtKeys(String scoutKey) {
        Integer mappedKeyCode;
        LinkedList<Integer> swtKeyCodes = new LinkedList<Integer>();
        if (scoutKey.length() == 1) {
            swtKeyCodes.add(Integer.valueOf(scoutKey.charAt(0)));
        }
        if ((mappedKeyCode = SCOUT_SWT_KEY_MAP.get(scoutKey)) == null) {
            if (swtKeyCodes.isEmpty()) {
                LOG.warn("no key mapping for: " + scoutKey);
            }
        } else {
            swtKeyCodes.add(mappedKeyCode);
            if (mappedKeyCode == 13) {
                swtKeyCodes.add(0x1000050);
            }
        }
        return swtKeyCodes;
    }

    public static <T> T[] getItemsOfSelection(Class<T> t, StructuredSelection selection) {
        Object[] result = (Object[])Array.newInstance(t, selection.size());
        int i = 0;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result[i++] = o;
            ++n2;
        }
        return result;
    }

    public static boolean handleNavigationKey(Widget w, int keyCode) {
        if (w instanceof Tree) {
            return SwtUtility.handleNavigationKeyOnTree((Tree)w, keyCode);
        }
        if (w instanceof Table) {
            return SwtUtility.handleNavigationKeyOnTable((Table)w, keyCode);
        }
        return false;
    }

    public static boolean handleNavigationKeyOnTree(Tree tree, int keyCode) {
        if (tree != null && tree.getItemCount() > 0) {
            TreeItem[] a = tree.getSelection();
            TreeItem selItem = a != null && a.length > 0 ? a[0] : null;
            TreeItem next = null;
            switch (keyCode) {
                case 0x1000002: {
                    if (selItem == null) {
                        next = tree.getItem(0);
                        break;
                    }
                    next = SwtUtility.getNextTreeRow(tree, selItem);
                    break;
                }
                case 0x1000001: {
                    if (selItem == null) {
                        next = SwtUtility.getLastTreeRow(tree);
                        break;
                    }
                    next = SwtUtility.getPreviousTreeRow(tree, selItem);
                    break;
                }
                case 0x1000006: {
                    if (selItem == null) {
                        next = tree.getItem(0);
                        tree.setTopItem(next);
                        break;
                    }
                    Rectangle r = tree.getTopItem().getBounds();
                    int y = r.y + tree.getClientArea().height;
                    TreeItem t = tree.getTopItem();
                    while ((t = SwtUtility.getNextTreeRow(tree, t)) != null) {
                        r = t.getBounds();
                        if (r.y + r.height > y) break;
                        next = t;
                    }
                    if (next == null) break;
                    tree.setTopItem(next);
                    break;
                }
                case 0x1000005: {
                    if (selItem == null) {
                        next = SwtUtility.getLastTreeRow(tree);
                        if (next == null) break;
                        tree.setTopItem(next);
                        break;
                    }
                    if (selItem != tree.getTopItem()) {
                        next = tree.getTopItem();
                        tree.setTopItem(next);
                        break;
                    }
                    Rectangle r = tree.getTopItem().getBounds();
                    int y = r.y + r.height - tree.getClientArea().height + 1;
                    TreeItem t = tree.getTopItem();
                    while ((t = SwtUtility.getPreviousTreeRow(tree, t)) != null) {
                        next = t;
                        r = t.getBounds();
                        if (r.y <= y) break;
                    }
                    if (next == null) break;
                    tree.setTopItem(next);
                }
            }
            if (next != null) {
                tree.setSelection(next);
                Event selE = new Event();
                selE.type = 13;
                selE.item = next;
                selE.widget = tree;
                Listener[] listenerArray = tree.getListeners(13);
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener l = listenerArray[n2];
                    l.handleEvent(selE);
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean handleNavigationKeyOnTable(Table table, int keyCode) {
        if (table != null && table.getItemCount() > 0) {
            int count = table.getItemCount();
            TableItem[] a = table.getSelection();
            TableItem selItem = a != null && a.length > 0 ? a[0] : null;
            int selIndex = table.getSelectionIndex();
            TableItem next = null;
            switch (keyCode) {
                case 0x1000002: {
                    if (selItem == null) {
                        next = table.getItem(0);
                        break;
                    }
                    if (selIndex + 1 >= count) break;
                    next = table.getItem(selIndex + 1);
                    break;
                }
                case 0x1000001: {
                    if (selItem == null) {
                        next = table.getItem(count - 1);
                        break;
                    }
                    if (selIndex - 1 < 0) break;
                    next = table.getItem(selIndex - 1);
                    break;
                }
                case 0x1000006: {
                    if (selItem == null) {
                        next = table.getItem(0);
                        table.setTopIndex(table.indexOf(next));
                        break;
                    }
                    Rectangle r = table.getItem(table.getTopIndex()).getBounds();
                    next = table.getItem(new Point(r.x, r.y + table.getClientArea().height - 1));
                    if (next == null) {
                        next = table.getItem(count - 1);
                    }
                    if (next == null) break;
                    table.setTopIndex(table.indexOf(next));
                    break;
                }
                case 0x1000005: {
                    if (selItem == null) {
                        next = table.getItem(count - 1);
                        table.setTopIndex(table.indexOf(next));
                        break;
                    }
                    if (selIndex != table.getTopIndex()) {
                        next = table.getItem(table.getTopIndex());
                        break;
                    }
                    Rectangle r = table.getItem(table.getTopIndex()).getBounds();
                    int y = r.y + r.height - table.getClientArea().height + 1;
                    int i = selIndex - 1;
                    while (i >= 0) {
                        TableItem test = table.getItem(i);
                        if (test.getBounds().y <= y) {
                            next = test;
                            break;
                        }
                        --i;
                    }
                    if (next == null) {
                        next = table.getItem(0);
                    }
                    if (next == null) break;
                    table.setTopIndex(table.indexOf(next));
                }
            }
            if (next != null) {
                table.setSelection(next);
                Event selE = new Event();
                selE.type = 13;
                selE.item = next;
                selE.widget = table;
                Listener[] listenerArray = table.getListeners(13);
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener l = listenerArray[n2];
                    l.handleEvent(selE);
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static TreeItem getNextTreeRow(Tree tree, TreeItem item) {
        if (!item.getExpanded() || item.getItemCount() <= 0) ** GOTO lbl7
        return item.getItem(0);
lbl-1000:
        // 1 sources

        {
            i = parent.indexOf(item);
            if (i >= 0 && i + 1 < parent.getItemCount()) {
                return parent.getItem(i + 1);
            }
            item = parent;
lbl7:
            // 2 sources

            ** while ((parent = item.getParentItem()) != null)
        }
lbl8:
        // 1 sources

        i = tree.indexOf(item);
        if (i >= 0 && i + 1 < tree.getItemCount()) {
            return tree.getItem(i + 1);
        }
        return null;
    }

    public static TreeItem getPreviousTreeRow(Tree tree, TreeItem item) {
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            int i = parent.indexOf(item);
            if (i > 0) {
                TreeItem t = parent.getItem(i - 1);
                while (t.getExpanded() && t.getItemCount() > 0) {
                    t = t.getItem(t.getItemCount() - 1);
                }
                return t;
            }
            return parent;
        }
        int i = tree.indexOf(item);
        if (i > 0) {
            TreeItem t = tree.getItem(i - 1);
            while (t.getExpanded() && t.getItemCount() > 0) {
                t = t.getItem(t.getItemCount() - 1);
            }
            return t;
        }
        return null;
    }

    public static void setNlsTextsOnDisplay(Display display, ScoutTexts textProvider) {
        display.setData(ScoutTexts.JOB_PROPERTY_NAME.toString(), (Object)textProvider);
    }

    public static String getNlsText(Display display, String key, String ... messageArguments) {
        ScoutTexts textProvider;
        if (display != null && (textProvider = (ScoutTexts)display.getData(ScoutTexts.JOB_PROPERTY_NAME.toString())) != null) {
            return textProvider.getText(key, messageArguments);
        }
        return ScoutTexts.get((String)key, (String[])messageArguments);
    }

    public static TreeItem getLastTreeRow(Tree tree) {
        if (tree.getItemCount() > 0) {
            TreeItem t = tree.getItem(tree.getItemCount() - 1);
            while (t.getExpanded() && t.getItemCount() > 0) {
                t = t.getItem(t.getItemCount() - 1);
            }
            return t;
        }
        return null;
    }

    public static Shell getParentShellIgnoringPopups(Display display, int modalities) {
        Shell shell = display.getActiveShell();
        if (shell == null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (shell != null) {
            while (SwtUtility.isPopupShell(shell) && shell.getParent() instanceof Shell) {
                shell = (Shell)shell.getParent();
            }
        }
        if (shell == null) {
            TreeMap<CompositeLong, Shell> map = new TreeMap<CompositeLong, Shell>();
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow w = iWorkbenchWindowArray[n2];
                SwtUtility.visitShellTreeRec(w.getShell(), modalities, 0, map);
                ++n2;
            }
            if (map.size() > 0) {
                shell = (Shell)map.get(map.firstKey());
            }
        }
        if (shell != null && shell.getData() instanceof ProgressMonitorDialog) {
            shell = (Shell)shell.getParent();
        }
        return shell;
    }

    private static void visitShellTreeRec(Shell shell, int modalities, int level, TreeMap<CompositeLong, Shell> out) {
        if (shell == null) {
            return;
        }
        if (!shell.isVisible()) {
            return;
        }
        if (SwtUtility.isPopupShell(shell)) {
            return;
        }
        int style = shell.getStyle();
        if (level == 0) {
            out.put(new CompositeLong(9L, (long)(-level)), shell);
        } else if ((style & 0x20000) != 0) {
            if ((modalities & 0x20000) != 0) {
                out.put(new CompositeLong(0L, (long)(-level)), shell);
            }
        } else if ((style & 0x10000) != 0) {
            if ((modalities & 0x10000) != 0) {
                out.put(new CompositeLong(1L, (long)(-level)), shell);
            }
        } else if (false) {
            out.put(new CompositeLong(2L, (long)(-level)), shell);
        }
        Shell[] children = shell.getShells();
        if (children != null) {
            Shell[] shellArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Shell child = shellArray[n2];
                SwtUtility.visitShellTreeRec(child, modalities, level + 1, out);
                ++n2;
            }
        }
    }

    public static String escapeMnemonics(String text) {
        if (StringUtility.isNullOrEmpty((String)text)) {
            return text;
        }
        return MNEMONIC_PATTERN.matcher(text).replaceAll("\\&$1");
    }
}

