/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal.wizard.project;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.compatibility.P2Utility;
import org.eclipse.scout.sdk.compatibility.internal.PlatformVersionUtility;
import org.eclipse.scout.sdk.rap.operations.project.FillUiRapPluginOperation;
import org.eclipse.scout.sdk.rap.ui.internal.ScoutSdkRapUI;
import org.eclipse.scout.sdk.ui.fields.FileSelectionField;
import org.eclipse.scout.sdk.ui.fields.IFileSelectionListener;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizard;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.osgi.framework.Version;

public class RapTargetPlatformWizardPage
extends AbstractProjectNewWizardPage {
    private static final String[] RAP_PLUGIN_DETECTION_PREFIXES = new String[]{"org.eclipse.rap.rwt_2", "org.eclipse.scout.rt.ui.rap_3.9", "org.eclipse.scout.rt.ui.rap.mobile_3.9"};
    private static final String RAP_TARGET_DEFAULT_SUB_FOLDER = "rap_target";
    private static final String PROP_TARGET_STRATEGY = "propTargetStrategy";
    private static final String PROP_LOCAL_TARGET_FOLDER = "propLocalTargetFolder";
    private static final String PROP_EXTRACT_TARGET_FOLDER = "propExtractTargetFolder";
    private static final String PROP_DOWNLOAD_ECLIPSE_PLATFORM = "propDownloadEclipsePlatform";
    private static final int LABEL_PERCENTAGE = 20;
    private boolean m_messageShown;
    private Button m_extractButton;
    private Button m_remoteButton;
    private Button m_localButton;
    private Button m_laterButton;
    private Control m_extractTargetGroup;
    private Control m_localTargetGroup;
    private Control m_remoteTargetGroup;
    private FileSelectionField m_extractTargetLocationField;
    private FileSelectionField m_localTargetLocationField;
    private Button m_includeRemoteRequirementsButton;
    private FillUiRapPluginOperation.TARGET_STRATEGY[] m_offeredTargetStrategies;

    public RapTargetPlatformWizardPage() {
        this(FillUiRapPluginOperation.TARGET_STRATEGY.values());
    }

    public RapTargetPlatformWizardPage(FillUiRapPluginOperation.TARGET_STRATEGY[] offeredTargetStrategies) {
        super(RapTargetPlatformWizardPage.class.getName());
        this.setTitle(Texts.get((String)"RapTargetDownloadWizardPageTitle"));
        this.setIsDownloadEclipsePlatformInternal(false);
        this.initOfferedTargetStrategies(offeredTargetStrategies);
        this.m_messageShown = false;
        File defRap = this.getDefaultRapLocation();
        if (defRap != null && defRap.exists() && this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING)) {
            this.setTargetStrategy(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING);
            this.setLocalTargetFolder(defRap.getAbsolutePath());
            if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT)) {
                this.setExtractTargetFolder(defRap.getAbsolutePath());
            }
        } else {
            this.setLocalTargetFolder(ResourceUtility.getEclipseInstallLocation().getAbsolutePath());
            if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT)) {
                this.setTargetStrategy(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT);
                if (defRap != null) {
                    this.setExtractTargetFolder(defRap.getAbsolutePath());
                }
            } else if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE)) {
                this.setTargetStrategy(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE);
            } else if (this.getOfferedTargetStrategies().length > 0) {
                this.setTargetStrategy(this.getOfferedTargetStrategies()[0]);
            }
        }
    }

    protected void createContent(Composite parent) {
        if (this.getOfferedTargetStrategies().length > 1) {
            Composite switchBox = new Composite(parent, 0);
            if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT)) {
                this.m_extractButton = new Button(switchBox, 16);
                this.m_extractButton.setText(Texts.get((String)"CreateNewRAPTarget"));
                this.m_extractButton.setSelection(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT.equals((Object)this.getTargetStrategy()));
                this.m_extractButton.addSelectionListener((SelectionListener)new P_StrategySelectionListener(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT));
            }
            if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE)) {
                this.m_remoteButton = new Button(switchBox, 16);
                this.m_remoteButton.setText(Texts.get((String)"DownloadRAPTarget"));
                this.m_remoteButton.setSelection(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE.equals((Object)this.getTargetStrategy()));
                this.m_remoteButton.addSelectionListener((SelectionListener)new P_StrategySelectionListener(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE));
            }
            if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING)) {
                this.m_localButton = new Button(switchBox, 16);
                this.m_localButton.setText(Texts.get((String)"LocalRAPTarget"));
                this.m_localButton.setSelection(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING.equals((Object)this.getTargetStrategy()));
                this.m_localButton.addSelectionListener((SelectionListener)new P_StrategySelectionListener(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING));
            }
            if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LATER)) {
                this.m_laterButton = new Button(switchBox, 16);
                this.m_laterButton.setText(Texts.get((String)"InstallRapTargetLater"));
                this.m_laterButton.setSelection(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LATER.equals((Object)this.getTargetStrategy()));
                this.m_laterButton.addSelectionListener((SelectionListener)new P_StrategySelectionListener(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LATER));
            }
            switchBox.setLayoutData((Object)new GridData(768));
            switchBox.setLayout((Layout)new GridLayout(this.getOfferedTargetStrategies().length, true));
        }
        if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT)) {
            this.m_extractTargetGroup = this.createExtractTargetGroup(parent);
            this.m_extractTargetGroup.setVisible(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT.equals((Object)this.getTargetStrategy()));
            GridData extractGroupData = new GridData(768);
            extractGroupData.exclude = !FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT.equals((Object)this.getTargetStrategy());
            this.m_extractTargetGroup.setLayoutData((Object)extractGroupData);
        }
        if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING)) {
            this.m_localTargetGroup = this.createLocalTargetGroup(parent);
            this.m_localTargetGroup.setVisible(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING.equals((Object)this.getTargetStrategy()));
            GridData localGroupData = new GridData(768);
            localGroupData.exclude = !FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING.equals((Object)this.getTargetStrategy());
            this.m_localTargetGroup.setLayoutData((Object)localGroupData);
        }
        if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE)) {
            this.m_remoteTargetGroup = this.createRemoteGroup(parent);
            this.m_remoteTargetGroup.setVisible(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE.equals((Object)this.getTargetStrategy()));
            GridData remoteGroupData = new GridData(768);
            remoteGroupData.exclude = !FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE.equals((Object)this.getTargetStrategy());
            this.m_remoteTargetGroup.setLayoutData((Object)remoteGroupData);
        }
        parent.setLayout((Layout)new GridLayout(1, true));
    }

    private File getDefaultRapLocation() {
        File l = ResourceUtility.getEclipseInstallLocation();
        File ret = null;
        if (l != null) {
            ret = new File(l, RAP_TARGET_DEFAULT_SUB_FOLDER);
        } else {
            File[] roots = File.listRoots();
            if (roots.length > 0) {
                ret = new File(roots[0], RAP_TARGET_DEFAULT_SUB_FOLDER);
            }
        }
        return ret;
    }

    private Control createExtractTargetGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"CreateNewRAPTarget"));
        this.m_extractTargetLocationField = new FileSelectionField((Composite)group, 20);
        this.m_extractTargetLocationField.setLabelText(Texts.get((String)"RAPTargetLocation"));
        this.m_extractTargetLocationField.setFolderMode(true);
        this.m_extractTargetLocationField.setFile(new File(this.getExtractTargetFolder()));
        this.m_extractTargetLocationField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 64) {
                    File f = RapTargetPlatformWizardPage.this.getFileFromInpuString(RapTargetPlatformWizardPage.this.m_extractTargetLocationField.getText());
                    File existing = new File(RapTargetPlatformWizardPage.this.getExtractTargetFolder());
                    if (f != null && !f.equals(existing)) {
                        RapTargetPlatformWizardPage.this.setExtractTargetFolderInternal(f.getAbsolutePath());
                        RapTargetPlatformWizardPage.this.pingStateChanging();
                    }
                }
            }
        });
        this.m_extractTargetLocationField.addProductSelectionListener(new IFileSelectionListener(){

            public void fileSelected(File file) {
                String fileName = "";
                if (file != null) {
                    fileName = file.getAbsolutePath();
                }
                RapTargetPlatformWizardPage.this.setExtractTargetFolderInternal(fileName);
                RapTargetPlatformWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_extractTargetLocationField.setLayoutData((Object)new GridData(768));
        return group;
    }

    private Control createRemoteGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"DownloadRAPTarget"));
        this.m_includeRemoteRequirementsButton = new Button((Composite)group, 32);
        this.m_includeRemoteRequirementsButton.setSelection(this.isDownloadEclipsePlatform().booleanValue());
        this.m_includeRemoteRequirementsButton.setText(Texts.get((String)"DownloadEclipsePlatformAsWell"));
        this.m_includeRemoteRequirementsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RapTargetPlatformWizardPage.this.m_includeRemoteRequirementsButton.getSelection() && !RapTargetPlatformWizardPage.this.m_messageShown && !PlatformVersionUtility.isLatest()) {
                    MessageBox msgBox = new MessageBox(RapTargetPlatformWizardPage.this.m_includeRemoteRequirementsButton.getShell(), 40);
                    msgBox.setMessage(Texts.get((String)"RapTargetInfoMessage"));
                    msgBox.open();
                    RapTargetPlatformWizardPage.this.m_messageShown = true;
                }
                RapTargetPlatformWizardPage.this.setIsDownloadEclipsePlatformInternal(RapTargetPlatformWizardPage.this.m_includeRemoteRequirementsButton.getSelection());
                RapTargetPlatformWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_includeRemoteRequirementsButton.setLayoutData((Object)new GridData(768));
        return group;
    }

    private File getFileFromInpuString(String input) {
        try {
            if (StringUtility.hasText((String)input)) {
                if (input.contains("${eclipse_home}")) {
                    input = input.replace("${eclipse_home}", ResourceUtility.getEclipseInstallLocation().getAbsolutePath());
                }
                return new File(input);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File("");
    }

    private Control createLocalTargetGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"LocalRAPTarget"));
        this.m_localTargetLocationField = new FileSelectionField((Composite)group, 20);
        this.m_localTargetLocationField.setLabelText(Texts.get((String)"RAPTargetLocation"));
        this.m_localTargetLocationField.setFolderMode(true);
        this.m_localTargetLocationField.setFile(new File(this.getLocalTargetFolder()));
        this.m_localTargetLocationField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 64) {
                    File f = RapTargetPlatformWizardPage.this.getFileFromInpuString(RapTargetPlatformWizardPage.this.m_localTargetLocationField.getText());
                    File existing = new File(RapTargetPlatformWizardPage.this.getLocalTargetFolder());
                    if (f != null && !f.equals(existing)) {
                        RapTargetPlatformWizardPage.this.setLocalTargetFolderInternal(f.getAbsolutePath());
                        RapTargetPlatformWizardPage.this.pingStateChanging();
                    }
                }
            }
        });
        this.m_localTargetLocationField.addProductSelectionListener(new IFileSelectionListener(){

            public void fileSelected(File file) {
                String fileName = "";
                if (file != null) {
                    fileName = file.getAbsolutePath();
                }
                RapTargetPlatformWizardPage.this.setLocalTargetFolderInternal(fileName);
                RapTargetPlatformWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_localTargetLocationField.setLayoutData((Object)new GridData(768));
        return group;
    }

    public ScoutProjectNewWizard getWizard() {
        return (ScoutProjectNewWizard)super.getWizard();
    }

    public void putProperties(PropertyMap properties) {
        Set checkedNodeIds = (Set)properties.getProperty("CHECKED_NODES", Set.class);
        if (checkedNodeIds != null && checkedNodeIds.contains("org.eclipse.scout.sdk.ui.UiRapBundle")) {
            Version v;
            properties.setProperty(PROP_LOCAL_TARGET_FOLDER, (Object)this.getLocalTargetFolder());
            properties.setProperty(PROP_EXTRACT_TARGET_FOLDER, (Object)this.getExtractTargetFolder());
            properties.setProperty(PROP_TARGET_STRATEGY, (Object)this.getTargetStrategy());
            properties.setProperty(PROP_DOWNLOAD_ECLIPSE_PLATFORM, (Object)this.isDownloadEclipsePlatform());
            if (this.getTargetStrategy() == FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE && this.isDownloadEclipsePlatform().booleanValue() && (v = this.getRemotePlatformVersion()) != null) {
                properties.setProperty("TARGET_PLATFORM_VERSION", (Object)v);
            }
        }
    }

    public void performHelp() {
        ResourceUtility.showUrlInBrowser((String)"http://wiki.eclipse.org/Scout/HowTo/3.9/Create_a_new_project#Step_3_.28Optional.29");
    }

    private Version getRemotePlatformVersion() {
        try {
            String version = P2Utility.getLatestVersion((String)"org.eclipse.platform.source.feature.group", (URI)new URI("http://download.eclipse.org/releases/kepler"), (IProgressMonitor)new NullProgressMonitor());
            return new Version(version);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setTargetStrategy(FillUiRapPluginOperation.TARGET_STRATEGY strategy) {
        block15: {
            try {
                if (strategy == null) {
                    strategy = FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE;
                }
                this.setTargetStrategyInternal(strategy);
                if (!this.isControlCreated()) break block15;
                switch (strategy) {
                    case STRATEGY_LOCAL_EXISTING: {
                        if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING)) {
                            this.m_localButton.setSelection(true);
                        }
                        break;
                    }
                    case STRATEGY_LOCAL_EXTRACT: {
                        if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT)) {
                            this.m_extractButton.setSelection(true);
                        }
                        break;
                    }
                    case STRATEGY_REMOTE: {
                        if (this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE)) {
                            this.m_remoteButton.setSelection(true);
                        }
                        break;
                    }
                    case STRATEGY_LATER: {
                        if (!this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LATER)) break;
                        this.m_laterButton.setSelection(true);
                    }
                    default: {
                        break;
                    }
                }
            }
            finally {
                this.setStateChanging(false);
            }
        }
    }

    private void setTargetStrategyInternal(FillUiRapPluginOperation.TARGET_STRATEGY strategy) {
        if (!this.isStrategyOffered(strategy)) {
            throw new IllegalArgumentException("unsupported strategy: " + strategy);
        }
        this.setProperty(PROP_TARGET_STRATEGY, strategy);
    }

    public FillUiRapPluginOperation.TARGET_STRATEGY getTargetStrategy() {
        return (FillUiRapPluginOperation.TARGET_STRATEGY)this.getProperty(PROP_TARGET_STRATEGY);
    }

    public Boolean isDownloadEclipsePlatform() {
        return (Boolean)this.getProperty(PROP_DOWNLOAD_ECLIPSE_PLATFORM);
    }

    public void setIsDownloadEclipsePlatform(Boolean val) {
        try {
            this.setStateChanging(true);
            this.setIsDownloadEclipsePlatformInternal(val);
            if (this.isControlCreated() && this.m_includeRemoteRequirementsButton != null) {
                this.m_includeRemoteRequirementsButton.setSelection(val.booleanValue());
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setIsDownloadEclipsePlatformInternal(Boolean val) {
        this.setProperty(PROP_DOWNLOAD_ECLIPSE_PLATFORM, val);
    }

    public String getExtractTargetFolder() {
        return (String)this.getProperty(PROP_EXTRACT_TARGET_FOLDER);
    }

    public void setExtractTargetFolder(String proposal) {
        try {
            this.setStateChanging(true);
            this.setExtractTargetFolderInternal(proposal);
            if (this.isControlCreated() && this.m_extractTargetLocationField != null) {
                this.m_extractTargetLocationField.setFileName(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setExtractTargetFolderInternal(String extractTargetLocation) {
        if (extractTargetLocation != null) {
            extractTargetLocation = extractTargetLocation.trim();
        }
        this.setProperty(PROP_EXTRACT_TARGET_FOLDER, extractTargetLocation);
    }

    public String getLocalTargetFolder() {
        return (String)this.getProperty(PROP_LOCAL_TARGET_FOLDER);
    }

    public void setLocalTargetFolder(String proposal) {
        try {
            this.setStateChanging(true);
            this.setLocalTargetFolderInternal(proposal);
            if (this.isControlCreated() && this.m_localTargetLocationField != null) {
                this.m_localTargetLocationField.setFileName(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLocalTargetFolderInternal(String localTargetLocation) {
        if (localTargetLocation != null) {
            localTargetLocation = localTargetLocation.trim();
        }
        this.setProperty(PROP_LOCAL_TARGET_FOLDER, localTargetLocation);
    }

    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusStrategy());
    }

    private boolean isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY strategy) {
        FillUiRapPluginOperation.TARGET_STRATEGY[] tARGET_STRATEGYArray = this.getOfferedTargetStrategies();
        int n = tARGET_STRATEGYArray.length;
        int n2 = 0;
        while (n2 < n) {
            FillUiRapPluginOperation.TARGET_STRATEGY item = tARGET_STRATEGYArray[n2];
            if (item.equals((Object)strategy)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IStatus getStatusStrategy() {
        if (FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING.equals((Object)this.getTargetStrategy())) {
            if (!StringUtility.hasText((String)this.getLocalTargetFolder())) {
                return new Status(4, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"NoRAPTargetLocationDefined"));
            }
            File target = new File(this.getLocalTargetFolder());
            if (!target.exists() || !new File(target, "plugins").exists()) {
                return new Status(4, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"NoRAPTargetFoundUnder", (String[])new String[]{this.getLocalTargetFolder()}));
            }
            try {
                String[] pluginNames;
                File pluginsFolder = new File(new File(this.getLocalTargetFolder()), "plugins");
                if (pluginsFolder.exists() && (pluginNames = pluginsFolder.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String n = name.toLowerCase().trim();
                        String[] stringArray = RAP_PLUGIN_DETECTION_PREFIXES;
                        int n2 = stringArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String s = stringArray[n3];
                            if (n.startsWith(s) && n.endsWith(".jar")) {
                                return true;
                            }
                            ++n3;
                        }
                        return false;
                    }
                })).length == RAP_PLUGIN_DETECTION_PREFIXES.length) {
                    return Status.OK_STATUS;
                }
            }
            catch (IllegalArgumentException e) {
                ScoutSdkRapUI.logError("could not parse rap feature version.", e);
            }
            return new Status(4, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"NoRAPTargetFoundUnder", (String[])new String[]{this.getLocalTargetFolder()}));
        }
        if (FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT.equals((Object)this.getTargetStrategy())) {
            File targetDir;
            if (!StringUtility.hasText((String)this.getExtractTargetFolder())) {
                return new Status(4, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"NoRAPTargetLocationDefined"));
            }
            File eclipseFolder = ResourceUtility.getEclipseInstallLocation();
            if (CompareUtility.equals((Object)eclipseFolder, (Object)(targetDir = new File(this.getExtractTargetFolder())))) {
                return new Status(4, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"RAPTargetNotInstallableInPlatform"));
            }
            if (targetDir.exists()) {
                return new Status(2, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"RAPTargetAlreadyExists"));
            }
            return new Status(1, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"ANewRAPTargetWillBeCreated", (String[])new String[]{this.getExtractTargetFolder()}));
        }
        if (FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE.equals((Object)this.getTargetStrategy())) {
            if (this.isDownloadEclipsePlatform().booleanValue()) {
                int severity = 1;
                if (!PlatformVersionUtility.isLatest()) {
                    severity = 2;
                }
                return new Status(severity, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"RapTargetAndEclipseDownload"));
            }
            return new Status(1, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"TheRAPTargetWillBeDownloaded"));
        }
        if (FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LATER.equals((Object)this.getTargetStrategy())) {
            return new Status(1, "org.eclipse.scout.sdk.rap.ui", Texts.get((String)"NoRAPTargetWillBeSet"));
        }
        return Status.OK_STATUS;
    }

    public FillUiRapPluginOperation.TARGET_STRATEGY[] getOfferedTargetStrategies() {
        return this.m_offeredTargetStrategies;
    }

    private void initOfferedTargetStrategies(FillUiRapPluginOperation.TARGET_STRATEGY[] offeredTargetStrategies) {
        boolean isRapTargetPluginAvailable;
        boolean bl = isRapTargetPluginAvailable = Platform.getBundle((String)"org.eclipse.scout.rt.rap.target") != null;
        if (!isRapTargetPluginAvailable) {
            ArrayList<FillUiRapPluginOperation.TARGET_STRATEGY> strategies = new ArrayList<FillUiRapPluginOperation.TARGET_STRATEGY>(offeredTargetStrategies.length);
            FillUiRapPluginOperation.TARGET_STRATEGY[] tARGET_STRATEGYArray = offeredTargetStrategies;
            int n = offeredTargetStrategies.length;
            int n2 = 0;
            while (n2 < n) {
                FillUiRapPluginOperation.TARGET_STRATEGY s = tARGET_STRATEGYArray[n2];
                if (!FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT.equals((Object)s)) {
                    strategies.add(s);
                }
                ++n2;
            }
            offeredTargetStrategies = strategies.toArray(new FillUiRapPluginOperation.TARGET_STRATEGY[strategies.size()]);
        }
        this.m_offeredTargetStrategies = offeredTargetStrategies;
    }

    private class P_StrategySelectionListener
    extends SelectionAdapter {
        private final FillUiRapPluginOperation.TARGET_STRATEGY m_strategy;

        public P_StrategySelectionListener(FillUiRapPluginOperation.TARGET_STRATEGY strategy) {
            this.m_strategy = strategy;
        }

        private void setGroupVisible(Control toBeVisible) {
            if (RapTargetPlatformWizardPage.this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXISTING)) {
                boolean localVisible = RapTargetPlatformWizardPage.this.m_localTargetGroup == toBeVisible;
                RapTargetPlatformWizardPage.this.m_localTargetGroup.setVisible(localVisible);
                boolean bl = ((GridData)((RapTargetPlatformWizardPage)RapTargetPlatformWizardPage.this).m_localTargetGroup.getLayoutData()).exclude = !localVisible;
            }
            if (RapTargetPlatformWizardPage.this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_REMOTE)) {
                boolean remoteVisible = RapTargetPlatformWizardPage.this.m_remoteTargetGroup == toBeVisible;
                RapTargetPlatformWizardPage.this.m_remoteTargetGroup.setVisible(remoteVisible);
                boolean bl = ((GridData)((RapTargetPlatformWizardPage)RapTargetPlatformWizardPage.this).m_remoteTargetGroup.getLayoutData()).exclude = !remoteVisible;
            }
            if (RapTargetPlatformWizardPage.this.isStrategyOffered(FillUiRapPluginOperation.TARGET_STRATEGY.STRATEGY_LOCAL_EXTRACT)) {
                boolean extractVisible = RapTargetPlatformWizardPage.this.m_extractTargetGroup == toBeVisible;
                RapTargetPlatformWizardPage.this.m_extractTargetGroup.setVisible(extractVisible);
                ((GridData)((RapTargetPlatformWizardPage)RapTargetPlatformWizardPage.this).m_extractTargetGroup.getLayoutData()).exclude = !extractVisible;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            RapTargetPlatformWizardPage.this.setTargetStrategyInternal(this.m_strategy);
            switch (this.m_strategy) {
                case STRATEGY_LOCAL_EXISTING: {
                    this.setGroupVisible(RapTargetPlatformWizardPage.this.m_localTargetGroup);
                    break;
                }
                case STRATEGY_LOCAL_EXTRACT: {
                    this.setGroupVisible(RapTargetPlatformWizardPage.this.m_extractTargetGroup);
                    break;
                }
                case STRATEGY_REMOTE: {
                    this.setGroupVisible(RapTargetPlatformWizardPage.this.m_remoteTargetGroup);
                    break;
                }
                case STRATEGY_LATER: {
                    this.setGroupVisible(null);
                }
            }
            RapTargetPlatformWizardPage.this.m_localTargetGroup.getParent().layout(true);
            RapTargetPlatformWizardPage.this.pingStateChanging();
        }
    }
}

