/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractScoutHandler
extends AbstractHandler
implements IScoutHandler {
    private String m_label;
    private String m_toolTip;
    private ImageDescriptor m_image;
    private String m_keyStroke;
    private boolean m_multiSelectSupported;
    private IScoutHandler.Category m_category;

    public AbstractScoutHandler(String label) {
        this(label, null);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image) {
        this(label, image, null);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image, String keyStroke) {
        this(label, image, keyStroke, false);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image, String keyStroke, boolean multiSelectSupported) {
        this(label, image, keyStroke, multiSelectSupported, IScoutHandler.Category.OTHER);
    }

    public AbstractScoutHandler(String label, ImageDescriptor image, String keyStroke, boolean multiSelectSupported, IScoutHandler.Category cat) {
        this.m_label = label;
        this.m_image = image;
        this.m_keyStroke = keyStroke;
        this.m_multiSelectSupported = multiSelectSupported;
        this.m_category = cat == null ? IScoutHandler.Category.OTHER : cat;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    public String getToolTip() {
        return this.m_toolTip;
    }

    @Override
    public void setToolTip(String toolTip) {
        this.m_toolTip = toolTip;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.m_image;
    }

    @Override
    public void setImage(ImageDescriptor imageName) {
        this.m_image = imageName;
    }

    @Override
    public String getKeyStroke() {
        return this.m_keyStroke;
    }

    @Override
    public void setKeyStroke(String keyStroke) {
        this.m_keyStroke = keyStroke;
    }

    @Override
    public boolean isMultiSelectSupported() {
        return this.m_multiSelectSupported;
    }

    @Override
    public void setMultiSelectSupported(boolean multiSelectSupported) {
        this.m_multiSelectSupported = multiSelectSupported;
    }

    @Override
    public IScoutHandler.Category getCategory() {
        return this.m_category;
    }

    @Override
    public void setCategory(IScoutHandler.Category category) {
        this.m_category = category;
    }

    @Override
    public final String getId() {
        return this.getClass().getName();
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection;
        IScoutExplorerPart explorer = ScoutSdkUi.getExplorer(false);
        if (explorer != null && (selection = explorer.getSelection()) != null && explorer.getSite() != null) {
            Shell shell = explorer.getSite().getShell();
            IPage[] selectedPages = new IPage[selection.size()];
            Iterator it = selection.iterator();
            int index = 0;
            while (it.hasNext()) {
                selectedPages[index++] = (IPage)it.next();
            }
            return this.execute(shell, selectedPages, event);
        }
        return null;
    }

    @Override
    public abstract Object execute(Shell var1, IPage[] var2, ExecutionEvent var3) throws ExecutionException;

    protected boolean isEditable(IJavaElement element) {
        if (!TypeUtility.exists((IJavaElement)element)) {
            return false;
        }
        if (element.isReadOnly()) {
            return false;
        }
        IScoutBundle b = ScoutTypeUtility.getScoutBundle((IJavaElement)element);
        return b != null && !b.isBinary();
    }
}

