/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.EditorSelectionVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public class LinkWithEditorAction
extends Action {
    private static final long BRIEF_DELAY = 100L;
    private P_PropertyListener m_propertyListener;
    private P_JavaEditorSelectionListener m_javaEditorSelectionListener;
    private final ScoutExplorerPart m_viewPart;
    private IJavaElement m_currentSelection;
    private P_UpdateSelectionJob m_updateSelectionJob;

    public LinkWithEditorAction(ScoutExplorerPart viewPart) {
        super(Texts.get((String)"LinkWithEditor"), 2);
        this.m_viewPart = viewPart;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("synced.gif"));
        this.setToolTipText(Texts.get((String)"LinkWithEditor"));
        this.m_updateSelectionJob = new P_UpdateSelectionJob();
        this.init();
    }

    protected void init() {
        if (this.m_propertyListener == null) {
            this.m_propertyListener = new P_PropertyListener();
        }
        this.m_viewPart.addPropertyListener(this.m_propertyListener);
        if (this.m_javaEditorSelectionListener == null) {
            this.m_javaEditorSelectionListener = new P_JavaEditorSelectionListener();
        }
        this.m_viewPart.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this.m_javaEditorSelectionListener);
    }

    public void dispose() {
        this.m_viewPart.removePropertyListener(this.m_propertyListener);
        this.m_propertyListener = null;
    }

    public void run() {
        this.m_viewPart.setLinkingEnabled(this.isChecked());
    }

    public IJavaElement getCurrentSelection() {
        return this.m_currentSelection;
    }

    public void setCurrentSelection(IJavaElement currentSelection) {
        IJavaElement oldSelection = this.m_currentSelection;
        this.m_currentSelection = currentSelection;
        if (this.isChecked() && CompareUtility.notEquals((Object)oldSelection, (Object)this.m_currentSelection)) {
            this.m_updateSelectionJob.schedule(100L);
        }
    }

    public void updateLinkingEnabled(boolean linkingEnabled) {
        this.setChecked(linkingEnabled);
        if (linkingEnabled) {
            this.m_updateSelectionJob.schedule(100L);
        }
    }

    private class P_JavaEditorSelectionListener
    implements ISelectionListener {
        private P_JavaEditorSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part instanceof IEditorPart) {
                IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
                if (selection instanceof ITextSelection) {
                    IClassFileEditorInput binaryInput;
                    IType type;
                    if (editorInput instanceof IFileEditorInput) {
                        IFileEditorInput fileInput = (IFileEditorInput)editorInput;
                        try {
                            IJavaElement element = JdtUtility.findJavaElement((IFile)fileInput.getFile(), (ITextSelection)((ITextSelection)selection));
                            if (TypeUtility.exists((IJavaElement)element)) {
                                LinkWithEditorAction.this.setCurrentSelection(element);
                            }
                        }
                        catch (JavaModelException e) {
                            ScoutSdkUi.logWarning("Unable to calculate the selected java element.", e);
                        }
                    } else if (editorInput instanceof IClassFileEditorInput && TypeUtility.exists((IJavaElement)(type = (binaryInput = (IClassFileEditorInput)editorInput).getClassFile().getType()))) {
                        LinkWithEditorAction.this.setCurrentSelection((IJavaElement)type);
                    }
                }
            }
        }
    }

    private class P_PropertyListener
    implements IPropertyListener {
        private P_PropertyListener() {
        }

        public void propertyChanged(Object aSource, int propId) {
            switch (propId) {
                case 1: {
                    LinkWithEditorAction.this.updateLinkingEnabled(((ScoutExplorerPart)aSource).isLinkingEnabled());
                }
            }
        }
    }

    private class P_UpdateSelectionJob
    extends UIJob {
        public P_UpdateSelectionJob() {
            super("Link with outline...");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!LinkWithEditorAction.this.m_viewPart.getTreeViewer().getTree().isDisposed() && TypeUtility.exists((IJavaElement)LinkWithEditorAction.this.getCurrentSelection())) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        IPage startPage = (IPage)LinkWithEditorAction.this.m_viewPart.getTreeViewer().getInput();
                        IStructuredSelection selection = (IStructuredSelection)LinkWithEditorAction.this.m_viewPart.getTreeViewer().getSelection();
                        if (selection != null && selection.size() > 0) {
                            startPage = (IPage)selection.getFirstElement();
                        }
                        EditorSelectionVisitor visitor = new EditorSelectionVisitor(LinkWithEditorAction.this.getCurrentSelection());
                        IPage nodeToSelect = null;
                        nodeToSelect = visitor.findPageToSelect(startPage);
                        if (nodeToSelect != null) {
                            StructuredSelection outlineSelection = new StructuredSelection((Object)nodeToSelect);
                            LinkWithEditorAction.this.m_viewPart.getSite().getSelectionProvider().setSelection((ISelection)outlineSelection);
                        }
                    }

                    public void handleException(Throwable e) {
                        ScoutSdkUi.logError(e);
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

