/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.TypeDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DeleteAction
extends AbstractScoutHandler {
    private String m_name;
    private ArrayList<IType> m_types = new ArrayList();

    public DeleteAction() {
        super(Texts.get((String)"DeleteWithPopup"), ScoutSdkUi.getImageDescriptor("remove.png"), "Delete", true, IScoutHandler.Category.DELETE);
    }

    @Override
    public boolean isVisible() {
        for (IType typeToDelete : this.m_types) {
            if (this.isEditable((IJavaElement)typeToDelete)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        MessageBox box = new MessageBox(shell, 292);
        box.setText(Texts.get((String)"Question"));
        if (this.m_types.size() == 1) {
            if (!StringUtility.hasText((String)this.m_name) && this.m_types.get(0) != null) {
                this.m_name = this.m_types.get(0).getElementName();
            }
            box.setMessage(Texts.get((String)"DeleteAction_ensureRequest", (String[])new String[]{this.m_name}));
        } else {
            box.setMessage(Texts.get((String)"DeleteAction_ensureRequestPlural"));
        }
        if (box.open() == 32) {
            for (IType t : this.m_types) {
                OperationJob job = new OperationJob(new IOperation[]{new TypeDeleteOperation(t)});
                job.schedule();
            }
        }
        return null;
    }

    public void addType(IType t) {
        this.m_types.add(t);
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

