/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TableColumnDeleteAction
extends AbstractScoutHandler {
    private ArrayList<IType> m_tableColumns = new ArrayList();

    public TableColumnDeleteAction() {
        super(Texts.get((String)"DeleteWithPopup"), ScoutSdkUi.getImageDescriptor("tableColumn_remove.png"), "Delete", true, IScoutHandler.Category.DELETE);
    }

    @Override
    public boolean isVisible() {
        if (this.m_tableColumns == null || this.m_tableColumns.size() < 1) {
            return false;
        }
        for (IType col : this.m_tableColumns) {
            if (this.isEditable((IJavaElement)col)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        MessageBox box = new MessageBox(shell, 292);
        if (this.m_tableColumns.size() == 1) {
            box.setMessage(Texts.get((String)"Action_deleteNameX", (String[])new String[]{this.m_tableColumns.get(0).getElementName()}));
        } else {
            box.setMessage(Texts.get((String)"ColumnDeleteConfirmationMessage"));
        }
        if (box.open() == 32) {
            JavaElementDeleteOperation delOp = new JavaElementDeleteOperation();
            for (IType columnToDelete : this.m_tableColumns) {
                delOp.addMember((IJavaElement)columnToDelete);
                IMethod getter = ScoutTypeUtility.getColumnGetterMethod((IType)columnToDelete);
                if (!TypeUtility.exists((IJavaElement)getter)) continue;
                delOp.addMember((IJavaElement)getter);
            }
            OperationJob job = new OperationJob(new IOperation[]{delOp});
            job.schedule();
        }
        return null;
    }

    public void addTableColumn(IType tableColumn) {
        this.m_tableColumns.add(tableColumn);
    }
}

