/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.library;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.library.LibraryBundlesAddOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LibraryBundleLinkAction
extends AbstractScoutHandler {
    private IScoutBundle m_libraryUserBundle;

    public LibraryBundleLinkAction() {
        super(Texts.get((String)"LinkLibraryBundlePopup"), ScoutSdkUi.getImageDescriptor("libraries_add.png"));
    }

    @Override
    public boolean isVisible() {
        return this.getLibraryUserBundle() != null && !this.getLibraryUserBundle().isBinary();
    }

    @Override
    public Object execute(final Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                PluginSelectionDialog dialog = new PluginSelectionDialog(shell, LibraryBundleLinkAction.this.getPotentialLibraryBundles(), true);
                dialog.setDialogBoundsSettings(ScoutSdkUi.getDefault().getDialogSettingsSection(String.valueOf(LibraryBundleLinkAction.class.getName()) + ".DialogSettings"), 2);
                dialog.setInitialPattern("**");
                dialog.create();
                if (dialog.open() == 0) {
                    Object[] result;
                    HashSet<IPluginModelBase> libraries = new HashSet<IPluginModelBase>();
                    Object[] objectArray = result = dialog.getResult();
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof IPluginModelBase) {
                            libraries.add((IPluginModelBase)o);
                        }
                        ++n2;
                    }
                    LibraryBundleLinkAction.this.addLibraries(libraries);
                }
            }
        });
        return null;
    }

    protected IPluginModelBase[] getPotentialLibraryBundles() {
        HashSet<String> alreadyLinkedLibraries = new HashSet<String>();
        PluginModelHelper helper = new PluginModelHelper(this.getLibraryUserBundle().getProject());
        IPluginImport[] iPluginImportArray = helper.Manifest.getAllDependencies();
        int n = iPluginImportArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport imp = iPluginImportArray[n2];
            alreadyLinkedLibraries.add(imp.getId());
            ++n2;
        }
        LinkedList<IPluginModelBase> plugins = new LinkedList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
        int n3 = iPluginModelBaseArray.length;
        n = 0;
        while (n < n3) {
            IProject project;
            IPluginModelBase bundle = iPluginModelBaseArray[n];
            if (bundle instanceof IPluginModel && (project = bundle.getUnderlyingResource().getProject()) != null && project.exists()) {
                try {
                    if (project.isOpen() && project.hasNature("org.eclipse.scout.sdk.ScoutLibraryNature") && !alreadyLinkedLibraries.contains(project.getName())) {
                        plugins.add(bundle);
                    }
                }
                catch (CoreException e) {
                    ScoutSdkUi.logWarning("Could not determ library or not on '" + bundle.getBundleDescription().getName() + "'.");
                }
            }
            ++n;
        }
        return plugins.toArray(new IPluginModelBase[plugins.size()]);
    }

    protected void addLibraries(Set<IPluginModelBase> libraries) {
        LibraryBundlesAddOperation addOp = new LibraryBundlesAddOperation(this.getLibraryUserBundle(), libraries);
        new OperationJob(new IOperation[]{addOp}).schedule();
    }

    public void setLibraryUserBundle(IScoutBundle libraryUserBundle) {
        this.m_libraryUserBundle = libraryUserBundle;
    }

    public IScoutBundle getLibraryUserBundle() {
        return this.m_libraryUserBundle;
    }
}

