/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.type.FieldFilters;
import org.eclipse.scout.sdk.util.type.IFieldFilter;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class PropertyBeansRenameAction
extends AbstractRenameAction {
    private IPropertyBean[] m_propertyBeanDescriptors;

    public PropertyBeansRenameAction() {
        this.setReadOnlySuffix("");
        this.setOldName("");
    }

    @Override
    public boolean isVisible() {
        if (this.m_propertyBeanDescriptors == null || this.m_propertyBeanDescriptors.length < 1) {
            return false;
        }
        IPropertyBean[] iPropertyBeanArray = this.m_propertyBeanDescriptors;
        int n = this.m_propertyBeanDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyBean p = iPropertyBeanArray[n2];
            if (!this.isEditable((IJavaElement)p.getDeclaringType())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        String oldNameLower = this.getBeanName(this.getOldName(), false);
        String oldNameUpper = this.getBeanName(this.getOldName(), true);
        IPropertyBean[] iPropertyBeanArray = this.getPropertyBeanDescriptors();
        int n = iPropertyBeanArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyBean d = iPropertyBeanArray[n2];
            IMember[] iMemberArray = d.getAllMembers();
            int n3 = iMemberArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMember m = iMemberArray[n4];
                String elementName = m.getElementName();
                switch (m.getElementType()) {
                    case 8: {
                        transaction.add((IField)m, elementName.replaceAll(oldNameLower, this.getBeanName(newName, false)));
                        break;
                    }
                    case 9: {
                        transaction.add((IMethod)m, elementName.replaceAll(oldNameUpper, this.getBeanName(newName, true)));
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public String getBeanName(String name, boolean startWithUpperCase) {
        if (StringUtility.isNullOrEmpty((String)name) || name.length() < 2) {
            return null;
        }
        if (startWithUpperCase) {
            return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        IPropertyBean[] iPropertyBeanArray = this.getPropertyBeanDescriptors();
        int n = iPropertyBeanArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyBean bean = iPropertyBeanArray[n2];
            if (TypeUtility.getFirstMethod((IType)bean.getDeclaringType(), (IMethodFilter)MethodFilters.getNameRegexFilter((Pattern)Pattern.compile("(get|set|is)" + newName))) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
            }
            String fieldName = "m_" + Character.toLowerCase(newName.charAt(0));
            if (bean.getBeanName().length() > 1) {
                fieldName = String.valueOf(fieldName) + newName.substring(1);
                if (TypeUtility.getFirstField((IType)bean.getDeclaringType(), (IFieldFilter)FieldFilters.getNameRegexFilter((Pattern)Pattern.compile(fieldName))) != null) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
                }
            }
            ++n2;
        }
        return inheritedStatus;
    }

    public IPropertyBean[] getPropertyBeanDescriptors() {
        return this.m_propertyBeanDescriptors;
    }

    public void setPropertyBeanDescriptors(IPropertyBean[] propertyBeanDescriptors) {
        this.m_propertyBeanDescriptors = propertyBeanDescriptors;
        if (this.getPropertyBeanDescriptors() != null && this.getPropertyBeanDescriptors().length > 0) {
            this.setOldName(this.getPropertyBeanDescriptors()[0].getBeanName());
        }
    }
}

