/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class TableColumnRenameAction
extends AbstractRenameAction {
    private IType m_tableColumn;

    public TableColumnRenameAction() {
        this.setReadOnlySuffix("Column");
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getTableColumn(), newName);
        IMethod getter = ScoutTypeUtility.getColumnGetterMethod((IType)this.getTableColumn());
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + Character.toUpperCase(newName.charAt(0)) + newName.substring(1));
        }
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_tableColumn);
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.getTableColumn().getDeclaringType().getType(newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        return inheritedStatus;
    }

    public IType getTableColumn() {
        return this.m_tableColumn;
    }

    public void setTableColumn(IType tableColumn) {
        this.m_tableColumn = tableColumn;
    }
}

