/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class WizardStepRenameAction
extends AbstractRenameAction {
    private IType m_wizardStep;

    public WizardStepRenameAction() {
        this.setReadOnlySuffix("Step");
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getWizardStep(), newName);
        IMethod getter = ScoutTypeUtility.getWizardStepGetterMethod((IType)this.getWizardStep());
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + Character.toUpperCase(newName.charAt(0)) + newName.substring(1));
        }
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_wizardStep);
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.getWizardStep().getDeclaringType().getType(newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        return inheritedStatus;
    }

    public IType getWizardStep() {
        return this.m_wizardStep;
    }

    public void setWizardStep(IType wizardStep) {
        this.m_wizardStep = wizardStep;
    }
}

