/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.preferences;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class TargetPackageModel
implements Comparable<TargetPackageModel> {
    final String m_id;
    final String m_defaultVal;
    final IScoutBundle m_context;
    String m_curVal;
    String m_group;
    String m_label;

    TargetPackageModel(String id, String defaultVal, IScoutBundle context) {
        this.m_id = id;
        this.m_defaultVal = defaultVal;
        this.m_context = context;
    }

    @Override
    public int compareTo(TargetPackageModel o) {
        return this.m_id.compareTo(o.m_id);
    }

    public void load() {
        this.m_curVal = DefaultTargetPackage.get((IScoutBundle)this.m_context, (String)this.m_id);
        String[] tokens = this.getTokens();
        this.m_group = tokens[0];
        this.m_label = tokens[1];
    }

    private String[] getTokens() {
        String[] tokens = this.m_id.split("\\.");
        StringBuilder lbl = new StringBuilder();
        String group = null;
        boolean first = true;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (StringUtility.hasText((String)s)) {
                s = s.trim();
                if (first) {
                    group = s;
                    first = false;
                } else {
                    lbl.append(Character.toUpperCase(s.charAt(0)));
                    if (s.length() > 1) {
                        lbl.append(s.substring(1));
                    }
                    lbl.append(" ");
                }
            }
            ++n2;
        }
        return new String[]{group, lbl.toString()};
    }
}

