/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.technology;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.sdk.compatibility.P2Utility;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.extensions.technology.ScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.LicenseDialog;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceFilters;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public abstract class AbstractScoutTechnologyHandler
implements IScoutTechnologyHandler {
    protected AbstractScoutTechnologyHandler() {
    }

    @Override
    public IScoutTechnologyResource[] getModifactionResourceCandidates(IScoutBundle project) throws CoreException {
        ArrayList<IScoutTechnologyResource> ret = new ArrayList<IScoutTechnologyResource>();
        this.contributeResources(project, ret);
        return ret.toArray(new IScoutTechnologyResource[ret.size()]);
    }

    protected abstract void contributeResources(IScoutBundle var1, List<IScoutTechnologyResource> var2) throws CoreException;

    protected void contributeProductFiles(IScoutBundle[] projects, List<IScoutTechnologyResource> list, String ... bundleFilter) throws CoreException {
        IScoutBundle[] iScoutBundleArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle e = iScoutBundleArray[n2];
            this.contributeProductFiles(e, list, bundleFilter);
            ++n2;
        }
    }

    private void contributeProductFiles(IScoutBundle project, List<IScoutTechnologyResource> list, String ... bundleFilter) throws CoreException {
        this.contributeProductFiles(project, list, true, bundleFilter);
    }

    protected void contributeProductFiles(IScoutBundle project, List<IScoutTechnologyResource> list, boolean defaultSelection, String ... bundleFilter) throws CoreException {
        P_TechProductFile[] productFiles = this.getFilteredProductFiles(project, bundleFilter);
        int i = 0;
        while (i < productFiles.length) {
            P_TechProductFile prodFile = productFiles[i];
            list.add(new ScoutTechnologyResource(prodFile.bundle, prodFile.productFile, defaultSelection));
            ++i;
        }
    }

    protected void contributeManifestFiles(IScoutBundle[] bundles, List<IScoutTechnologyResource> list) {
        IScoutBundle[] iScoutBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle bundle = iScoutBundleArray[n2];
            this.contributeManifestFile(bundle, list);
            ++n2;
        }
    }

    protected void contributeManifestFile(IScoutBundle bundle, List<IScoutTechnologyResource> list) {
        IScoutTechnologyResource res;
        if (bundle != null && !bundle.isBinary() && (res = this.getManifestResource(bundle)).getResource() != null) {
            list.add(res);
        }
    }

    protected TriState getSelectionManifestsImportPackage(IScoutBundle[] projects, String ... importPackages) {
        if (projects == null || projects.length == 0) {
            return TriState.FALSE;
        }
        TriState ret = this.getSelectionManifestsImportPackage(projects[0], importPackages);
        int i = 1;
        while (i < projects.length) {
            TriState tmp = this.getSelectionManifestsImportPackage(projects[i], importPackages);
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionManifestsImportPackage(IScoutBundle project, String ... importPackages) {
        if (importPackages == null || importPackages.length == 0) {
            return TriState.FALSE;
        }
        PluginModelHelper pluginModel = new PluginModelHelper(project.getProject());
        TriState ret = TriState.parseTriState((Object)pluginModel.Manifest.existsImportPackage(importPackages[0]));
        int i = 1;
        while (i < importPackages.length) {
            TriState tmp = TriState.parseTriState((Object)pluginModel.Manifest.existsImportPackage(importPackages[i]));
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionManifests(IScoutBundle[] projects, String ... pluginIds) {
        if (projects == null || projects.length == 0) {
            return TriState.FALSE;
        }
        TriState ret = this.getSelectionManifest(projects[0], pluginIds);
        int i = 1;
        while (i < projects.length) {
            TriState tmp = this.getSelectionManifest(projects[i], pluginIds);
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionManifest(IScoutBundle project, String ... pluginIds) {
        if (pluginIds == null || pluginIds.length == 0) {
            return TriState.FALSE;
        }
        PluginModelHelper pluginModel = new PluginModelHelper(project.getProject());
        TriState ret = TriState.parseTriState((Object)pluginModel.Manifest.existsDependency(pluginIds[0]));
        int i = 1;
        while (i < pluginIds.length) {
            TriState tmp = TriState.parseTriState((Object)pluginModel.Manifest.existsDependency(pluginIds[i]));
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionProductFiles(IScoutBundle[] projects, String[] filterPluginIds, String[] ... pluginIds) throws CoreException {
        if (projects == null || projects.length == 0) {
            return TriState.FALSE;
        }
        TriState ret = this.getSelectionProductFiles(projects[0], filterPluginIds, pluginIds);
        int i = 1;
        while (i < projects.length) {
            TriState tmp = this.getSelectionProductFiles(projects[i], filterPluginIds, pluginIds);
            if (tmp != null) {
                if (ret == null) {
                    ret = tmp;
                } else if (tmp != ret) {
                    return TriState.UNDEFINED;
                }
            }
            ++i;
        }
        return ret;
    }

    private TriState getSelectionProductFiles(IScoutBundle project, String[] filterPluginIds, String[] ... pluginIds) throws CoreException {
        P_TechProductFile[] productFiles = this.getFilteredProductFiles(project, filterPluginIds);
        if (productFiles == null || productFiles.length == 0) {
            return null;
        }
        TriState ret = TriState.parseTriState((Object)this.containsProductDependencies(productFiles[0].productFile, pluginIds));
        int i = 1;
        while (i < productFiles.length) {
            TriState tmp = TriState.parseTriState((Object)this.containsProductDependencies(productFiles[i].productFile, pluginIds));
            if (ret != tmp) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean preSelectionChanged(boolean selected, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    @Override
    public void postSelectionChanged(boolean selected, IProgressMonitor monitor) throws CoreException {
    }

    protected void selectionChangedProductFiles(IScoutTechnologyResource[] resources, boolean selected, String[] ... pluginIds) throws CoreException {
        IScoutTechnologyResource[] iScoutTechnologyResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutTechnologyResource r = iScoutTechnologyResourceArray[n2];
            this.selectionChangedProductFile(r, selected, pluginIds);
            ++n2;
        }
    }

    protected void selectionChangedProductFile(IScoutTechnologyResource r, boolean selected, String[] ... pluginIds) throws CoreException {
        ProductFileModelHelper h = new ProductFileModelHelper(r.getResource());
        String[][] stringArray = pluginIds;
        int n = pluginIds.length;
        int n2 = 0;
        while (n2 < n) {
            String[] list;
            String[] stringArray2 = list = stringArray[n2];
            int n3 = list.length;
            int n4 = 0;
            while (n4 < n3) {
                String pluginId = stringArray2[n4];
                if (selected) {
                    h.ProductFile.addDependency(pluginId);
                } else {
                    h.ProductFile.removeDependency(pluginId);
                }
                ++n4;
            }
            ++n2;
        }
        h.save();
    }

    protected void selectionChangedManifest(IScoutTechnologyResource[] resources, boolean selected, String ... pluginsToHandle) throws CoreException {
        IScoutTechnologyResource[] iScoutTechnologyResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutTechnologyResource r = iScoutTechnologyResourceArray[n2];
            this.selectionChangedManifest(r, selected, pluginsToHandle);
            ++n2;
        }
    }

    protected void selectionChangedManifest(IScoutTechnologyResource r, boolean selected, String ... pluginsToHandle) throws CoreException {
        PluginModelHelper pluginModel = new PluginModelHelper(r.getBundle().getProject());
        String[] stringArray = pluginsToHandle;
        int n = pluginsToHandle.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId = stringArray[n2];
            if (selected) {
                pluginModel.Manifest.addDependency(pluginId);
            } else {
                pluginModel.Manifest.removeDependency(pluginId);
            }
            ++n2;
        }
        pluginModel.save();
    }

    protected void selectionChangedManifestImportPackage(IScoutTechnologyResource[] resources, boolean selected, String[] packages, String[] versions) throws CoreException {
        IScoutTechnologyResource[] iScoutTechnologyResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutTechnologyResource r = iScoutTechnologyResourceArray[n2];
            PluginModelHelper pluginModel = new PluginModelHelper(r.getBundle().getProject());
            int i = 0;
            while (i < Math.min(packages.length, versions.length)) {
                if (selected) {
                    pluginModel.Manifest.addImportPackage(packages[i], versions[i]);
                } else {
                    pluginModel.Manifest.removeImportPackage(packages[i]);
                }
                ++i;
            }
            pluginModel.save();
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean containsProductDependencies(IFile productFile, String[] ... pluginFilters) {
        try {
            ProductFileModelHelper h = new ProductFileModelHelper(productFile);
            String[][] stringArray = pluginFilters;
            int n = pluginFilters.length;
            int n2 = 0;
            block2: while (true) {
                String[] list;
                if (n2 >= n) {
                    return true;
                }
                String[] stringArray2 = list = stringArray[n2];
                int n3 = list.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        ++n2;
                        continue block2;
                    }
                    String pluginId = stringArray2[n4];
                    if (!h.ProductFile.existsDependency(pluginId)) {
                        return false;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("cannot parse product file: " + productFile, e);
            return false;
        }
    }

    protected P_TechProductFile[] getProductFiles(IScoutBundle[] projects) throws CoreException {
        ArrayList<P_TechProductFile> list = new ArrayList<P_TechProductFile>();
        IScoutBundle[] iScoutBundleArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle element = iScoutBundleArray[n2];
            IResource[] productFiles = ResourceUtility.getAllResources((IResource)element.getProject(), (IResourceFilter)ResourceFilters.getProductFilter());
            int i = 0;
            while (i < productFiles.length) {
                IResource prodFile = productFiles[i];
                IScoutBundle b = ScoutTypeUtility.getScoutBundle((IProject)prodFile.getProject());
                if (b != null) {
                    P_TechProductFile tpf = new P_TechProductFile();
                    tpf.bundle = b;
                    tpf.productFile = (IFile)prodFile;
                    list.add(tpf);
                }
                ++i;
            }
            ++n2;
        }
        return list.toArray(new P_TechProductFile[list.size()]);
    }

    protected IScoutTechnologyResource getManifestResource(IScoutBundle bundle) {
        return new ScoutTechnologyResource(bundle, bundle.getProject().getFile("META-INF/MANIFEST.MF"));
    }

    protected P_TechProductFile[] getFilteredProductFiles(IScoutBundle project, String ... pluginFilter) throws CoreException {
        return this.getFilteredProductFiles(new IScoutBundle[]{project}, pluginFilter);
    }

    protected P_TechProductFile[] getFilteredProductFiles(IScoutBundle[] projects, String ... pluginFilter) throws CoreException {
        P_TechProductFile[] candidates = this.getProductFiles(projects);
        ArrayList<P_TechProductFile> ret = new ArrayList<P_TechProductFile>(candidates.length);
        P_TechProductFile[] p_TechProductFileArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            P_TechProductFile candidate = p_TechProductFileArray[n2];
            if (this.containsProductDependencies(candidate.productFile, new String[][]{pluginFilter})) {
                ret.add(candidate);
            }
            ++n2;
        }
        return ret.toArray(new P_TechProductFile[ret.size()]);
    }

    protected FeatureInstallResult ensureFeatureInstalled(String featureId, String featureUrl, IProgressMonitor monitor, String ... definingPlugins) throws CoreException {
        return this.ensureFeaturesInstalled(new String[]{featureId}, new String[]{featureUrl}, monitor, new String[][]{definingPlugins});
    }

    protected FeatureInstallResult ensureFeaturesInstalled(String[] featureIds, String[] featureUrls, IProgressMonitor monitor, String[] ... definingPlugins) throws CoreException {
        ArrayList<URI> repos = new ArrayList<URI>();
        ArrayList<String> featureIdsToInstall = new ArrayList<String>();
        try {
            int maxNum = Math.min(Math.min(featureIds.length, featureUrls.length), definingPlugins.length);
            int i = 0;
            while (i < maxNum) {
                if (!JdtUtility.areAllPluginsInstalled((String[])definingPlugins[i])) {
                    repos.add(new URI(featureUrls[i]));
                    featureIdsToInstall.add(featureIds[i]);
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
        if (featureIdsToInstall.size() == 0) {
            return FeatureInstallResult.InstallationNotNecessary;
        }
        URI[] repoURIs = repos.toArray(new URI[repos.size()]);
        String[] ius = featureIdsToInstall.toArray(new String[featureIdsToInstall.size()]);
        final BooleanHolder licAccepted = new BooleanHolder(Boolean.valueOf(false));
        final Map licenses = P2Utility.getLicenses((String[])ius, (URI[])repoURIs, (IProgressMonitor)monitor);
        ScoutSdkUi.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LicenseDialog licDialog = new LicenseDialog(ScoutSdkUi.getShell(), licenses);
                if (licDialog.open() == 0) {
                    licAccepted.setValue((Object)true);
                }
            }
        });
        if (((Boolean)licAccepted.getValue()).booleanValue()) {
            P2Utility.installUnits((String[])ius, (URI[])repoURIs, (IProgressMonitor)monitor);
            return FeatureInstallResult.InstallationSuccessful;
        }
        return FeatureInstallResult.LicenseNotAccepted;
    }

    protected void refreshScoutExplorerPageAsync(final Class<? extends IPage> pageToRefresh) {
        ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IScoutExplorerPart explorer = ScoutSdkUi.getExplorer(false);
                if (explorer != null) {
                    INodeVisitor visitor = new INodeVisitor(){

                        @Override
                        public int visit(IPage page) {
                            if (pageToRefresh.isAssignableFrom(page.getClass())) {
                                page.markStructureDirty();
                                return 3;
                            }
                            return 1;
                        }
                    };
                    JdtUtility.waitForSilentWorkspace();
                    explorer.getRootPage().accept(visitor);
                }
            }
        });
    }

    protected static enum FeatureInstallResult {
        InstallationNotNecessary,
        InstallationSuccessful,
        LicenseNotAccepted;

    }

    protected static class P_TechProductFile {
        public IFile productFile;
        public IScoutBundle bundle;

        protected P_TechProductFile() {
        }
    }
}

