/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.bundletree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CheckableTree
extends Composite {
    public static final String TYPE_ROOT = "root";
    private static final int TEXT_MARGIN = 2;
    private final ITreeNode m_rootNode;
    private final HashMap<ITreeNode, Rectangle> m_checkableNodeBounds = new HashMap();
    private final HashSet<ITreeNode> m_checkedNodes = new HashSet();
    private final Image m_imgCheckboxYes = ScoutSdkUi.getImage("output_yes.gif");
    private final Image m_imgCheckboxNo = ScoutSdkUi.getImage("output_no.gif");
    private final Image m_imgCheckboxYesDisabled = ScoutSdkUi.getImage("output_yes_disabled");
    private final Image m_imgCheckboxNoDisabled = ScoutSdkUi.getImage("output_no_disabled");
    private final EventListenerList m_eventListeners = new EventListenerList();
    private final ArrayList<ITreeNodeFilter> m_filters = new ArrayList();
    private final HashMap<ImageDescriptor, Image> m_icons = new HashMap();
    private Tree m_tree;
    private TreeViewer m_viewer;
    private P_TreePaintListener m_paintListener;

    public CheckableTree(Composite parent, ITreeNode rootNode) {
        super(parent, 0);
        this.m_rootNode = rootNode;
        this.m_filters.add(NodeFilters.getVisible());
        this.setLayout((Layout)new FillLayout());
        this.createControl(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Image img : CheckableTree.this.m_icons.values()) {
                    if (img == null || img.isDisposed()) continue;
                    img.dispose();
                }
                CheckableTree.this.m_icons.clear();
            }
        });
    }

    protected void createControl(Composite parent) {
        this.m_tree = new Tree(parent, 2048);
        this.m_viewer = new TreeViewer(this.m_tree);
        this.m_viewer.setAutoExpandLevel(-1);
        this.installListeners();
        P_TreeModel model = new P_TreeModel();
        this.m_viewer.setContentProvider((IContentProvider)model);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)model);
        this.m_viewer.setInput((Object)model);
    }

    protected void installListeners() {
        P_CheckboxListener checkboxListener = new P_CheckboxListener();
        this.m_tree.addListener(3, (Listener)checkboxListener);
        this.m_tree.addListener(4, (Listener)checkboxListener);
        if (this.m_paintListener == null) {
            this.m_paintListener = new P_TreePaintListener();
            this.m_tree.addListener(41, (Listener)this.m_paintListener);
            this.m_tree.addListener(40, (Listener)this.m_paintListener);
            this.m_tree.addListener(42, (Listener)this.m_paintListener);
        }
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeNode node;
                IStructuredSelection selection;
                if (event.getSelection() != null && event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1 && (node = (ITreeNode)selection.getFirstElement()).isEnabled()) {
                    CheckableTree.this.invertCheckStateFromUi(node);
                }
            }
        });
        this.m_tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ITreeNode node;
                IStructuredSelection selection;
                if (e.keyCode == 32 && (selection = (IStructuredSelection)CheckableTree.this.m_viewer.getSelection()).size() == 1 && (node = (ITreeNode)selection.getFirstElement()).isEnabled()) {
                    CheckableTree.this.invertCheckStateFromUi(node);
                }
            }
        });
        int operations = 3;
        DragSource source = new DragSource((Control)this.m_tree, operations);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new P_DragSourceListener());
        operations = 3;
        P_DropTargetListener adapter = new P_DropTargetListener((Viewer)this.m_viewer);
        adapter.setExpandEnabled(false);
        types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.m_viewer.addDropSupport(operations, types, (DropTargetListener)adapter);
    }

    public void addDndListener(ITreeDndListener listener) {
        this.m_eventListeners.add(ITreeDndListener.class, (EventListener)listener);
    }

    public void removeDndListener(ITreeDndListener listener) {
        this.m_eventListeners.remove(ITreeDndListener.class, (EventListener)listener);
    }

    public void addCheckSelectionListener(ICheckStateListener listener) {
        this.m_eventListeners.add(ICheckStateListener.class, (EventListener)listener);
    }

    public void removeCheckSelectionListener(ICheckStateListener listener) {
        this.m_eventListeners.remove(ICheckStateListener.class, (EventListener)listener);
    }

    protected void fireNodeCheckstateChanged(ITreeNode node, boolean checked) {
        ICheckStateListener[] iCheckStateListenerArray = (ICheckStateListener[])this.m_eventListeners.getListeners(ICheckStateListener.class);
        int n = iCheckStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICheckStateListener l = iCheckStateListenerArray[n2];
            l.fireNodeCheckStateChanged(node, checked);
            ++n2;
        }
    }

    public void addTreeNodeFilter(ITreeNodeFilter filter) {
        this.m_filters.add(filter);
    }

    public boolean removeTreeNodeFilter(ITreeNodeFilter filter) {
        return this.m_filters.remove(filter);
    }

    public ITreeNodeFilter[] getTreeNodeFilters() {
        return this.m_filters.toArray(new ITreeNodeFilter[this.m_filters.size()]);
    }

    public TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point computeSize = super.computeSize(hint, hint2, changed);
        computeSize.y = (int)((double)computeSize.y * 1.2);
        return computeSize;
    }

    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    public boolean isChecked(ITreeNode node) {
        return this.m_checkedNodes.contains(node);
    }

    public ITreeNode[] getCheckedNodes() {
        return this.m_checkedNodes.toArray(new ITreeNode[this.m_checkedNodes.size()]);
    }

    protected void invertCheckStateFromUi(ITreeNode node) {
        this.setChecked(node, !this.isChecked(node));
    }

    public void setChecked(ITreeNode[] nodes) {
        ArrayList<ITreeNode> nodesToCheck = new ArrayList<ITreeNode>(Arrays.asList(nodes));
        ArrayList<ITreeNode> checkedNodes = new ArrayList<ITreeNode>(this.m_checkedNodes);
        Iterator<ITreeNode> it = checkedNodes.iterator();
        while (it.hasNext()) {
            ITreeNode n = it.next();
            if (!nodesToCheck.remove(n)) continue;
            it.remove();
        }
        for (ITreeNode n : checkedNodes) {
            this.setChecked(n, false);
        }
        for (ITreeNode n : nodesToCheck) {
            this.setChecked(n, true);
        }
    }

    public boolean setChecked(ITreeNode node, boolean checked) {
        boolean result = false;
        result = checked ? this.m_checkedNodes.add(node) : this.m_checkedNodes.remove(node);
        if (result) {
            this.fireNodeCheckstateChanged(node, checked);
            this.m_tree.redraw();
        }
        return result;
    }

    public ITreeNode getParent(ITreeNode childNode) {
        return childNode.getParent();
    }

    public ITreeNode[] getChildren(ITreeNode parentNode) {
        return this.sortChildren(parentNode.getChildren(NodeFilters.getCombinedFilter(this.getTreeNodeFilters())));
    }

    protected ITreeNode[] sortChildren(ITreeNode[] children) {
        TreeMap<CompositeObject, ITreeNode> nodes = new TreeMap<CompositeObject, ITreeNode>();
        ITreeNode[] iTreeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            nodes.put(new CompositeObject(new Object[]{new Long(n3.getOrderNr()), n3.getText(), n3}), n3);
            ++n2;
        }
        return nodes.values().toArray(new ITreeNode[nodes.values().size()]);
    }

    private class P_CheckboxListener
    implements Listener {
        private Point m_mousedownPosition = null;

        private P_CheckboxListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    this.m_mousedownPosition = new Point(event.x, event.y);
                    break;
                }
                case 4: {
                    Point point = new Point(event.x, event.y);
                    if (this.m_mousedownPosition == null || Math.abs(point.x - this.m_mousedownPosition.x) >= 5 || Math.abs(point.y - this.m_mousedownPosition.y) >= 5) break;
                    for (Map.Entry e : CheckableTree.this.m_checkableNodeBounds.entrySet()) {
                        if (!((Rectangle)e.getValue()).contains(point) || !((ITreeNode)e.getKey()).isEnabled()) continue;
                        CheckableTree.this.invertCheckStateFromUi((ITreeNode)e.getKey());
                    }
                    break;
                }
            }
        }
    }

    private class P_DragSourceListener
    implements DragSourceListener {
        private P_DragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            StructuredSelection selection = (StructuredSelection)CheckableTree.this.m_viewer.getSelection();
            if (selection.isEmpty()) {
                event.doit = false;
            } else {
                if ((event.detail & 1) != 0) {
                    event.doit = false;
                    return;
                }
                ITreeDndListener[] iTreeDndListenerArray = (ITreeDndListener[])CheckableTree.this.m_eventListeners.getListeners(ITreeDndListener.class);
                int n = iTreeDndListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeDndListener l = iTreeDndListenerArray[n2];
                    if (!l.isDragableNode((ITreeNode)selection.getFirstElement())) {
                        event.doit = false;
                        break;
                    }
                    ++n2;
                }
            }
        }

        public void dragSetData(DragSourceEvent event) {
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            if (transfer.isSupportedType(event.dataType)) {
                transfer.setSelection(CheckableTree.this.m_viewer.getSelection());
                event.data = transfer;
            }
        }

        public void dragFinished(DragSourceEvent event) {
            CheckableTree.this.m_viewer.refresh();
        }
    }

    private class P_DropTargetListener
    extends ViewerDropAdapter {
        private int m_lastOperation;

        protected P_DropTargetListener(Viewer viewer) {
            super(viewer);
            this.m_lastOperation = 0;
        }

        protected ITreeNode getSelectedObject() {
            return (ITreeNode)super.getSelectedObject();
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if ((operation & 1) != 0) {
                this.m_lastOperation = 1;
            } else if ((operation & 2) != 0) {
                this.m_lastOperation = 2;
            }
            return this.isValid(this.getSelectedObject().getParent(), (ITreeNode)target, this.getSelectedObject(), this.m_lastOperation);
        }

        private boolean isValid(ITreeNode source, ITreeNode destination, ITreeNode node, int operation) {
            DndEvent dndEvent = new DndEvent((Object)CheckableTree.this);
            dndEvent.doit = false;
            dndEvent.node = node;
            dndEvent.sourceParent = source;
            dndEvent.targetParent = destination;
            dndEvent.operation = this.m_lastOperation;
            ITreeDndListener[] iTreeDndListenerArray = (ITreeDndListener[])CheckableTree.this.m_eventListeners.getListeners(ITreeDndListener.class);
            int n = iTreeDndListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeDndListener l = iTreeDndListenerArray[n2];
                l.validateTarget(dndEvent);
                ++n2;
            }
            return dndEvent.doit;
        }

        public boolean performDrop(Object data) {
            ITreeNode selectedNode = this.getSelectedObject();
            ITreeNode newParentNode = (ITreeNode)this.getCurrentTarget();
            ITreeNode oldParent = selectedNode.getParent();
            if ((this.m_lastOperation & 2) != 0) {
                oldParent.removeChild(selectedNode);
                selectedNode.setParent(null);
            } else if ((this.m_lastOperation & 1) != 0) {
                if (selectedNode.getChildren().size() > 0) {
                    throw new IllegalStateException("in case of copy a node can not have children.");
                }
                selectedNode = new TreeNode(selectedNode);
            }
            if (newParentNode.getChildren(NodeFilters.getByType(selectedNode.getType())).length == 0) {
                newParentNode.addChild(selectedNode);
                selectedNode.setParent(newParentNode);
            }
            DndEvent dndEvent = new DndEvent((Object)CheckableTree.this);
            dndEvent.node = this.getSelectedObject();
            dndEvent.sourceParent = dndEvent.node.getParent();
            dndEvent.targetParent = newParentNode;
            dndEvent.doit = true;
            ITreeDndListener[] iTreeDndListenerArray = (ITreeDndListener[])CheckableTree.this.m_eventListeners.getListeners(ITreeDndListener.class);
            int n = iTreeDndListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeDndListener l = iTreeDndListenerArray[n2];
                l.dndPerformed(dndEvent);
                ++n2;
            }
            return true;
        }

        public void dragOver(DropTargetEvent event) {
            super.dragOver(event);
            if (!this.isValid(this.getSelectedObject().getParent(), (ITreeNode)this.getCurrentTarget(), this.getSelectedObject(), this.m_lastOperation)) {
                event.feedback &= 0xFFFFFFFE;
            }
        }

        protected int determineLocation(DropTargetEvent event) {
            if (this.isValid(this.getSelectedObject().getParent(), (ITreeNode)this.getCurrentTarget(), this.getSelectedObject(), this.m_lastOperation)) {
                return 3;
            }
            return 4;
        }
    }

    public class P_TreeModel
    extends LabelProvider
    implements ITreeContentProvider,
    IFontProvider,
    IColorProvider {
        private Font m_boldFont;

        public Object[] getElements(Object inputElement) {
            if (CheckableTree.this.getRootNode().isVisible()) {
                return new Object[]{CheckableTree.this.getRootNode()};
            }
            return CheckableTree.this.getChildren(CheckableTree.this.getRootNode());
        }

        public Object[] getChildren(Object parentElement) {
            return CheckableTree.this.getChildren((ITreeNode)parentElement);
        }

        public Object getParent(Object element) {
            return CheckableTree.this.getParent((ITreeNode)element);
        }

        public boolean hasChildren(Object element) {
            return CheckableTree.this.getChildren((ITreeNode)element).length > 0;
        }

        public void dispose() {
            if (this.m_boldFont != null && !this.m_boldFont.isDisposed()) {
                this.m_boldFont.dispose();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            return ((ITreeNode)element).getText();
        }

        public Font getFont(Object element) {
            if (((ITreeNode)element).isBold()) {
                if (this.m_boldFont == null) {
                    Font originalFont = CheckableTree.this.m_tree.getFont();
                    FontData[] fontData = originalFont.getFontData();
                    int i = 0;
                    while (i < fontData.length) {
                        fontData[i].setStyle(fontData[i].getStyle() | 1);
                        ++i;
                    }
                    this.m_boldFont = new Font((Device)CheckableTree.this.m_tree.getDisplay(), fontData);
                }
                return this.m_boldFont;
            }
            return null;
        }

        public Color getForeground(Object element) {
            return ((ITreeNode)element).getForeground();
        }

        public Color getBackground(Object element) {
            return ((ITreeNode)element).getBackground();
        }
    }

    private class P_TreePaintListener
    implements Listener {
        private P_TreePaintListener() {
        }

        public void handleEvent(Event event) {
            TreeItem item = (TreeItem)event.item;
            ITreeNode node = (ITreeNode)item.getData();
            if (node == null) {
                return;
            }
            switch (event.type) {
                case 41: {
                    Point size = new Point(4, 4);
                    if (node.getImage() != null) {
                        Image img = (Image)CheckableTree.this.m_icons.get(node.getImage());
                        if (img == null) {
                            img = node.getImage().createImage();
                            CheckableTree.this.m_icons.put(node.getImage(), img);
                        }
                        size.x += img.getBounds().width + 2;
                        size.y = Math.max(size.y, 4 + img.getBounds().height);
                    }
                    if (node.isCheckable()) {
                        size.x += 18;
                        size.y = Math.max(size.y, 20);
                    }
                    String text = item.getText(event.index);
                    Point textSize = event.gc.textExtent(text);
                    size.x += textSize.x + 2;
                    size.y = Math.max(size.y, textSize.y + 4);
                    event.width = size.x;
                    event.height = size.y;
                    break;
                }
                case 42: {
                    Image img;
                    int x = event.x + 2;
                    int y = event.y;
                    if (node.isCheckable()) {
                        img = CheckableTree.this.m_imgCheckboxNo;
                        img = node.isEnabled() ? (CheckableTree.this.isChecked(node) ? CheckableTree.this.m_imgCheckboxYes : CheckableTree.this.m_imgCheckboxNo) : (CheckableTree.this.isChecked(node) ? CheckableTree.this.m_imgCheckboxYesDisabled : CheckableTree.this.m_imgCheckboxNoDisabled);
                        Rectangle bounds = (Rectangle)CheckableTree.this.m_checkableNodeBounds.get(node);
                        if (bounds == null) {
                            bounds = new Rectangle(0, 0, 0, 0);
                        }
                        bounds.height = img.getBounds().height + 4;
                        bounds.width = img.getBounds().width + 4;
                        bounds.x = x - 2;
                        bounds.y = y;
                        CheckableTree.this.m_checkableNodeBounds.put(node, bounds);
                        event.gc.drawImage(img, x, y + 2);
                        x += img.getBounds().width + 2;
                    }
                    if (node.getImage() != null) {
                        img = (Image)CheckableTree.this.m_icons.get(node.getImage());
                        if (img == null) {
                            img = node.getImage().createImage();
                            CheckableTree.this.m_icons.put(node.getImage(), img);
                        }
                        event.gc.drawImage(img, x, y + 2);
                        x += img.getBounds().width + 2;
                    }
                    String text = item.getText(event.index);
                    int yOffset = 0;
                    Point size = event.gc.textExtent(text);
                    yOffset = Math.max(2, (event.height - size.y) / 2);
                    event.gc.drawText(text, x, y + yOffset, true);
                    break;
                }
                case 40: {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        }
    }
}

