/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.javacode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.ui.fields.javacode.JavaTypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ISeparatorProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;

public class JavaCodeFieldContentProvider
implements IContentProposalProvider {
    private final IJavaSearchScope m_seachScope;
    private SearchEngine m_searchEngine;

    public JavaCodeFieldContentProvider(IJavaSearchScope seachScope) {
        this.m_seachScope = seachScope;
        this.m_searchEngine = new SearchEngine();
    }

    public IContentProposal[] findExactMatch(String input) {
        String searchText = this.parseSearchText(input);
        if (searchText == null) {
            return new IContentProposal[0];
        }
        ArrayList<IContentProposal> collector = new ArrayList<IContentProposal>();
        this.collectTypes(searchText, collector, 2, null);
        return collector.toArray(new IContentProposal[collector.size()]);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String searchText = this.parseSearchText(contents.substring(0, position));
        if (searchText == null) {
            return new IContentProposal[0];
        }
        searchText = String.valueOf(searchText) + "*";
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        this.collectTypes(searchText, proposals, 2, null);
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private String parseSearchText(String contents) {
        Matcher m = Pattern.compile("([a-zA-Z.$_0-9]+)$").matcher(contents);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private void collectTypes(String searchText, ArrayList<IContentProposal> collector, int matchStrategy, IProgressMonitor monitor) {
        P_SearchRequestor searchRequestor;
        block7: {
            searchRequestor = new P_SearchRequestor(monitor);
            try {
                this.m_searchEngine.search(SearchPattern.createPattern((String)searchText, (int)0, (int)0, (int)matchStrategy), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.m_seachScope, (SearchRequestor)searchRequestor, null);
            }
            catch (CoreException e) {
                if (e.getStatus().matches(4)) {
                    ScoutSdkUi.logWarning(e);
                    return;
                }
                if (!e.getStatus().matches(8)) break block7;
                return;
            }
        }
        ArrayList<IContentProposal> props = new ArrayList<IContentProposal>(searchRequestor.getResult());
        if (props.size() > 0) {
            if (props.get(0) instanceof ISeparatorProposal) {
                props.remove(0);
            } else if (props.get(props.size() - 1) instanceof ISeparatorProposal) {
                props.remove(props.size() - 1);
            }
        }
        collector.addAll(props);
    }

    private class P_SearchRequestor
    extends SearchRequestor {
        private TreeMap<CompositeObject, IContentProposal> m_foundTypes = new TreeMap();
        private int counter = 0;

        public P_SearchRequestor(IProgressMonitor monitor) {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match instanceof TypeDeclarationMatch) {
                IType type = (IType)match.getElement();
                if (type.getFullyQualifiedName().contains(".internal.")) {
                    return;
                }
                if (type.getDeclaringType() != null) {
                    return;
                }
                if (type.isBinary()) {
                    this.m_foundTypes.put(new CompositeObject(new Object[]{"C", type.getElementName(), type.getFullyQualifiedName()}), new JavaTypeProposal(type));
                } else {
                    this.m_foundTypes.put(new CompositeObject(new Object[]{"A", type.getElementName(), type.getFullyQualifiedName()}), new JavaTypeProposal(type));
                }
                if (this.counter++ > 98) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.scout.sdk.ui", "stopped after 50"));
                }
            }
        }

        public Collection<IContentProposal> getResult() {
            return this.m_foundTypes.values();
        }
    }
}

