/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.tooltip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.compatibility.JavadocHoverUtility;
import org.eclipse.scout.sdk.ui.fields.tooltip.AbstractTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class JavadocTooltip
extends AbstractTooltip {
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;
    private IMember m_originalMember;
    private IMember m_currentMember;
    private Browser m_browser;
    private String m_javaDoc;

    public JavadocTooltip(Control sourceControl) {
        super(sourceControl);
    }

    public void setMember(IMember member) {
        this.m_originalMember = member;
        this.resetCurrentMember();
    }

    private void resetCurrentMember() {
        this.setCurrentMember(this.m_originalMember);
    }

    private void setCurrentMember(IMember member) {
        if (this.m_currentMember != member) {
            this.m_currentMember = member;
            this.computeJavadoc();
        }
    }

    @Override
    protected void createContent(Composite parent) {
        block2: {
            try {
                this.m_browser = new Browser(parent, 0);
                this.m_browser.setJavascriptEnabled(true);
                this.m_browser.setText(this.m_javaDoc);
                GridData layoutData = new GridData(1808);
                layoutData.heightHint = 200;
                layoutData.widthHint = 650;
                this.m_browser.setLayoutData((Object)layoutData);
                this.m_browser.addLocationListener(JavaElementLinks.createLocationListener((JavaElementLinks.ILinkHandler)new JavaElementLinks.ILinkHandler(){

                    public void handleTextSet() {
                    }

                    public void handleJavadocViewLink(IJavaElement target) {
                    }

                    public void handleInlineJavadocLink(IJavaElement target) {
                        if (target instanceof IMember) {
                            JavadocTooltip.this.setCurrentMember((IMember)target);
                        }
                    }

                    public boolean handleExternalLink(URL url, Display display) {
                        return false;
                    }

                    public void handleDeclarationLink(IJavaElement target) {
                    }
                }));
            }
            catch (SWTError swterr) {
                ScoutSdkUi.logError("Error creating Javadoc Tooltip: " + swterr.getMessage());
                if (this.m_browser == null) break block2;
                this.m_browser.dispose();
                this.m_browser = null;
            }
        }
    }

    @Override
    protected void show(int x, int y) {
        this.resetCurrentMember();
        if (!StringUtility.isNullOrEmpty((String)this.m_javaDoc)) {
            super.show(x, y);
        }
    }

    private void computeJavadoc() {
        if (!TypeUtility.exists((IJavaElement)this.m_currentMember)) {
            return;
        }
        Job j = new Job("calculating java doc of '" + this.m_currentMember.getElementName() + "'"){

            protected IStatus run(IProgressMonitor monitor) {
                block14: {
                    Reader contentReader = null;
                    try {
                        try {
                            if (TypeUtility.exists((IJavaElement)JavadocTooltip.this.m_currentMember) && (contentReader = JavadocContentAccess.getHTMLContentReader((IMember)JavadocTooltip.this.m_currentMember, (boolean)true, (boolean)true)) != null) {
                                JavadocTooltip.this.m_javaDoc = JavadocTooltip.this.getJavadocHtml(new IJavaElement[]{JavadocTooltip.this.m_currentMember});
                                if (JavadocTooltip.this.getSourceControl() != null && !JavadocTooltip.this.getSourceControl().isDisposed()) {
                                    JavadocTooltip.this.getSourceControl().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (JavadocTooltip.this.m_browser != null && !JavadocTooltip.this.m_browser.isDisposed()) {
                                                JavadocTooltip.this.m_browser.setText(JavadocTooltip.this.m_javaDoc);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                        catch (Exception e) {
                            ScoutSdkUi.logWarning(e);
                            if (contentReader == null) break block14;
                            try {
                                contentReader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        if (contentReader != null) {
                            try {
                                contentReader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        j.setPriority(50);
        j.setSystem(true);
        j.setUser(false);
        j.schedule();
    }

    private String getJavadocHtml(IJavaElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        String base = null;
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)this.getInfoText(curr, null, false));
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                IMember member = (IMember)curr;
                String constantValue = null;
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText((IJavaElement)member, constantValue, true));
                StringReader reader = null;
                try {
                    String content = JavadocContentAccess2.getHTMLContent((IMember)member, (boolean)true);
                    StringReader stringReader = reader = content == null ? null : new StringReader(content);
                    if (reader == null && member.isBinary()) {
                        boolean hasSource;
                        boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation((IJavaElement)member) != null;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)member.getAncestor(3);
                        boolean hasAttachedSource = root != null && root.getSourceAttachmentPath() != null;
                        IOpenable openable = member.getOpenable();
                        boolean bl = hasSource = openable.getBuffer() != null;
                        if (!hasAttachedSource && !hasAttachedJavadoc) {
                            reader = new StringReader("");
                        } else if (!hasAttachedJavadoc && !hasSource) {
                            reader = new StringReader("");
                        } else if (!hasAttachedSource) {
                            reader = new StringReader("");
                        } else if (!hasSource) {
                            reader = new StringReader("");
                        }
                    } else {
                        base = JavadocTooltip.getBaseURL(member);
                    }
                }
                catch (JavaModelException ex) {
                    JavaPlugin.log((IStatus)ex.getStatus());
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
            } else if (curr.getElementType() == 14 || curr.getElementType() == 15) {
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText(curr, null, true));
            }
        }
        boolean flushContent = true;
        if (buffer.length() > 0 || flushContent) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, null, null, (String)JavadocTooltip.loadStyleSheet());
            if (base != null) {
                int endHeadIdx = buffer.indexOf("</head>");
                buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IJavaElement member, String constantValue, boolean allowImage) {
        StringBuffer label = new StringBuffer(JavaElementLinks.getElementLabel((IJavaElement)member, (long)LABEL_FLAGS));
        if (member.getElementType() == 8 && constantValue != null) {
            label.append(constantValue);
        }
        String imageName = null;
        try {
            URL imageUrl;
            if (allowImage && (imageUrl = JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(member)) != null) {
                imageName = imageUrl.toExternalForm();
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not load image for '" + member.getElementName() + "'.");
        }
        return JavadocHoverUtility.addImageAndLabel((IJavaElement)member, imageName, (String)label.toString());
    }

    private static String loadStyleSheet() {
        Bundle bundle = JavaPlugin.getDefault().getBundle();
        URL styleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
            return string;
        }
        catch (IOException ex) {
            JavaPlugin.log((Throwable)ex);
            return null;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getBaseURL(IMember element) throws JavaModelException {
        if (element.isBinary()) {
            URL baseURL = JavaUI.getJavadocLocation((IJavaElement)element, (boolean)false);
            if (baseURL != null) {
                URL baseURL2;
                if ("jar".equals(baseURL.getProtocol()) && (baseURL2 = PlatformUI.getWorkbench().getHelpSystem().resolve(baseURL.toExternalForm(), true)) != null) {
                    baseURL = baseURL2;
                }
                return baseURL.toExternalForm();
            }
        } else {
            IPath location;
            IResource resource = element.getResource();
            if (resource != null && (location = resource.getLocation()) != null) {
                return location.toFile().toURI().toString();
            }
        }
        return null;
    }
}

