/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.dialog.workingset;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewScoutWorkingSetDialog
extends Dialog {
    public static final String PROP_WORKING_SET_NAME = "scoutWorkingSetName";
    private final BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);
    private final String[] m_existingSets;

    public NewScoutWorkingSetDialog(Shell parentShell, String[] existing) {
        super(parentShell);
        this.m_existingSets = existing;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Texts.get((String)"NewScoutWorkingSet"));
    }

    public String getWorkingSetName() {
        return this.m_propertySupport.getPropertyString(PROP_WORKING_SET_NAME);
    }

    public void setWorkingSetName(String name) {
        this.m_propertySupport.setProperty(PROP_WORKING_SET_NAME, (Object)name.trim());
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return ret;
    }

    private static boolean isValid(String txt, String[] usedNames) {
        if (!NewScoutWorkingSetDialog.isValid(txt, null)) {
            return false;
        }
        if (usedNames != null && usedNames.length > 0) {
            String[] stringArray = usedNames;
            int n = usedNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (CompareUtility.equals((Object)txt, (Object)s)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean isValid(String txt, String oldName) {
        if (!StringUtility.hasText((String)txt)) {
            return false;
        }
        if (!CompareUtility.equals((Object)txt, (Object)oldName) && PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(txt) != null) {
            return false;
        }
        if (txt.indexOf(44) >= 0) {
            return false;
        }
        return !"Other Projects".equals(txt);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        final TextField f = new TextField(rootArea, Texts.get((String)"Name"));
        String initText = this.getWorkingSetName();
        if (StringUtility.hasText((String)initText)) {
            f.setText(initText);
            f.setSelection(new Point(0, initText.length()));
        }
        f.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newText = f.getText();
                boolean valid = NewScoutWorkingSetDialog.isValid(newText, NewScoutWorkingSetDialog.this.m_existingSets);
                if (valid) {
                    NewScoutWorkingSetDialog.this.setWorkingSetName(newText);
                }
                NewScoutWorkingSetDialog.this.getButton(0).setEnabled(valid);
            }
        });
        GridLayout gl = new GridLayout();
        gl.marginWidth = 15;
        gl.marginHeight = 15;
        rootArea.setLayout((Layout)gl);
        rootArea.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(4);
        gd.widthHint = 190;
        f.setLayoutData(gd);
        return rootArea;
    }
}

