/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.ui.extensions.ICodeIdParser;
import org.eclipse.scout.sdk.ui.extensions.ICodeIdProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public final class CodeIdExtensionPoint {
    private static final String EXTENSION_POINT_NAME = "codeId";
    private static final String CODE_ID_PROVIDER_EXT_NAME = "codeIdProvider";
    private static final String CODE_ID_PARSER_EXT_NAME = "codeIdParser";
    private static final String ATTRIB_CLASS = "class";
    private static final String ATTRIB_GENERIC_TYPE = "genericType";
    private static final String ATTRIB_PRIO = "priority";
    private static final Object codeIdProviderExtensionsCacheLock = new Object();
    private static ICodeIdProvider[] codeIdProviderExtensions;
    private static final Object codeIdParsersExtensionsCacheLock;
    private static HashMap<String, TreeMap<CompositeObject, ICodeIdParser>> codeIdParsers;

    static {
        codeIdParsersExtensionsCacheLock = new Object();
    }

    private CodeIdExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICodeIdProvider[] getCodeIdProviderExtensions() {
        Object object = codeIdProviderExtensionsCacheLock;
        synchronized (object) {
            IExtension[] extensions;
            TreeMap<CompositeObject, ICodeIdProvider> providers = new TreeMap<CompositeObject, ICodeIdProvider>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXTENSION_POINT_NAME);
            IExtension[] iExtensionArray = extensions = xp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] providerElememts = extension.getConfigurationElements();
                int i = 0;
                while (i < providerElememts.length) {
                    IConfigurationElement providerElememt = providerElememts[i];
                    if (CODE_ID_PROVIDER_EXT_NAME.equals(providerElememt.getName())) {
                        String className = providerElememt.getAttribute(ATTRIB_CLASS);
                        ScoutSdkUi.logInfo("found code id provider: " + className);
                        try {
                            ICodeIdProvider provider = (ICodeIdProvider)providerElememt.createExecutableExtension(ATTRIB_CLASS);
                            providers.put(new CompositeObject(new Object[]{CodeIdExtensionPoint.getPriority(providerElememt), i, provider}), provider);
                        }
                        catch (Throwable t) {
                            ScoutSdkUi.logError("register code id provider: " + className, t);
                        }
                    }
                    ++i;
                }
                ++n2;
            }
            codeIdProviderExtensions = providers.values().toArray(new ICodeIdProvider[providers.size()]);
        }
        return codeIdProviderExtensions;
    }

    private static int getPriority(IConfigurationElement element) {
        int priority = 0;
        try {
            String prio = element.getAttribute(ATTRIB_PRIO);
            priority = Integer.MAX_VALUE - Integer.parseInt(prio);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not parse priority of codeId extension '" + element.getName() + "'", e);
        }
        return priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, TreeMap<CompositeObject, ICodeIdParser>> getCodeIdParsers() {
        Object object = codeIdParsersExtensionsCacheLock;
        synchronized (object) {
            if (codeIdParsers == null) {
                IExtension[] extensions;
                HashMap<String, TreeMap<CompositeObject, ICodeIdParser>> parsers = new HashMap<String, TreeMap<CompositeObject, ICodeIdParser>>();
                IExtensionRegistry reg = Platform.getExtensionRegistry();
                IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXTENSION_POINT_NAME);
                IExtension[] iExtensionArray = extensions = xp.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] codeIdElements = extension.getConfigurationElements();
                    int i = 0;
                    while (i < codeIdElements.length) {
                        IConfigurationElement parserElememt = codeIdElements[i];
                        if (CODE_ID_PARSER_EXT_NAME.equals(parserElememt.getName())) {
                            String className = parserElememt.getAttribute(ATTRIB_CLASS);
                            String genericTypeSignature = SignatureCache.createTypeSignature((String)parserElememt.getAttribute(ATTRIB_GENERIC_TYPE));
                            int prio = CodeIdExtensionPoint.getPriority(parserElememt);
                            ScoutSdkUi.logInfo("found code id parser: " + className);
                            try {
                                ICodeIdParser parser = (ICodeIdParser)parserElememt.createExecutableExtension(ATTRIB_CLASS);
                                TreeMap<CompositeObject, ICodeIdParser> typeParsers = (TreeMap<CompositeObject, ICodeIdParser>)parsers.get(genericTypeSignature);
                                if (typeParsers == null) {
                                    typeParsers = new TreeMap<CompositeObject, ICodeIdParser>();
                                    parsers.put(genericTypeSignature, typeParsers);
                                }
                                typeParsers.put(new CompositeObject(new Object[]{prio, i, parser}), parser);
                            }
                            catch (Throwable t) {
                                ScoutSdkUi.logError("register code id parser: " + className, t);
                            }
                        }
                        ++i;
                    }
                    ++n2;
                }
                codeIdParsers = parsers;
            }
            return codeIdParsers;
        }
    }

    public static ICodeIdParser getCodeIdParser(String genericType) {
        TreeMap<CompositeObject, ICodeIdParser> parsers = CodeIdExtensionPoint.getCodeIdParsers().get(genericType);
        if (parsers != null && parsers.size() > 0) {
            return parsers.values().iterator().next();
        }
        return null;
    }

    public static String getNextCodeId(IScoutBundle projectGroup, String genericSignature) {
        ICodeIdProvider[] providers;
        String value = null;
        ICodeIdProvider[] iCodeIdProviderArray = providers = CodeIdExtensionPoint.getCodeIdProviderExtensions();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ICodeIdProvider p = iCodeIdProviderArray[n2];
            try {
                value = p.getNextId(projectGroup, genericSignature);
                if (value != null) {
                    break;
                }
            }
            catch (Exception e) {
                ScoutSdkUi.logWarning("Exception in codeIdExtension '" + p.getClass().getName() + "'", e);
            }
            ++n2;
        }
        return value;
    }
}

